/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.playerviewer.widgets;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.wynntils.screens.base.widgets.WynntilsButton;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.Texture;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;

public abstract class PlayerInteractionButton
extends WynntilsButton {
    protected List<Component> tooltipText;
    protected Texture icon;

    protected PlayerInteractionButton(int x, int y, Component tooltipText, Texture icon) {
        super(x, y, 20, 20, (Component)Component.empty());
        this.tooltipText = List.of(tooltipText);
        this.icon = icon;
    }

    protected PlayerInteractionButton(int x, int y) {
        super(x, y, 20, 20, (Component)Component.empty());
    }

    public void onPress() {
        McUtils.playSoundUI((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value());
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderWidget(guiGraphics, mouseX, mouseY, partialTick);
        RenderSystem.enableDepthTest();
        RenderUtils.drawTexturedRect(guiGraphics.pose(), this.icon.resource(), this.getX() + 3, this.getY() + 3, 2.0f, 14.0f, 14.0f, 0, 0, 14, 14, this.icon.width(), this.icon.height());
        RenderSystem.disableDepthTest();
        if (this.isHovered) {
            McUtils.mc().screen.setTooltipForNextRenderPass(Lists.transform(this.tooltipText, Component::getVisualOrderText));
        }
    }
}

