/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.settings.widgets;

import com.wynntils.core.persisted.config.Config;
import com.wynntils.screens.settings.WynntilsBookSettingsScreen;
import com.wynntils.screens.settings.widgets.GeneralSettingsButton;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.FontRenderer;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;

public class ResetButton
extends GeneralSettingsButton {
    private final Config<?> config;
    private final Runnable onClick;

    ResetButton(Config<?> config, Runnable onClick, int x, int y, int maskTopY, int maskBottomY) {
        Objects.requireNonNull(FontRenderer.getInstance().getFont());
        super(x, y, 35, 9 + 8, (Component)Component.translatable((String)"screens.wynntils.settingsScreen.reset.name"), List.of(Component.translatable((String)"screens.wynntils.settingsScreen.reset.description")), maskTopY, maskBottomY);
        this.config = config;
        this.onClick = onClick;
    }

    @Override
    protected CustomColor getTextColor() {
        return this.config.valueChanged() ? CommonColors.WHITE : CommonColors.GRAY;
    }

    @Override
    protected CustomColor getBackgroundColor() {
        return this.config.valueChanged() ? super.getBackgroundColor() : BACKGROUND_COLOR;
    }

    public void playDownSound(SoundManager handler) {
        if (!this.config.valueChanged()) {
            return;
        }
        super.playDownSound(handler);
    }

    public void onPress() {
        if (!this.config.valueChanged()) {
            return;
        }
        this.config.reset();
        this.onClick.run();
        Screen screen = McUtils.mc().screen;
        if (screen instanceof WynntilsBookSettingsScreen) {
            WynntilsBookSettingsScreen bookSettingsScreen = (WynntilsBookSettingsScreen)screen;
            bookSettingsScreen.populateConfigurables();
        }
    }
}

