/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.statistics.widgets;

import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.core.components.Services;
import com.wynntils.core.text.StyledText;
import com.wynntils.screens.base.TooltipProvider;
import com.wynntils.screens.base.widgets.WynntilsButton;
import com.wynntils.screens.statistics.WynntilsStatisticsScreen;
import com.wynntils.services.statistics.type.StatisticEntry;
import com.wynntils.services.statistics.type.StatisticKind;
import com.wynntils.utils.StringUtils;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.ComponentUtils;
import com.wynntils.utils.mc.KeyboardUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;

public class StatisticButton
extends WynntilsButton
implements TooltipProvider {
    private static final CustomColor BUTTON_COLOR = new CustomColor(181, 174, 151);
    private static final CustomColor BUTTON_COLOR_HOVERED = new CustomColor(121, 116, 101);
    private static final CustomColor TRACKED_BUTTON_COLOR = new CustomColor(176, 197, 148);
    private static final CustomColor TRACKED_BUTTON_COLOR_HOVERED = new CustomColor(126, 211, 106);
    private final StatisticKind statistic;
    private final WynntilsStatisticsScreen screen;

    public StatisticButton(int x, int y, int width, int height, StatisticKind statistic, WynntilsStatisticsScreen screen) {
        super(x, y, width, height, (Component)Component.literal((String)"Statistics Button"));
        this.statistic = statistic;
        this.screen = screen;
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        PoseStack poseStack = guiGraphics.pose();
        CustomColor backgroundColor = this.getButtonBackgroundColor();
        RenderUtils.drawRect(poseStack, backgroundColor, this.getX(), this.getY(), 0.0f, this.width, this.height);
        FontRenderer.getInstance().renderScrollingText(poseStack, StyledText.fromString(this.statistic.getName()), this.getX() + 2, this.getY() + 1, this.width - 3, CommonColors.BLACK, HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.NONE, 1.0f);
    }

    private CustomColor getButtonBackgroundColor() {
        if (this.isSelected()) {
            return this.isHovered ? TRACKED_BUTTON_COLOR_HOVERED : TRACKED_BUTTON_COLOR;
        }
        return this.isHovered ? BUTTON_COLOR_HOVERED : BUTTON_COLOR;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0) {
            if (this.isSelected()) {
                this.screen.setHighlightedStatisticKind(null);
            } else {
                this.screen.setHighlightedStatisticKind(this.statistic);
            }
            return true;
        }
        if (KeyboardUtils.isShiftDown() && button == 2) {
            if (((Boolean)Services.Statistics.screenOverallMode.get()).booleanValue()) {
                Services.Statistics.resetStatisticOverall(this.statistic);
            } else {
                Services.Statistics.resetStatisticForCharacter(this.statistic);
            }
            this.screen.reloadElements();
            return true;
        }
        return true;
    }

    public void onPress() {
    }

    @Override
    public List<Component> getTooltipLines() {
        ArrayList<Component> lines = new ArrayList<Component>();
        StatisticEntry entry = (Boolean)Services.Statistics.screenOverallMode.get() != false ? Services.Statistics.getOverallStatistic(this.statistic) : Services.Statistics.getStatistic(this.statistic);
        lines.add((Component)Component.literal((String)this.statistic.getName()).withStyle(ChatFormatting.BOLD));
        lines.add((Component)Component.translatable((String)"screens.wynntils.statistics.total", (Object[])new Object[]{this.statistic.getFormattedValue(entry.total())}));
        lines.add((Component)Component.translatable((String)"screens.wynntils.statistics.lastModified", (Object[])new Object[]{entry.lastModified() == 0L ? "-" : StringUtils.formatDateTime(entry.lastModified())}));
        lines.add((Component)Component.empty());
        if (this.isSelected()) {
            lines.add((Component)Component.translatable((String)"screens.wynntils.statistics.leftClickToUnselect").withStyle(ChatFormatting.BOLD).withStyle(ChatFormatting.YELLOW));
        } else {
            lines.add((Component)Component.translatable((String)"screens.wynntils.statistics.leftClickToView").withStyle(ChatFormatting.BOLD).withStyle(ChatFormatting.GREEN));
        }
        lines.add((Component)((Boolean)Services.Statistics.screenOverallMode.get() != false ? Component.translatable((String)"screens.wynntils.statistics.shiftMiddleClickToResetOverall") : Component.translatable((String)"screens.wynntils.statistics.shiftMiddleClickToResetCurrent")).withStyle(ChatFormatting.BOLD).withStyle(ChatFormatting.RED));
        return ComponentUtils.wrapTooltips(lines, 250);
    }

    private boolean isSelected() {
        return this.screen.getHighlightedStatisticKind() == this.statistic;
    }
}

