/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.territorymanagement.widgets;

import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Models;
import com.wynntils.features.ui.CustomTerritoryManagementScreenFeature;
import com.wynntils.models.territories.type.GuildResource;
import com.wynntils.screens.territorymanagement.TerritoryManagementHolder;
import com.wynntils.utils.mc.KeyboardUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.type.CappedValue;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class GuildOverallProductionWidget
extends AbstractWidget {
    private final TerritoryManagementHolder holder;

    public GuildOverallProductionWidget(int x, int y, int width, int height, TerritoryManagementHolder holder) {
        super(x, y, width, height, (Component)Component.literal((String)"Guild Overall Production"));
        this.holder = holder;
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (!((Boolean)Managers.Feature.getFeatureInstance(CustomTerritoryManagementScreenFeature.class).screenTerritoryProductionTooltip.get()).booleanValue()) {
            return;
        }
        int emeraldProduction = this.holder.getOverallProductionForResource(GuildResource.EMERALDS) + Models.Guild.getReceivedTributesForResource(GuildResource.EMERALDS);
        int oreProduction = this.holder.getOverallProductionForResource(GuildResource.ORE) + Models.Guild.getReceivedTributesForResource(GuildResource.ORE);
        int woodProduction = this.holder.getOverallProductionForResource(GuildResource.WOOD) + Models.Guild.getReceivedTributesForResource(GuildResource.WOOD);
        int fishProduction = this.holder.getOverallProductionForResource(GuildResource.FISH) + Models.Guild.getReceivedTributesForResource(GuildResource.FISH);
        int cropsProduction = this.holder.getOverallProductionForResource(GuildResource.CROPS) + Models.Guild.getReceivedTributesForResource(GuildResource.CROPS);
        CappedValue emeraldStorage = this.holder.getOverallStorageForResource(GuildResource.EMERALDS);
        CappedValue oreStorage = this.holder.getOverallStorageForResource(GuildResource.ORE);
        CappedValue woodStorage = this.holder.getOverallStorageForResource(GuildResource.WOOD);
        CappedValue fishStorage = this.holder.getOverallStorageForResource(GuildResource.FISH);
        CappedValue cropsStorage = this.holder.getOverallStorageForResource(GuildResource.CROPS);
        long emeraldUsage = this.holder.getOverallUsageForResource(GuildResource.EMERALDS) + (long)Models.Guild.getSentTributesForResource(GuildResource.EMERALDS);
        long oreUsage = this.holder.getOverallUsageForResource(GuildResource.ORE) + (long)Models.Guild.getSentTributesForResource(GuildResource.ORE);
        long woodUsage = this.holder.getOverallUsageForResource(GuildResource.WOOD) + (long)Models.Guild.getSentTributesForResource(GuildResource.WOOD);
        long fishUsage = this.holder.getOverallUsageForResource(GuildResource.FISH) + (long)Models.Guild.getSentTributesForResource(GuildResource.FISH);
        long cropsUsage = this.holder.getOverallUsageForResource(GuildResource.CROPS) + (long)Models.Guild.getSentTributesForResource(GuildResource.CROPS);
        ArrayList<MutableComponent> lines = new ArrayList<MutableComponent>();
        lines.add(Component.literal((String)"Guild Output").withStyle(new ChatFormatting[]{ChatFormatting.WHITE, ChatFormatting.BOLD}));
        lines.add(Component.literal((String)""));
        lines.add(Component.literal((String)"Total resource output").withStyle(ChatFormatting.GRAY));
        lines.add(Component.literal((String)""));
        lines.add(Component.literal((String)"+%d Emeralds per Hour".formatted(emeraldProduction)).withStyle(ChatFormatting.GREEN));
        lines.add(Component.literal((String)"%s in storage".formatted(emeraldStorage)).withStyle(ChatFormatting.GREEN));
        lines.add(Component.literal((String)"\u24b7 +%d Ore per Hour".formatted(oreProduction)).withStyle(ChatFormatting.WHITE));
        lines.add(Component.literal((String)"\u24b7 %s in storage".formatted(oreStorage)).withStyle(ChatFormatting.WHITE));
        lines.add(Component.literal((String)"\u24b8 +%d Wood per Hour".formatted(woodProduction)).withStyle(ChatFormatting.GOLD));
        lines.add(Component.literal((String)"\u24b8 %s in storage".formatted(woodStorage)).withStyle(ChatFormatting.GOLD));
        lines.add(Component.literal((String)"\u24c0 +%d Fish per Hour".formatted(fishProduction)).withStyle(ChatFormatting.AQUA));
        lines.add(Component.literal((String)"\u24c0 %s in storage".formatted(fishStorage)).withStyle(ChatFormatting.AQUA));
        lines.add(Component.literal((String)"\u24bf +%d Crops per Hour".formatted(cropsProduction)).withStyle(ChatFormatting.YELLOW));
        lines.add(Component.literal((String)"\u24bf %s in storage".formatted(cropsStorage)).withStyle(ChatFormatting.YELLOW));
        lines.add(Component.literal((String)""));
        if (KeyboardUtils.isShiftDown()) {
            lines.add(Component.literal((String)"Surplus/Deficit (per hour):").withStyle(ChatFormatting.GRAY));
            lines.add(Component.literal((String)"- %d Emeralds".formatted((long)emeraldProduction - emeraldUsage)).withStyle(ChatFormatting.GREEN));
            lines.add(Component.literal((String)"- \u24b7 %d Ore".formatted((long)oreProduction - oreUsage)).withStyle(ChatFormatting.WHITE));
            lines.add(Component.literal((String)"- \u24b8 %d Wood".formatted((long)woodProduction - woodUsage)).withStyle(ChatFormatting.GOLD));
            lines.add(Component.literal((String)"- \u24c0 %d Fish".formatted((long)fishProduction - fishUsage)).withStyle(ChatFormatting.AQUA));
            lines.add(Component.literal((String)"- \u24bf %d Crops".formatted((long)cropsProduction - cropsUsage)).withStyle(ChatFormatting.YELLOW));
        } else {
            lines.add(Component.literal((String)"Overall Cost (per hour):").withStyle(ChatFormatting.GRAY));
            lines.add(Component.literal((String)"- %d Emeralds (%.1f%%)".formatted(emeraldUsage, (double)emeraldUsage / (double)emeraldProduction * 100.0)).withStyle(ChatFormatting.GREEN));
            lines.add(Component.literal((String)"- \u24b7 %d Ore (%.1f%%)".formatted(oreUsage, (double)oreUsage / (double)oreProduction * 100.0)).withStyle(ChatFormatting.WHITE));
            lines.add(Component.literal((String)"- \u24b8 %d Wood (%.1f%%)".formatted(woodUsage, (double)woodUsage / (double)woodProduction * 100.0)).withStyle(ChatFormatting.GOLD));
            lines.add(Component.literal((String)"- \u24c0 %d Fish (%.1f%%)".formatted(fishUsage, (double)fishUsage / (double)fishProduction * 100.0)).withStyle(ChatFormatting.AQUA));
            lines.add(Component.literal((String)"- \u24bf %d Crops (%.1f%%)".formatted(cropsUsage, (double)cropsUsage / (double)cropsProduction * 100.0)).withStyle(ChatFormatting.YELLOW));
        }
        guiGraphics.renderComponentTooltip(FontRenderer.getInstance().getFont(), lines, this.getX(), this.getY());
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return false;
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }
}

