/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.territorymanagement.widgets.quickfilters;

import com.wynntils.core.components.Services;
import com.wynntils.core.text.StyledText;
import com.wynntils.screens.territorymanagement.TerritoryManagementScreen;
import com.wynntils.services.itemfilter.type.StatProviderAndFilterPair;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public abstract class TerritoryQuickFilterWidget
extends AbstractWidget {
    private final TerritoryManagementScreen screen;

    protected TerritoryQuickFilterWidget(int x, int y, int width, int height, TerritoryManagementScreen screen) {
        super(x, y, width, height, (Component)Component.empty());
        this.screen = screen;
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        boolean isHovered = this.isMouseOver(mouseX, mouseY);
        FontRenderer.getInstance().renderText(guiGraphics.pose(), StyledText.fromComponent((Component)this.getFilterName().withStyle(isHovered ? ChatFormatting.BOLD : ChatFormatting.RESET)), this.getX() + 5, this.getY() + 5, this.getFilterColor(), HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.OUTLINE);
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        boolean clicked;
        if (!this.active || !this.visible) {
            return false;
        }
        if (this.isValidClickButton(button) && (clicked = this.isMouseOver(mouseX, mouseY))) {
            this.playDownSound(Minecraft.getInstance().getSoundManager());
            if (button == 0) {
                this.forwardClick();
            } else if (button == 1) {
                this.backwardClick();
            } else if (button == 2) {
                this.resetClick();
            }
            this.screen.updateSearchFromQuickFilters();
            return true;
        }
        return false;
    }

    protected boolean isValidClickButton(int button) {
        return button == 0 || button == 1 || button == 2;
    }

    public final String getItemSearchQuery() {
        HashMap filterMap = new HashMap();
        for (StatProviderAndFilterPair filter : this.getFilters()) {
            filterMap.computeIfAbsent(filter.statProvider(), k -> new ArrayList()).add(filter);
        }
        return Services.ItemFilter.getItemFilterString(filterMap, List.of(), List.of());
    }

    protected abstract void forwardClick();

    protected abstract void backwardClick();

    protected abstract void resetClick();

    protected abstract MutableComponent getFilterName();

    protected abstract CustomColor getFilterColor();

    protected abstract List<StatProviderAndFilterPair> getFilters();
}

