/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.trademarket;

import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.core.components.Models;
import com.wynntils.handlers.wrappedscreen.WrappedScreen;
import com.wynntils.handlers.wrappedscreen.type.WrappedScreenInfo;
import com.wynntils.screens.base.TextboxScreen;
import com.wynntils.screens.base.TooltipProvider;
import com.wynntils.screens.base.WynntilsContainerScreen;
import com.wynntils.screens.base.widgets.BasicTexturedButton;
import com.wynntils.screens.base.widgets.ItemFilterUIButton;
import com.wynntils.screens.base.widgets.ItemSearchHelperWidget;
import com.wynntils.screens.base.widgets.ItemSearchWidget;
import com.wynntils.screens.trademarket.TradeMarketSearchResultHolder;
import com.wynntils.screens.trademarket.widgets.PresetButton;
import com.wynntils.services.itemfilter.type.ItemProviderType;
import com.wynntils.services.itemfilter.type.ItemSearchQuery;
import com.wynntils.utils.MathUtils;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.Texture;
import java.util.Arrays;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;

public class TradeMarketSearchResultScreen
extends WynntilsContainerScreen<ChestMenu>
implements WrappedScreen {
    private static final int FAKE_CONTAINER_ID = 454545;
    private static final ResourceLocation CONTAINER_BACKGROUND = ResourceLocation.withDefaultNamespace((String)"textures/gui/container/generic_54.png");
    private static final int SCROLL_AREA_HEIGHT = 110;
    private static final int ITEMS_PER_PAGE = 54;
    private final TradeMarketSearchResultHolder holder;
    private final WrappedScreenInfo wrappedScreenInfo;
    private ItemSearchWidget itemSearchWidget;
    private BasicTexturedButton sortOptionsButton;
    private Component currentState = Component.empty();
    private int scrollOffset = 0;
    private boolean holdingScrollbar = false;

    protected TradeMarketSearchResultScreen(WrappedScreenInfo wrappedScreenInfo, TradeMarketSearchResultHolder holder) {
        super(ChestMenu.sixRows((int)454545, (Inventory)McUtils.inventory()), McUtils.inventory(), (Component)Component.literal((String)"Trade Market Search Result Wrapped Screen"));
        this.imageHeight = 114 + ((ChestMenu)this.getMenu()).getRowCount() * 18;
        this.inventoryLabelY = this.imageHeight - 94;
        this.holder = holder;
        this.wrappedScreenInfo = wrappedScreenInfo;
    }

    @Override
    public WrappedScreenInfo getWrappedScreenInfo() {
        return this.wrappedScreenInfo;
    }

    @Override
    protected void doInit() {
        super.doInit();
        int renderX = (this.width - this.imageWidth) / 2;
        int renderY = (this.height - this.imageHeight) / 2 - 22;
        this.itemSearchWidget = new ItemSearchWidget(renderX, renderY, 155, 20, ItemProviderType.normalTypes(), true, query -> {
            this.saveSearchFilter((ItemSearchQuery)query);
            this.reloadElements();
        }, (TextboxScreen)((Object)this));
        this.addRenderableWidget((GuiEventListener)this.itemSearchWidget);
        this.itemSearchWidget.setTextBoxInput(Models.TradeMarket.getLastSearchFilter());
        this.addRenderableWidget((GuiEventListener)new ItemFilterUIButton(renderX + 157, renderY, this.itemSearchWidget, (Screen)this, true, Arrays.stream(ItemProviderType.values()).toList()));
        BasicTexturedButton backButton = new BasicTexturedButton(renderX - Texture.CONTAINER_SIDEBAR.width() / 2 - 2, renderY + Texture.CONTAINER_SIDEBAR.height(), Texture.ARROW_LEFT_ICON.width(), Texture.ARROW_LEFT_ICON.height(), Texture.ARROW_LEFT_ICON, button -> this.holder.goBackToSearch(), List.of(Component.translatable((String)"screens.wynntils.tradeMarketSearchResult.backToSearch").withStyle(ChatFormatting.BOLD)));
        this.addRenderableWidget((GuiEventListener)backButton);
        BasicTexturedButton loadMoreButton = new BasicTexturedButton(renderX - Texture.CONTAINER_SIDEBAR.width() / 2 - 2, renderY + Texture.CONTAINER_SIDEBAR.height() - 17, Texture.SMALL_ADD_ICON.width(), Texture.SMALL_ADD_ICON.height(), Texture.SMALL_ADD_ICON, button -> this.holder.loadNextPageBatch(), List.of(Component.translatable((String)"screens.wynntils.tradeMarketSearchResult.loadNextBatch", (Object[])new Object[]{this.holder.getPageLoadBatchSize()}).withStyle(ChatFormatting.BOLD)));
        this.addRenderableWidget((GuiEventListener)loadMoreButton);
        this.sortOptionsButton = new BasicTexturedButton(renderX - Texture.CONTAINER_SIDEBAR.width() / 2 - 2, renderY + Texture.CONTAINER_SIDEBAR.height() - 34, Texture.SORT.width(), Texture.SORT.height(), Texture.SORT, this.holder::changeSortingMode, this.holder.getSortingItemTooltip());
        this.addRenderableWidget((GuiEventListener)this.sortOptionsButton);
        for (int i = 0; i < 4; ++i) {
            this.addRenderableWidget((GuiEventListener)new PresetButton(renderX - Texture.CONTAINER_SIDEBAR.width() / 2 - 2, renderY + 25 + i * (Texture.PRESET.height() + 2), Texture.PRESET.width(), Texture.PRESET.height(), i, this));
        }
    }

    @Override
    public void doRender(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        PoseStack poseStack = guiGraphics.pose();
        this.updateItems();
        super.doRender(guiGraphics, mouseX, mouseY, partialTick);
        this.renderScrollButton(poseStack);
        this.renderables.forEach(c -> c.render(guiGraphics, mouseX, mouseY, partialTick));
        super.renderTooltip(guiGraphics, mouseX, mouseY);
        for (GuiEventListener child : this.children()) {
            if (!(child instanceof TooltipProvider)) continue;
            TooltipProvider tooltipProvider = (TooltipProvider)child;
            if (!child.isMouseOver((double)mouseX, (double)mouseY)) continue;
            guiGraphics.renderComponentTooltip(FontRenderer.getInstance().getFont(), tooltipProvider.getTooltipLines(), mouseX, mouseY);
            break;
        }
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(FontRenderer.getInstance().getFont(), this.currentState, this.titleLabelX, this.titleLabelY, CommonColors.TITLE_GRAY.asInt(), false);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        PoseStack poseStack = guiGraphics.pose();
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        RenderUtils.drawTexturedRect(poseStack, CONTAINER_BACKGROUND, x, y, this.imageWidth, ((ChestMenu)this.menu).getRowCount() * 18 + 17, 256, 256);
        RenderUtils.drawTexturedRect(poseStack, CONTAINER_BACKGROUND, x, y + ((ChestMenu)this.menu).getRowCount() * 18 + 17, 0.0f, this.imageWidth, 96.0f, 0, 126, this.imageWidth, 96, 256, 256);
        RenderUtils.drawTexturedRect(poseStack, Texture.SCROLLBAR_BACKGROUND, x + this.imageWidth - 7, y);
        RenderUtils.drawTexturedRect(poseStack, Texture.CONTAINER_SIDEBAR, x - Texture.CONTAINER_SIDEBAR.width() + 7, y);
    }

    private void renderScrollButton(PoseStack poseStack) {
        float renderX = (this.width - this.imageWidth) / 2 + this.imageWidth + Texture.SCROLLBAR_BACKGROUND.width() / 2 - 14;
        float renderY = (float)((this.height - this.imageHeight) / 2 + Texture.SCROLLBAR_BUTTON.height() / 2) + MathUtils.map(this.scrollOffset, 0.0f, this.getMaxScrollOffset(), 0.0f, 110.0f);
        RenderUtils.drawTexturedRect(poseStack, Texture.SCROLLBAR_BUTTON, renderX, renderY);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        float scrollBarRenderX = (this.width - this.imageWidth) / 2 + this.imageWidth + Texture.SCROLLBAR_BACKGROUND.width() / 2 - 14;
        float scrollBarRenderY = (float)((this.height - this.imageHeight) / 2 + Texture.SCROLLBAR_BUTTON.height() / 2) + MathUtils.map(this.scrollOffset, 0.0f, this.getMaxScrollOffset(), 0.0f, 110.0f);
        if (mouseX >= (double)scrollBarRenderX && mouseX <= (double)(scrollBarRenderX + (float)Texture.SCROLLBAR_BUTTON.width()) && mouseY >= (double)scrollBarRenderY && mouseY <= (double)(scrollBarRenderY + (float)Texture.SCROLLBAR_BUTTON.height())) {
            this.holdingScrollbar = true;
            return true;
        }
        if (this.hoveredSlot != null) {
            this.holder.clickOnItem(this.hoveredSlot.getItem());
            return true;
        }
        for (GuiEventListener child : this.children()) {
            if (!(child instanceof ItemSearchHelperWidget) || !child.mouseClicked(mouseX, mouseY, button)) continue;
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (!this.holdingScrollbar) {
            return false;
        }
        int renderY = (this.height - this.imageHeight) / 2;
        int scrollAreaStartY = renderY + 14;
        int newValue = Math.round(MathUtils.map((float)mouseY, scrollAreaStartY, scrollAreaStartY + 110, 0.0f, this.getMaxScrollOffset()));
        this.scroll(newValue - this.scrollOffset);
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.holdingScrollbar = false;
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        double scrollValue = -Math.signum(deltaY);
        this.scroll((int)scrollValue);
        return super.mouseScrolled(mouseX, mouseY, deltaX, deltaY);
    }

    public void setSearchQuery(String query) {
        this.itemSearchWidget.setTextBoxInput(query);
    }

    public ItemSearchQuery getSearchQuery() {
        return this.itemSearchWidget.getSearchQuery();
    }

    public void onSortingModeChanged() {
        this.sortOptionsButton.setTooltip(this.holder.getSortingItemTooltip());
    }

    private void scroll(int delta) {
        int maxValue = this.getMaxScrollOffset();
        this.scrollOffset = MathUtils.clamp(this.scrollOffset + delta, 0, maxValue);
    }

    private int getMaxScrollOffset() {
        int maxItemOffset = Math.max(0, this.holder.getFilteredItems().size() - 54);
        int maxValue = maxItemOffset / 9 + (maxItemOffset % 9 > 0 ? 1 : 0);
        return maxValue;
    }

    private void updateItems() {
        List<ItemStack> filteredItems = this.holder.getFilteredItems();
        for (int i = 0; i < 54; ++i) {
            ((ChestMenu)this.menu).setItem(i, 0, ItemStack.EMPTY);
        }
        int itemIndex = this.scrollOffset * 9;
        for (int currentSlot = 0; itemIndex < filteredItems.size() && currentSlot < 54; ++itemIndex, ++currentSlot) {
            ItemStack itemStack = filteredItems.get(itemIndex);
            ((ChestMenu)this.menu).setItem(currentSlot, 0, itemStack);
        }
    }

    protected void setCurrentState(Component currentState) {
        this.currentState = currentState;
    }

    private void reloadElements() {
        this.holder.updateDisplayItems(this.itemSearchWidget.getSearchQuery());
        this.scrollOffset = 0;
    }

    private void saveSearchFilter(ItemSearchQuery query) {
        Models.TradeMarket.setLastSearchFilter(query.queryString());
    }
}

