/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.trademarket.widgets;

import com.wynntils.core.components.Models;
import com.wynntils.screens.base.TooltipProvider;
import com.wynntils.screens.base.widgets.WynntilsButton;
import com.wynntils.screens.trademarket.TradeMarketSearchResultScreen;
import com.wynntils.utils.mc.RenderedStringUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.Texture;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;

public class PresetButton
extends WynntilsButton
implements TooltipProvider {
    private final int presetId;
    private final TradeMarketSearchResultScreen tradeMarketSearchResultScreen;

    public PresetButton(int x, int y, int width, int height, int presetId, TradeMarketSearchResultScreen screen) {
        super(x, y, width, height, (Component)Component.literal((String)"Preset Button"));
        this.presetId = presetId;
        this.tradeMarketSearchResultScreen = screen;
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        Texture itemTexture = this.isSavedPreset() ? Texture.SAVED_PRESET : Texture.PRESET;
        RenderUtils.drawTexturedRect(guiGraphics.pose(), itemTexture, this.getX(), this.getY());
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.isMouseOver(mouseX, mouseY)) {
            return false;
        }
        if (button == 0) {
            String lastSearchFilter = this.tradeMarketSearchResultScreen.getSearchQuery().queryString();
            if (lastSearchFilter.isEmpty()) {
                return true;
            }
            Models.TradeMarket.setPresetFilter(this.presetId, lastSearchFilter);
            return true;
        }
        if (button == 1) {
            Optional<String> presetFilterOpt = Models.TradeMarket.getPresetFilter(this.presetId);
            if (presetFilterOpt.isEmpty()) {
                return true;
            }
            String filter = presetFilterOpt.get();
            this.tradeMarketSearchResultScreen.setSearchQuery(filter);
            return true;
        }
        return false;
    }

    public void onPress() {
    }

    @Override
    public List<Component> getTooltipLines() {
        ArrayList<Component> list = new ArrayList<Component>();
        if (this.isSavedPreset()) {
            list.add((Component)Component.translatable((String)"screens.wynntils.tradeMarketSearchResult.button.savedPreset", (Object[])new Object[]{this.presetId + 1}).withStyle(ChatFormatting.BOLD).withStyle(ChatFormatting.YELLOW));
        } else {
            list.add((Component)Component.translatable((String)"screens.wynntils.tradeMarketSearchResult.button.preset", (Object[])new Object[]{this.presetId + 1}).withStyle(ChatFormatting.BOLD));
        }
        list.add((Component)Component.empty());
        if (this.isSavedPreset()) {
            Models.TradeMarket.getPresetFilter(this.presetId).ifPresent(presetString -> {
                list.add((Component)Component.literal((String)RenderedStringUtils.getMaxFittingText(presetString, 150.0f, FontRenderer.getInstance().getFont())).withStyle(ChatFormatting.GRAY));
                list.add((Component)Component.empty());
            });
        }
        list.add((Component)Component.translatable((String)"screens.wynntils.tradeMarketSearchResult.button.clickToSave").withStyle(ChatFormatting.GREEN));
        list.add((Component)Component.translatable((String)"screens.wynntils.tradeMarketSearchResult.button.clickToLoad").withStyle(ChatFormatting.YELLOW));
        return list;
    }

    private boolean isSavedPreset() {
        return Models.TradeMarket.getPresetFilter(this.presetId).isPresent();
    }
}

