/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.screens.wynntilsmenu;

import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Models;
import com.wynntils.core.components.Services;
import com.wynntils.core.text.StyledText;
import com.wynntils.features.map.MainMapFeature;
import com.wynntils.features.ui.WynntilsContentBookFeature;
import com.wynntils.screens.base.WynntilsMenuScreenBase;
import com.wynntils.screens.crowdsourcing.WynntilsCrowdSourcingSettingsScreen;
import com.wynntils.screens.downloads.DownloadScreen;
import com.wynntils.screens.guides.WynntilsGuidesListScreen;
import com.wynntils.screens.itemsharing.SavedItemsScreen;
import com.wynntils.screens.lootrunpaths.WynntilsLootrunPathsScreen;
import com.wynntils.screens.maps.MainMapScreen;
import com.wynntils.screens.maps.PoiManagementScreen;
import com.wynntils.screens.overlays.selection.OverlaySelectionScreen;
import com.wynntils.screens.settings.WynntilsBookSettingsScreen;
import com.wynntils.screens.statistics.WynntilsStatisticsScreen;
import com.wynntils.screens.wynntilsmenu.widgets.WynntilsMenuButton;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.mc.ComponentUtils;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.mc.RenderedStringUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import com.wynntils.utils.type.CappedValue;
import com.wynntils.utils.wynn.ContainerUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;

public final class WynntilsMenuScreen
extends WynntilsMenuScreenBase {
    private static final int BUTTON_SIZE = 30;
    private final List<List<WynntilsMenuButton>> buttons = new ArrayList<List<WynntilsMenuButton>>();
    private WynntilsMenuButton hovered = null;
    private static final Screen overlayScreenInstance = OverlaySelectionScreen.create();
    private static final Screen settingsScreenInstance = WynntilsBookSettingsScreen.create(null);

    private WynntilsMenuScreen() {
        super((Component)Component.translatable((String)"screens.wynntils.wynntilsMenu.name"));
    }

    public static Screen create() {
        return new WynntilsMenuScreen();
    }

    @Override
    protected void doInit() {
        super.doInit();
        this.setup();
    }

    private void setup() {
        this.buttons.clear();
        for (int i = 0; i < 4; ++i) {
            this.buttons.add(new ArrayList());
        }
        int x = 35 + this.offsetX - 15;
        int y = 35 + this.offsetY + 15;
        this.buttons.getFirst().add(new WynntilsMenuButton(x, y, 30, Texture.QUEST_BOOK_ICON, true, () -> ContainerUtils.openInventory(8), List.of(Component.literal((String)"[>] ").withStyle(ChatFormatting.GOLD).append((Component)Component.translatable((String)"screens.wynntils.wynntilsMenu.questBook.name").withStyle(ChatFormatting.BOLD).withStyle(ChatFormatting.GOLD)), Component.translatable((String)"screens.wynntils.wynntilsMenu.questBook.description").withStyle(ChatFormatting.GRAY), Component.literal((String)""), Component.translatable((String)"screens.wynntils.wynntilsMenu.leftClickToSelect").withStyle(ChatFormatting.GREEN))));
        x = 35 + this.offsetX - 15;
        y += 35;
        if (Managers.Feature.getFeatureInstance(MainMapFeature.class).isEnabled()) {
            this.buttons.get(1).add(new WynntilsMenuButton(x, y, 30, Texture.MAP_ICON, true, MainMapScreen.create(), List.of(Component.literal((String)"[>] ").withStyle(ChatFormatting.GOLD).append((Component)Component.translatable((String)"screens.wynntils.wynntilsQuestBook.mainMap.name").withStyle(ChatFormatting.BOLD).withStyle(ChatFormatting.GOLD)), Component.translatable((String)"screens.wynntils.wynntilsQuestBook.mainMap.description").withStyle(ChatFormatting.GRAY), Component.literal((String)""), Component.translatable((String)"screens.wynntils.wynntilsMenu.leftClickToSelect").withStyle(ChatFormatting.GREEN))));
        }
        this.buttons.get(1).add(new WynntilsMenuButton(x += 35, y, 30, Texture.LOOTRUN_ICON, true, WynntilsLootrunPathsScreen.create(), List.of(Component.literal((String)"[>] ").withStyle(ChatFormatting.GOLD).append((Component)Component.translatable((String)"screens.wynntils.wynntilsQuestBook.lootruns.name").withStyle(ChatFormatting.BOLD).withStyle(ChatFormatting.GOLD)), Component.translatable((String)"screens.wynntils.wynntilsQuestBook.lootruns.description").withStyle(ChatFormatting.GRAY), Component.literal((String)""), Component.translatable((String)"screens.wynntils.wynntilsMenu.leftClickToSelect").withStyle(ChatFormatting.GREEN))));
        this.buttons.get(1).add(new WynntilsMenuButton(x += 35, y, 30, Texture.WAYPOINT_MANAGER_ICON, false, PoiManagementScreen.create(), List.of(Component.literal((String)"[>] ").withStyle(ChatFormatting.GOLD).withStyle(ChatFormatting.BOLD).append((Component)Component.translatable((String)"screens.wynntils.map.manager.name")), Component.translatable((String)"screens.wynntils.map.manager.description").withStyle(ChatFormatting.GRAY), Component.literal((String)""), Component.translatable((String)"screens.wynntils.wynntilsMenu.leftClickToSelect").withStyle(ChatFormatting.GREEN))));
        x = 35 + this.offsetX - 15;
        this.buttons.get(2).add(new WynntilsMenuButton(x, y += 35, 30, Texture.GUIDES_ICON, true, WynntilsGuidesListScreen.create(), List.of(Component.literal((String)"[>] ").withStyle(ChatFormatting.GOLD).append((Component)Component.translatable((String)"screens.wynntils.wynntilsGuides.name").withStyle(ChatFormatting.BOLD).withStyle(ChatFormatting.GOLD)), Component.translatable((String)"screens.wynntils.wynntilsGuides.description").withStyle(ChatFormatting.GRAY), Component.literal((String)""), Component.translatable((String)"screens.wynntils.wynntilsMenu.leftClickToSelect").withStyle(ChatFormatting.GREEN))));
        this.buttons.get(2).add(new WynntilsMenuButton(x += 35, y, 30, Texture.FAVORITE_ICON, false, WynntilsStatisticsScreen.create(), List.of(Component.literal((String)"[>] ").withStyle(ChatFormatting.GOLD).append((Component)Component.translatable((String)"screens.wynntils.statistics.name").withStyle(ChatFormatting.BOLD).withStyle(ChatFormatting.GOLD)), Component.translatable((String)"screens.wynntils.statistics.description").withStyle(ChatFormatting.GRAY), Component.literal((String)""), Component.translatable((String)"screens.wynntils.wynntilsMenu.leftClickToSelect").withStyle(ChatFormatting.GREEN))));
        this.buttons.get(2).add(new WynntilsMenuButton(x += 35, y, 30, Texture.ITEM_LOCK, false, SavedItemsScreen.create(), List.of(Component.literal((String)"[>] ").withStyle(ChatFormatting.GOLD).append((Component)Component.translatable((String)"screens.wynntils.savedItems.name").withStyle(ChatFormatting.BOLD).withStyle(ChatFormatting.GOLD)), Component.translatable((String)"screens.wynntils.savedItems.description").withStyle(ChatFormatting.GRAY), Component.literal((String)""), Component.translatable((String)"screens.wynntils.wynntilsMenu.leftClickToSelect").withStyle(ChatFormatting.GREEN))));
        x = 35 + this.offsetX - 15;
        this.buttons.get(3).add(new WynntilsMenuButton(x, y += 35, 30, Texture.SETTINGS_ICON, true, settingsScreenInstance, List.of(Component.literal((String)"[>] ").withStyle(ChatFormatting.GOLD).append((Component)Component.translatable((String)"screens.wynntils.wynntilsMenu.configs.name").withStyle(ChatFormatting.BOLD).withStyle(ChatFormatting.GOLD)), Component.translatable((String)"screens.wynntils.wynntilsMenu.configs.description").withStyle(ChatFormatting.GRAY), Component.literal((String)""), Component.translatable((String)"screens.wynntils.wynntilsMenu.leftClickToSelect").withStyle(ChatFormatting.GREEN))));
        this.buttons.get(3).add(new WynntilsMenuButton(x += 35, y, 30, Texture.OVERLAYS_ICON, true, overlayScreenInstance, List.of(Component.literal((String)"[>] ").withStyle(ChatFormatting.GOLD).append((Component)Component.translatable((String)"screens.wynntils.wynntilsMenu.overlayConfig.name").withStyle(ChatFormatting.BOLD).withStyle(ChatFormatting.GOLD)), Component.translatable((String)"screens.wynntils.wynntilsMenu.overlayConfig.description").withStyle(ChatFormatting.GRAY), Component.literal((String)""), Component.translatable((String)"screens.wynntils.wynntilsMenu.leftClickToSelect").withStyle(ChatFormatting.GREEN))));
        this.buttons.get(3).add(new WynntilsMenuButton(x += 35, y, 30, Texture.SHARE_ICON, false, WynntilsCrowdSourcingSettingsScreen.create(), List.of(Component.literal((String)"[>] ").withStyle(ChatFormatting.GOLD).append((Component)Component.translatable((String)"screens.wynntils.wynntilsMenu.crowdSourcing.name").withStyle(ChatFormatting.BOLD).withStyle(ChatFormatting.GOLD)), Component.translatable((String)"screens.wynntils.wynntilsMenu.crowdSourcing.description").withStyle(ChatFormatting.GRAY), Component.literal((String)""), Component.translatable((String)"screens.wynntils.wynntilsMenu.leftClickToSelect").withStyle(ChatFormatting.GREEN))));
        this.buttons.get(3).add(new WynntilsMenuButton(x += 35, y, 30, Texture.EDIT_NAME_ICON, false, DownloadScreen.create(null, null), List.of(Component.literal((String)"[>] ").withStyle(ChatFormatting.GOLD).append((Component)Component.translatable((String)"screens.wynntils.wynntilsMenu.downloads.name").withStyle(ChatFormatting.BOLD).withStyle(ChatFormatting.GOLD)), Component.translatable((String)"screens.wynntils.wynntilsMenu.downloads.description").withStyle(ChatFormatting.GRAY), Component.literal((String)""), Component.translatable((String)"screens.wynntils.wynntilsMenu.leftClickToSelect").withStyle(ChatFormatting.GREEN))));
        assert (this.buttons.size() == 4 && this.buttons.stream().allMatch(row -> row.size() <= 4));
    }

    @Override
    public void doRender(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        PoseStack poseStack = guiGraphics.pose();
        this.renderBackgroundTexture(poseStack);
        this.renderTitle(poseStack, I18n.get((String)"screens.wynntils.wynntilsMenu.userProfile", (Object[])new Object[0]));
        this.renderVersion(poseStack);
        this.renderWidgets(guiGraphics, mouseX, mouseY, partialTick);
        this.renderPlayerInfo(guiGraphics, mouseX, mouseY);
        this.renderPlayer(guiGraphics, mouseX, mouseY);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    @Override
    protected void renderTitle(PoseStack poseStack, String titleString) {
        int txWidth = Texture.CONTENT_BOOK_TITLE.width();
        int txHeight = Texture.CONTENT_BOOK_TITLE.height();
        RenderUtils.drawScalingTexturedRect(poseStack, Texture.CONTENT_BOOK_TITLE.resource(), this.offsetX, 15 + this.offsetY, 0.0f, txWidth, txHeight, txWidth, txHeight);
        FontRenderer.getInstance().renderText(poseStack, StyledText.fromString(titleString), (float)(10 + this.offsetX), (float)(21 + this.offsetY), CommonColors.YELLOW, HorizontalAlignment.LEFT, VerticalAlignment.TOP, TextShadow.NORMAL, 2.0f);
    }

    private void renderPlayerInfo(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        PoseStack poseStack = guiGraphics.pose();
        if (!Models.Guild.getGuildName().isEmpty()) {
            String rank = Models.Guild.getGuildRank().getGuildDescription();
            FontRenderer.getInstance().renderAlignedTextInBox(poseStack, StyledText.fromString(rank + " of"), (float)Texture.CONTENT_BOOK_BACKGROUND.width() / 2.0f + (float)this.offsetX, (float)(Texture.CONTENT_BOOK_BACKGROUND.width() + this.offsetX), (float)(40 + this.offsetY), 0.0f, CommonColors.CYAN, HorizontalAlignment.CENTER, TextShadow.NONE);
            FontRenderer.getInstance().renderAlignedTextInBox(poseStack, StyledText.fromString(Models.Guild.getGuildName()), (float)Texture.CONTENT_BOOK_BACKGROUND.width() / 2.0f + (float)this.offsetX, (float)(Texture.CONTENT_BOOK_BACKGROUND.width() + this.offsetX), (float)(50 + this.offsetY), 0.0f, CommonColors.CYAN, HorizontalAlignment.CENTER, TextShadow.NONE);
        }
        FontRenderer.getInstance().renderAlignedTextInBox(poseStack, StyledText.fromComponent(McUtils.player().getDisplayName()).withoutFormatting(), (float)Texture.CONTENT_BOOK_BACKGROUND.width() / 2.0f + (float)this.offsetX, (float)(Texture.CONTENT_BOOK_BACKGROUND.width() + this.offsetX), (float)(60 + this.offsetY), 0.0f, CommonColors.BLACK, HorizontalAlignment.CENTER, TextShadow.NONE);
        FontRenderer.getInstance().renderAlignedTextInBox(poseStack, StyledText.fromString("Level " + Models.CombatXp.getCombatLevel().current() + " " + Models.Character.getClassType().getName()), (float)Texture.CONTENT_BOOK_BACKGROUND.width() / 2.0f + (float)this.offsetX, (float)(Texture.CONTENT_BOOK_BACKGROUND.width() + this.offsetX), (float)(145 + this.offsetY), 0.0f, CommonColors.PURPLE, HorizontalAlignment.CENTER, TextShadow.NONE);
        if (((Boolean)Managers.Feature.getFeatureInstance(WynntilsContentBookFeature.class).displayOverallProgress.get()).booleanValue()) {
            CappedValue progress = Models.Activity.getOverallProgress();
            FontRenderer.getInstance().renderAlignedTextInBox(poseStack, StyledText.fromString(String.valueOf(ChatFormatting.BLACK) + "Progress: " + String.valueOf(ChatFormatting.DARK_AQUA) + progress.getPercentageInt() + "%" + String.valueOf(ChatFormatting.BLACK) + " [" + String.valueOf(ChatFormatting.DARK_AQUA) + String.valueOf(progress) + String.valueOf(ChatFormatting.BLACK) + "]"), (float)Texture.CONTENT_BOOK_BACKGROUND.width() / 2.0f + (float)this.offsetX, (float)(Texture.CONTENT_BOOK_BACKGROUND.width() + this.offsetX), (float)(160 + this.offsetY), 0.0f, CommonColors.BLACK, HorizontalAlignment.CENTER, TextShadow.NONE);
        }
        String currentSplash = Services.Splash.getCurrentSplash() == null ? "" : Services.Splash.getCurrentSplash();
        StyledText[] wrappedSplash = RenderedStringUtils.wrapTextBySize(StyledText.fromString(currentSplash), Texture.CONTENT_BOOK_BACKGROUND.width() / 2 - 20);
        for (int i = 0; i < wrappedSplash.length; ++i) {
            FontRenderer fontRenderer = FontRenderer.getInstance();
            StyledText styledText = wrappedSplash[i];
            float f = (float)Texture.CONTENT_BOOK_BACKGROUND.width() / 2.0f + (float)this.offsetX;
            float f2 = Texture.CONTENT_BOOK_BACKGROUND.width() + this.offsetX;
            int n = Texture.CONTENT_BOOK_BACKGROUND.height() - 45;
            Objects.requireNonNull(McUtils.mc().font);
            fontRenderer.renderAlignedTextInBox(poseStack, styledText, f, f2, (float)(n + i * (9 + 1) + this.offsetY), 0.0f, CommonColors.MAGENTA, HorizontalAlignment.CENTER, TextShadow.NONE);
        }
    }

    private void renderPlayer(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int posX = (int)((float)Texture.CONTENT_BOOK_BACKGROUND.width() / 2.0f + 50.0f + (float)this.offsetX);
        int posY = (int)((float)Texture.CONTENT_BOOK_BACKGROUND.height() / 2.0f - 40.0f + (float)this.offsetY);
        int renderWidth = (int)((float)Texture.CONTENT_BOOK_BACKGROUND.width() / 2.0f - 100.0f);
        int renderHeight = 70;
        InventoryScreen.renderEntityInInventoryFollowsMouse((GuiGraphics)guiGraphics, (int)posX, (int)posY, (int)(posX + renderWidth), (int)(posY + 70), (int)25, (float)0.4f, (float)mouseX, (float)mouseY, (LivingEntity)McUtils.player());
    }

    @Override
    public boolean doMouseClicked(double mouseX, double mouseY, int button) {
        if (this.hovered == null) {
            return false;
        }
        if (button == 0) {
            this.hovered.getClickAction().run();
        }
        return true;
    }

    private void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (this.hovered != null) {
            guiGraphics.renderComponentTooltip(FontRenderer.getInstance().getFont(), ComponentUtils.wrapTooltips(this.hovered.getTooltipList(), 250), mouseX, mouseY);
        }
    }

    private void renderWidgets(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.hovered = null;
        for (WynntilsMenuButton button : this.buttons.stream().flatMap(Collection::stream).toList()) {
            button.render(guiGraphics, mouseX, mouseY, partialTick);
            if (!button.isMouseOver(mouseX, mouseY)) continue;
            this.hovered = button;
        }
    }
}

