/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.services.athena;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Service;
import com.wynntils.core.net.ApiResponse;
import com.wynntils.core.net.UrlId;
import com.wynntils.models.worlds.event.WorldStateEvent;
import com.wynntils.services.athena.event.AthenaLoginEvent;
import com.wynntils.utils.mc.McUtils;
import java.math.BigInteger;
import java.security.Key;
import java.security.PublicKey;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.crypto.SecretKey;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.Crypt;
import net.neoforged.bus.api.SubscribeEvent;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WynntilsAccountService
extends Service {
    private static final String NO_TOKEN = "<no token>";
    private static final Logger log = LoggerFactory.getLogger(WynntilsAccountService.class);
    private String token = "<no token>";
    private boolean loggedIn = false;
    private final HashMap<String, String> encodedConfigs = new HashMap();
    private final HashMap<String, String> md5Verifications = new HashMap();

    public WynntilsAccountService() {
        super(List.of());
    }

    @Override
    public void reloadData() {
        this.login();
    }

    @SubscribeEvent
    public void onWorldStateChange(WorldStateEvent event) {
        if (!event.isFirstJoinWorld()) {
            return;
        }
        if (!this.loggedIn) {
            MutableComponent failed = Component.translatable((String)"service.wynntils.wynntilsAccount.failedToConnect").withStyle(ChatFormatting.GREEN);
            failed.append((Component)Component.translatable((String)"service.wynntils.wynntilsAccount.clickToConnect1").withStyle(Style.EMPTY.withColor(ChatFormatting.AQUA)));
            failed.append((Component)Component.translatable((String)"service.wynntils.wynntilsAccount.clickToConnect2").withStyle(Style.EMPTY.withColor(ChatFormatting.AQUA).withUnderlined(Boolean.valueOf(true)).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/wynntils reauth"))));
            failed.append((Component)Component.translatable((String)"service.wynntils.wynntilsAccount.clickToConnect3").withStyle(Style.EMPTY.withColor(ChatFormatting.AQUA)));
            McUtils.sendMessageToClient((Component)failed);
        }
    }

    public ApiResponse callApi(UrlId urlId, Map<String, String> arguments) {
        return Managers.Net.callApi(urlId, arguments, Map.of("authToken", this.isLoggedIn() ? this.token : ""));
    }

    public ApiResponse callApi(UrlId urlId) {
        return this.callApi(urlId, Map.of());
    }

    private void login() {
        if (this.loggedIn) {
            return;
        }
        this.doLogin();
    }

    public String getToken() {
        return this.token;
    }

    public boolean isLoggedIn() {
        return this.loggedIn;
    }

    public Map<String, String> getEncodedConfigs() {
        return this.encodedConfigs;
    }

    public void dumpEncodedConfig(String name) {
        this.encodedConfigs.remove(name);
    }

    private void doLogin() {
        ApiResponse apiResponse = Managers.Net.callApi(UrlId.API_ATHENA_AUTH_PUBLIC_KEY);
        apiResponse.handleJsonObject(json -> {
            String secretKey = this.parseAndJoinPublicKey(json.get("publicKeyIn").getAsString());
            HashMap<String, String> arguments = new HashMap<String, String>();
            arguments.put("key", secretKey);
            arguments.put("username", McUtils.mc().getUser().getName());
            arguments.put("version", String.format("A%s %s", new Object[]{WynntilsMod.getVersion(), WynntilsMod.getModLoader()}));
            ApiResponse apiAuthResponse = Managers.Net.callApi(UrlId.API_ATHENA_AUTH_RESPONSE, arguments);
            apiAuthResponse.handleJsonObject(authJson -> {
                this.token = authJson.get("authToken").getAsString();
                JsonObject hashes = authJson.getAsJsonObject("hashes");
                hashes.entrySet().forEach(k -> this.md5Verifications.put((String)k.getKey(), ((JsonElement)k.getValue()).getAsString()));
                JsonObject configFiles = authJson.getAsJsonObject("configFiles");
                configFiles.entrySet().forEach(k -> this.encodedConfigs.put((String)k.getKey(), ((JsonElement)k.getValue()).getAsString()));
                this.loggedIn = true;
                WynntilsMod.info("Successfully connected to Athena!");
                WynntilsMod.postEvent(new AthenaLoginEvent());
            });
        });
    }

    private String parseAndJoinPublicKey(String key) {
        try {
            byte[] publicKeyBy = Hex.decodeHex((char[])key.toCharArray());
            SecretKey secretkey = Crypt.generateSecretKey();
            PublicKey publicKey = Crypt.byteToPublicKey((byte[])publicKeyBy);
            String s1 = new BigInteger(Crypt.digestData((String)"", (PublicKey)publicKey, (SecretKey)secretkey)).toString(16);
            McUtils.mc().getMinecraftSessionService().joinServer(McUtils.mc().getUser().getProfileId(), McUtils.mc().getUser().getAccessToken(), s1.toLowerCase(Locale.ROOT));
            byte[] secretKeyEncrypted = Crypt.encryptUsingKey((Key)publicKey, (byte[])secretkey.getEncoded());
            return Hex.encodeHexString((byte[])secretKeyEncrypted);
        }
        catch (Exception ex) {
            WynntilsMod.error("Failed to parse public key.", ex);
            return "";
        }
    }
}

