/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.services.chat;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Handlers;
import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Service;
import com.wynntils.core.text.StyledText;
import com.wynntils.features.chat.ChatTabsFeature;
import com.wynntils.handlers.chat.type.RecipientType;
import com.wynntils.mc.event.TickEvent;
import com.wynntils.models.worlds.event.WorldStateEvent;
import com.wynntils.models.worlds.type.WorldState;
import com.wynntils.services.chat.ChatTab;
import com.wynntils.utils.mc.McUtils;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.ChatComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.neoforged.bus.api.SubscribeEvent;

public final class ChatTabService
extends Service {
    private ChatComponent fallbackChat;
    private ChatTab focusedTab = null;
    private final Map<ChatTab, ChatComponent> chatTabData = new ConcurrentHashMap<ChatTab, ChatComponent>();
    private final Map<ChatTab, Boolean> unreadMessages = new ConcurrentHashMap<ChatTab, Boolean>();

    public ChatTabService() {
        super(List.of());
    }

    public List<ChatTab> getChatTabs() {
        return (List)Managers.Feature.getFeatureInstance(ChatTabsFeature.class).chatTabs.get();
    }

    public Stream<ChatTab> getTabs() {
        return this.getChatTabs().stream();
    }

    public ChatTab getTab(int index) {
        return this.getChatTabs().get(index);
    }

    public int getTabCount() {
        return this.getChatTabs().size();
    }

    public boolean isTabListEmpty() {
        return this.getTabCount() == 0;
    }

    public void addTab(int insertIndex, ChatTab chatTab) {
        this.getChatTabs().add(insertIndex, chatTab);
        Managers.Feature.getFeatureInstance(ChatTabsFeature.class).chatTabs.touched();
    }

    public void removeTab(ChatTab chatTab) {
        this.getChatTabs().remove(chatTab);
        Managers.Feature.getFeatureInstance(ChatTabsFeature.class).chatTabs.touched();
    }

    public int getTabIndex(ChatTab edited) {
        return this.getChatTabs().indexOf(edited);
    }

    public int getNextFocusedTab() {
        return (this.getTabIndex(this.getFocusedTab()) + 1) % this.getTabCount();
    }

    public int getPreviousFocusedTab() {
        int tabIndex = this.getTabIndex(this.getFocusedTab());
        return (tabIndex - 1 + this.getTabCount()) % this.getTabCount();
    }

    public void refocusFirstTab() {
        if (!this.isTabListEmpty()) {
            this.setFocusedTab(0);
        }
    }

    public void resetFocusedTab() {
        this.setFocusedTab(null);
    }

    @SubscribeEvent
    public void onWorldStateChange(WorldStateEvent event) {
        if (event.getNewState() == WorldState.NOT_CONNECTED) {
            this.chatTabData.clear();
            this.unreadMessages.clear();
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent event) {
        this.chatTabData.values().forEach(ChatComponent::tick);
    }

    public void setFocusedTab(int index) {
        this.setFocusedTab(this.getTab(index));
    }

    public void setFocusedTab(ChatTab focused) {
        this.focusedTab = focused;
        if (this.focusedTab == null) {
            if (this.fallbackChat == null) {
                this.fallbackChat = new ChatComponent(McUtils.mc());
            }
            McUtils.mc().gui.chat = this.fallbackChat;
        } else {
            this.chatTabData.putIfAbsent(this.focusedTab, new ChatComponent(McUtils.mc()));
            this.unreadMessages.put(this.focusedTab, false);
            McUtils.mc().gui.chat = this.chatTabData.get(this.focusedTab);
        }
    }

    public ChatTab getFocusedTab() {
        return this.focusedTab;
    }

    public boolean hasUnreadMessages(ChatTab tab) {
        return this.unreadMessages.getOrDefault(tab, false);
    }

    public void handleIncomingMessage(RecipientType event, StyledText originalStyledText, StyledText styledText) {
        for (ChatTab chatTab : this.getChatTabs()) {
            if (!chatTab.isConsuming() || !this.matchMessage(chatTab, event, originalStyledText)) continue;
            this.addMessageToTab(chatTab, (Component)styledText.getComponent());
            return;
        }
        for (ChatTab chatTab : this.getChatTabs()) {
            if (chatTab.isConsuming() || !this.matchMessage(chatTab, event, originalStyledText)) continue;
            this.addMessageToTab(chatTab, (Component)styledText.getComponent());
        }
    }

    private void addMessageToTab(ChatTab tab, Component message) {
        this.chatTabData.putIfAbsent(tab, new ChatComponent(McUtils.mc()));
        try {
            this.chatTabData.get(tab).addMessage(message);
        }
        catch (Throwable t) {
            MutableComponent warning = Component.literal((String)"<< WARNING: A chat message was lost due to a crash in a mod other than Wynntils. See log for details. >>").withStyle(ChatFormatting.RED);
            this.chatTabData.get(tab).addMessage((Component)warning);
            WynntilsMod.warn("Another mod has caused an exception in ChatComponent.addMessage()");
            WynntilsMod.warn("The message that could not be displayed is:" + StyledText.fromComponent(message).getString());
            WynntilsMod.warn("This is not a Wynntils bug. Here is the exception that we caught.", t);
        }
        if (this.focusedTab != tab) {
            this.unreadMessages.put(tab, true);
        }
    }

    private boolean matchMessage(ChatTab chatTab, RecipientType recipientType, StyledText originalStyledText) {
        if (chatTab.getFilteredTypes() != null && !chatTab.getFilteredTypes().isEmpty() && !chatTab.getFilteredTypes().contains((Object)recipientType)) {
            return false;
        }
        Optional<Pattern> regex = chatTab.getCustomRegex();
        if (regex.isEmpty()) {
            return true;
        }
        return originalStyledText.matches(regex.get());
    }

    public void sendChat(String message) {
        if (message.isBlank()) {
            return;
        }
        if (this.getFocusedTab() == null) {
            McUtils.sendChat(message);
            return;
        }
        String autoCommand = this.getFocusedTab().getAutoCommand();
        if (autoCommand != null && !autoCommand.isBlank()) {
            autoCommand = autoCommand.startsWith("/") ? autoCommand.substring(1) : autoCommand;
            Handlers.Command.sendCommandImmediately(autoCommand + " " + message);
        } else {
            McUtils.sendChat(message);
        }
    }
}

