/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.services.hades;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Models;
import com.wynntils.core.components.Service;
import com.wynntils.core.components.Services;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.storage.Storage;
import com.wynntils.features.players.HadesFeature;
import com.wynntils.hades.objects.HadesConnection;
import com.wynntils.hades.protocol.builders.HadesNetworkBuilder;
import com.wynntils.hades.protocol.enums.PacketAction;
import com.wynntils.hades.protocol.enums.PacketDirection;
import com.wynntils.hades.protocol.enums.SocialType;
import com.wynntils.hades.protocol.interfaces.HadesPacket;
import com.wynntils.hades.protocol.packets.client.HCPacketPing;
import com.wynntils.hades.protocol.packets.client.HCPacketSocialUpdate;
import com.wynntils.hades.protocol.packets.client.HCPacketUpdateStatus;
import com.wynntils.hades.protocol.packets.client.HCPacketUpdateWorld;
import com.wynntils.mc.event.ChangeCarriedItemEvent;
import com.wynntils.mc.event.SetSlotEvent;
import com.wynntils.mc.event.TickEvent;
import com.wynntils.models.character.event.CharacterUpdateEvent;
import com.wynntils.models.inventory.type.InventoryAccessory;
import com.wynntils.models.inventory.type.InventoryArmor;
import com.wynntils.models.items.WynnItem;
import com.wynntils.models.items.encoding.type.EncodingSettings;
import com.wynntils.models.items.items.game.CraftedGearItem;
import com.wynntils.models.players.event.HadesRelationsUpdateEvent;
import com.wynntils.models.worlds.event.WorldStateEvent;
import com.wynntils.models.worlds.type.WorldState;
import com.wynntils.services.athena.event.AthenaLoginEvent;
import com.wynntils.services.hades.HadesClientHandler;
import com.wynntils.services.hades.HadesUser;
import com.wynntils.services.hades.HadesUserRegistry;
import com.wynntils.services.hades.event.HadesEvent;
import com.wynntils.services.hades.type.GearShareOptions;
import com.wynntils.services.hades.type.PlayerStatus;
import com.wynntils.utils.EncodedByteBuffer;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.type.CappedValue;
import com.wynntils.utils.type.ErrorOr;
import java.io.IOException;
import java.net.InetAddress;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;

public final class HadesService
extends Service {
    private static final int TICKS_PER_UPDATE = 2;
    private static final int MS_PER_PING = 1000;
    private static final EncodingSettings HADES_ENCODING_SETTINGS = new EncodingSettings(false, false);
    private final HadesUserRegistry userRegistry = new HadesUserRegistry();
    private CompletableFuture<Void> connectionFuture;
    private HadesConnection hadesConnection;
    private int tickCountUntilUpdate = 0;
    private PlayerStatus lastSentStatus;
    private ScheduledExecutorService pingScheduler;
    @Persisted
    private final Storage<GearShareOptions> gearShareOptions = new Storage<GearShareOptions>(new GearShareOptions());
    private NavigableMap<InventoryArmor, WynnItem> armorCache = new TreeMap<InventoryArmor, WynnItem>();
    private NavigableMap<InventoryAccessory, WynnItem> accessoriesCache = new TreeMap<InventoryAccessory, WynnItem>();
    private WynnItem heldItemCache = null;
    private final Map<InventoryArmor, String> armor = new TreeMap<InventoryArmor, String>();
    private final Map<InventoryAccessory, String> accessories = new TreeMap<InventoryAccessory, String>();
    private String heldItem = "";

    public HadesService() {
        super(List.of());
    }

    public Stream<HadesUser> getHadesUsers() {
        return this.userRegistry.getHadesUserMap().values().stream();
    }

    public Optional<HadesUser> getHadesUser(UUID uuid) {
        return this.userRegistry.getUser(uuid);
    }

    private void login() {
        this.connect();
    }

    private synchronized void connect() {
        if (!this.isConnected() && (this.connectionFuture == null || this.connectionFuture.isDone())) {
            this.connectionFuture = CompletableFuture.runAsync(this::tryCreateConnection);
        }
    }

    private void tryCreateConnection() {
        try {
            this.hadesConnection = new HadesNetworkBuilder().setAddress(InetAddress.getByName("io.wynntils.com"), 9000).setDirection(PacketDirection.SERVER).setCompressionThreshold(256).setHandlerFactory(a -> new HadesClientHandler(a, this.userRegistry)).buildClient();
            this.tickCountUntilUpdate = 0;
            this.lastSentStatus = null;
        }
        catch (IOException e) {
            WynntilsMod.error("Could not connect to Hades.", e);
        }
    }

    public void tryDisconnect() {
        if (this.hadesConnection != null && this.hadesConnection.isOpen()) {
            this.hadesConnection.disconnect();
            this.connectionFuture = null;
        }
    }

    @SubscribeEvent
    public void onAuth(HadesEvent.Authenticated event) {
        if (Models.WorldState.onWorld()) {
            this.tryResendWorldData();
        }
        WynntilsMod.info("Starting Hades Ping Scheduler Task");
        this.pingScheduler = Executors.newSingleThreadScheduledExecutor();
        this.pingScheduler.scheduleAtFixedRate(this::sendPing, 0L, 1000L, TimeUnit.MILLISECONDS);
    }

    @SubscribeEvent
    public void onDisconnect(HadesEvent.Disconnected event) {
        if (this.pingScheduler == null) {
            return;
        }
        this.pingScheduler.shutdown();
        this.pingScheduler = null;
        this.connectionFuture = null;
    }

    private void sendPing() {
        if (!this.isConnected()) {
            return;
        }
        this.hadesConnection.sendPacketAndFlush((HadesPacket)new HCPacketPing(System.currentTimeMillis()));
    }

    @SubscribeEvent
    public void onFriendListUpdate(HadesRelationsUpdateEvent.FriendList event) {
        if (!this.isConnected()) {
            return;
        }
        if (!((Boolean)Managers.Feature.getFeatureInstance(HadesFeature.class).shareWithFriends.get()).booleanValue()) {
            return;
        }
        this.hadesConnection.sendPacket((HadesPacket)new HCPacketSocialUpdate(event.getChangedPlayers().stream().toList(), event.getChangeType().getPacketAction(), SocialType.FRIEND));
    }

    @SubscribeEvent
    public void onPartyListUpdate(HadesRelationsUpdateEvent.PartyList event) {
        if (!this.isConnected()) {
            return;
        }
        if (!((Boolean)Managers.Feature.getFeatureInstance(HadesFeature.class).shareWithParty.get()).booleanValue()) {
            return;
        }
        this.hadesConnection.sendPacket((HadesPacket)new HCPacketSocialUpdate(event.getChangedPlayers().stream().toList(), event.getChangeType().getPacketAction(), SocialType.PARTY));
    }

    @SubscribeEvent
    public void onGuildMemberListUpdate(HadesRelationsUpdateEvent.GuildMemberList event) {
        if (!this.isConnected()) {
            return;
        }
        if (!((Boolean)Managers.Feature.getFeatureInstance(HadesFeature.class).shareWithGuild.get()).booleanValue()) {
            return;
        }
        this.hadesConnection.sendPacket((HadesPacket)new HCPacketSocialUpdate(event.getChangedPlayers().stream().toList(), event.getChangeType().getPacketAction(), SocialType.GUILD));
    }

    @SubscribeEvent
    public void onWorldStateChange(WorldStateEvent event) {
        if (event.getNewState() != WorldState.NOT_CONNECTED && Services.WynntilsAccount.isLoggedIn()) {
            this.connect();
        }
        this.userRegistry.reset();
        if (event.isFirstJoinWorld() && !this.isConnected()) {
            MutableComponent failed = Component.translatable((String)"service.wynntils.hades.failedToConnect").withStyle(ChatFormatting.GREEN);
            failed.append((Component)Component.translatable((String)"service.wynntils.hades.clickToConnect1").withStyle(Style.EMPTY.withColor(ChatFormatting.AQUA)));
            failed.append((Component)Component.translatable((String)"service.wynntils.hades.clickToConnect2").withStyle(Style.EMPTY.withColor(ChatFormatting.AQUA).withUnderlined(Boolean.valueOf(true)).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/wynntils reauth"))));
            failed.append((Component)Component.translatable((String)"service.wynntils.hades.clickToConnect3").withStyle(Style.EMPTY.withColor(ChatFormatting.AQUA)));
            McUtils.sendMessageToClient((Component)failed);
            return;
        }
        this.tryResendWorldData();
        this.refreshGear();
    }

    @SubscribeEvent
    public void onAthenaLogin(AthenaLoginEvent event) {
        if (Models.WorldState.getCurrentState() != WorldState.NOT_CONNECTED && !this.isConnected() && Services.WynntilsAccount.isLoggedIn()) {
            this.login();
        }
    }

    @SubscribeEvent
    public void onClassChange(CharacterUpdateEvent event) {
        this.tryResendWorldData();
    }

    @SubscribeEvent
    public void onSetSlot(SetSlotEvent.Post event) {
        if (!event.getContainer().equals((Object)McUtils.inventory())) {
            return;
        }
        if (((GearShareOptions)this.gearShareOptions.get()).shouldShare()) {
            for (InventoryAccessory inventoryAccessory : InventoryAccessory.values()) {
                if (event.getSlot() != inventoryAccessory.getSlot()) continue;
                this.updateAccessoryCache(inventoryAccessory);
                return;
            }
            for (Enum enum_ : InventoryArmor.values()) {
                if (event.getSlot() != ((InventoryArmor)enum_).getInventorySlot()) continue;
                this.updateArmorCache((InventoryArmor)enum_);
                return;
            }
            if (event.getSlot() == McUtils.player().getInventory().selected) {
                this.updateHeldItemCache();
            }
        }
    }

    @SubscribeEvent
    public void onSwappedItem(ChangeCarriedItemEvent event) {
        if (((GearShareOptions)this.gearShareOptions.get()).shouldShare()) {
            this.updateHeldItemCache();
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent event) {
        if (!this.isConnected()) {
            return;
        }
        if (!Models.WorldState.onWorld() || McUtils.player().hasEffect(MobEffects.NIGHT_VISION)) {
            return;
        }
        if (!(((Boolean)Managers.Feature.getFeatureInstance(HadesFeature.class).shareWithParty.get()).booleanValue() || ((Boolean)Managers.Feature.getFeatureInstance(HadesFeature.class).shareWithGuild.get()).booleanValue() || ((Boolean)Managers.Feature.getFeatureInstance(HadesFeature.class).shareWithFriends.get()).booleanValue())) {
            return;
        }
        --this.tickCountUntilUpdate;
        if (this.tickCountUntilUpdate <= 0) {
            LocalPlayer player = McUtils.player();
            float pX = (float)player.getX();
            float pY = (float)player.getY();
            float pZ = (float)player.getZ();
            PlayerStatus newStatus = ((GearShareOptions)this.gearShareOptions.get()).shouldShare() ? new PlayerStatus(pX, pY, pZ, Models.CharacterStats.getHealth().orElse(CappedValue.EMPTY), Models.CharacterStats.getMana().orElse(CappedValue.EMPTY), this.armor.getOrDefault((Object)InventoryArmor.HELMET, ""), this.armor.getOrDefault((Object)InventoryArmor.CHESTPLATE, ""), this.armor.getOrDefault((Object)InventoryArmor.LEGGINGS, ""), this.armor.getOrDefault((Object)InventoryArmor.BOOTS, ""), this.accessories.getOrDefault((Object)InventoryAccessory.RING_1, ""), this.accessories.getOrDefault((Object)InventoryAccessory.RING_2, ""), this.accessories.getOrDefault((Object)InventoryAccessory.BRACELET, ""), this.accessories.getOrDefault((Object)InventoryAccessory.NECKLACE, ""), this.heldItem) : new PlayerStatus(pX, pY, pZ, Models.CharacterStats.getHealth().orElse(CappedValue.EMPTY), Models.CharacterStats.getMana().orElse(CappedValue.EMPTY));
            if (newStatus.equals(this.lastSentStatus)) {
                this.tickCountUntilUpdate = 1;
                return;
            }
            this.tickCountUntilUpdate = 2;
            this.lastSentStatus = newStatus;
            this.hadesConnection.sendPacketAndFlush((HadesPacket)new HCPacketUpdateStatus(this.lastSentStatus.x(), this.lastSentStatus.y(), this.lastSentStatus.z(), this.lastSentStatus.health().current(), this.lastSentStatus.health().max(), this.lastSentStatus.mana().current(), this.lastSentStatus.mana().max(), this.lastSentStatus.helmet(), this.lastSentStatus.chestplate(), this.lastSentStatus.leggings(), this.lastSentStatus.boots(), this.lastSentStatus.ringOne(), this.lastSentStatus.ringTwo(), this.lastSentStatus.bracelet(), this.lastSentStatus.necklace(), this.lastSentStatus.heldItem()));
        }
    }

    public void tryResendWorldData() {
        if (!this.isConnected()) {
            return;
        }
        this.hadesConnection.sendPacket((HadesPacket)new HCPacketUpdateWorld(Models.WorldState.getCurrentWorldName(), Models.Character.getId().hashCode()));
    }

    public void resetSocialType(SocialType socialType) {
        if (!this.isConnected()) {
            return;
        }
        this.hadesConnection.sendPacketAndFlush((HadesPacket)new HCPacketSocialUpdate(List.of(), PacketAction.RESET, socialType));
    }

    public void resetHadesUsers() {
        this.userRegistry.getHadesUserMap().clear();
    }

    public GearShareOptions getGearShareOptions() {
        return (GearShareOptions)this.gearShareOptions.get();
    }

    public void saveGearShareOptions() {
        this.gearShareOptions.touched();
        this.refreshGear();
    }

    private void refreshGear() {
        if (McUtils.player() == null) {
            return;
        }
        if (((GearShareOptions)this.gearShareOptions.get()).shouldShare()) {
            for (InventoryArmor inventoryArmor : InventoryArmor.values()) {
                this.updateArmorCache(inventoryArmor);
            }
            for (Enum enum_ : InventoryAccessory.values()) {
                this.updateAccessoryCache((InventoryAccessory)enum_);
            }
            this.updateHeldItemCache();
        } else {
            this.armor.clear();
            this.armorCache.clear();
            this.accessories.clear();
            this.accessoriesCache.clear();
            this.heldItem = "";
            this.heldItemCache = null;
        }
    }

    private boolean isConnected() {
        return this.hadesConnection != null && this.hadesConnection.isOpen();
    }

    private void updateArmorCache(InventoryArmor inventoryArmor) {
        Optional<WynnItem> armorItemOpt = Models.Item.getWynnItem((ItemStack)McUtils.inventory().armor.get(inventoryArmor.getArmorSlot()));
        if (armorItemOpt.isEmpty() || armorItemOpt.get() instanceof CraftedGearItem && !((GearShareOptions)this.gearShareOptions.get()).shareCraftedItems() || !((GearShareOptions)this.gearShareOptions.get()).shouldShareArmor(inventoryArmor)) {
            this.armor.remove((Object)inventoryArmor);
            this.armorCache.remove((Object)inventoryArmor);
        } else if (!this.armorCache.containsKey((Object)inventoryArmor) || !((WynnItem)this.armorCache.get((Object)inventoryArmor)).equals(armorItemOpt.get())) {
            this.armor.put(inventoryArmor, this.encodeItem(armorItemOpt));
            this.armorCache.put(inventoryArmor, armorItemOpt.get());
        }
    }

    private void updateAccessoryCache(InventoryAccessory inventoryAccessory) {
        Optional<WynnItem> accessoryItemOpt = Models.Item.getWynnItem(McUtils.inventory().getItem(inventoryAccessory.getSlot()));
        if (accessoryItemOpt.isEmpty() || accessoryItemOpt.get() instanceof CraftedGearItem && !((GearShareOptions)this.gearShareOptions.get()).shareCraftedItems() || !((GearShareOptions)this.gearShareOptions.get()).shouldShareAccessory(inventoryAccessory)) {
            this.accessories.remove((Object)inventoryAccessory);
            this.accessoriesCache.remove((Object)inventoryAccessory);
        } else if (!this.accessoriesCache.containsKey((Object)inventoryAccessory) || !((WynnItem)this.accessoriesCache.get((Object)inventoryAccessory)).equals(accessoryItemOpt.get())) {
            this.accessories.put(inventoryAccessory, this.encodeItem(accessoryItemOpt));
            this.accessoriesCache.put(inventoryAccessory, accessoryItemOpt.get());
        }
    }

    private void updateHeldItemCache() {
        Optional<WynnItem> heldItemOpt = Models.Item.getWynnItem(McUtils.player().getMainHandItem());
        if (heldItemOpt.isEmpty() || heldItemOpt.get() instanceof CraftedGearItem && !((GearShareOptions)this.gearShareOptions.get()).shareCraftedItems() || !((GearShareOptions)this.gearShareOptions.get()).shouldShareHeldItem()) {
            this.heldItem = "";
            this.heldItemCache = null;
        } else if (this.heldItemCache == null || !this.heldItemCache.equals(heldItemOpt.get())) {
            this.heldItem = this.encodeItem(heldItemOpt);
            this.heldItemCache = heldItemOpt.get();
        }
    }

    private String encodeItem(Optional<WynnItem> item) {
        ErrorOr<EncodedByteBuffer> errorOrEncodedByteBuffer;
        if (item.isPresent() && Models.ItemEncoding.canEncodeItem(item.get()) && !(errorOrEncodedByteBuffer = Models.ItemEncoding.encodeItem(item.get(), HADES_ENCODING_SETTINGS)).hasError()) {
            WynnItem wynnItem;
            Object itemName = "";
            if (((GearShareOptions)this.gearShareOptions.get()).shareCraftedNames() && (wynnItem = item.get()) instanceof CraftedGearItem) {
                CraftedGearItem craftedGearItem = (CraftedGearItem)wynnItem;
                itemName = " \"" + craftedGearItem.getName() + "\"";
            }
            return errorOrEncodedByteBuffer.getValue().toUtf16String() + (String)itemName;
        }
        return "";
    }
}

