/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.services.itemfilter.statproviders;

import com.wynntils.models.gear.type.GearInfo;
import com.wynntils.models.gear.type.GearInstance;
import com.wynntils.models.ingredients.type.IngredientInfo;
import com.wynntils.models.items.WynnItem;
import com.wynntils.models.items.items.game.GearItem;
import com.wynntils.models.items.items.game.IngredientItem;
import com.wynntils.models.stats.type.StatActualValue;
import com.wynntils.models.stats.type.StatPossibleValues;
import com.wynntils.models.stats.type.StatType;
import com.wynntils.models.stats.type.StatUnit;
import com.wynntils.services.itemfilter.type.ItemProviderType;
import com.wynntils.services.itemfilter.type.ItemStatProvider;
import com.wynntils.services.itemfilter.type.StatValue;
import com.wynntils.utils.type.Pair;
import com.wynntils.utils.type.RangedValue;
import java.util.List;
import java.util.Optional;

public class ActualStatProvider
extends ItemStatProvider<StatValue> {
    private final StatType statType;

    public ActualStatProvider(StatType statType) {
        this.statType = statType;
    }

    @Override
    public String getName() {
        return this.statType.getApiName();
    }

    @Override
    public String getDisplayName() {
        if (this.statType.getKey().equals("MISC_LEVELED_XP_BONUS")) {
            return "XP From Lv. Content";
        }
        if (this.statType.getKey().equals("MISC_LEVELED_LOOT_BONUS")) {
            return "Loot From Lv. Content";
        }
        return switch (this.statType.getUnit()) {
            case StatUnit.PERCENT, StatUnit.PER_3_S, StatUnit.PER_5_S -> this.statType.getDisplayName() + "(" + this.statType.getUnit().getDisplayName() + ")";
            default -> this.statType.getDisplayName();
        };
    }

    @Override
    public String getDescription() {
        return this.getTranslation("description", this.statType.getDisplayName());
    }

    @Override
    public Optional<StatValue> getValue(WynnItem wynnItem) {
        if (wynnItem instanceof GearItem) {
            GearItem gearItem = (GearItem)wynnItem;
            return this.handleGearItem(gearItem);
        }
        if (wynnItem instanceof IngredientItem) {
            IngredientItem ingredientItem = (IngredientItem)wynnItem;
            return this.handleIngredientItem(ingredientItem);
        }
        return Optional.empty();
    }

    @Override
    public List<ItemProviderType> getFilterTypes() {
        return List.of(ItemProviderType.GEAR, ItemProviderType.GEAR_INSTANCE, ItemProviderType.INGREDIENT);
    }

    private Optional<StatValue> handleIngredientItem(IngredientItem ingredientItem) {
        IngredientInfo ingredientInfo = ingredientItem.getIngredientInfo();
        if (ingredientInfo == null) {
            return Optional.empty();
        }
        List<Pair<StatType, RangedValue>> stats = ingredientInfo.variableStats();
        return stats.stream().filter(pair -> ((StatType)pair.key()).equals(this.statType)).map(pair -> new StatValue(new StatPossibleValues((StatType)pair.key(), (RangedValue)pair.value(), 0, false), null)).findFirst();
    }

    private Optional<StatValue> handleGearItem(GearItem gearItem) {
        GearInfo gearInfo = gearItem.getItemInfo();
        StatPossibleValues possibleValues = gearInfo.getPossibleValues(this.statType);
        if (possibleValues == null) {
            return Optional.empty();
        }
        Optional<GearInstance> gearInstanceOpt = gearItem.getItemInstance();
        if (gearInstanceOpt.isEmpty()) {
            return Optional.of(new StatValue(possibleValues, null));
        }
        StatActualValue actualValue = gearInstanceOpt.get().getActualValue(this.statType);
        if (actualValue == null) {
            return Optional.of(new StatValue(possibleValues, null));
        }
        return Optional.of(new StatValue(possibleValues, actualValue));
    }

    @Override
    public List<String> getAliases() {
        if (this.statType.getApiName().contains("defence")) {
            return List.of(this.statType.getApiName().replace("defence", "defense"));
        }
        if (this.statType.getApiName().contains("Defence")) {
            return List.of(this.statType.getApiName().replace("Defence", "Defense"));
        }
        return super.getAliases();
    }
}

