/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.services.itemfilter.statproviders;

import com.wynntils.models.elements.type.Skill;
import com.wynntils.models.items.WynnItem;
import com.wynntils.models.items.properties.IdentifiableItemProperty;
import com.wynntils.models.stats.type.SkillStatType;
import com.wynntils.models.stats.type.StatPossibleValues;
import com.wynntils.services.itemfilter.type.ItemProviderType;
import com.wynntils.services.itemfilter.type.ItemStatProvider;
import java.util.List;
import java.util.Optional;

public class SkillStatProvider
extends ItemStatProvider<Integer> {
    private final Skill skill;

    public SkillStatProvider(Skill skill) {
        this.skill = skill;
    }

    @Override
    public String getName() {
        return this.skill.getApiName();
    }

    @Override
    public String getDisplayName() {
        return this.skill.getDisplayName();
    }

    @Override
    public String getDescription() {
        return this.getTranslation("description", this.skill.getDisplayName());
    }

    @Override
    public Optional<Integer> getValue(WynnItem wynnItem) {
        if (!(wynnItem instanceof IdentifiableItemProperty)) {
            return Optional.empty();
        }
        IdentifiableItemProperty identifiableItemProperty = (IdentifiableItemProperty)((Object)wynnItem);
        return identifiableItemProperty.getPossibleValues().stream().filter(id -> id.statType() instanceof SkillStatType).filter(id -> ((SkillStatType)id.statType()).getSkill() == this.skill).map(StatPossibleValues::baseValue).findFirst();
    }

    @Override
    public List<ItemProviderType> getFilterTypes() {
        return List.of(ItemProviderType.GEAR);
    }

    @Override
    public List<String> getAliases() {
        if (this.skill == Skill.DEFENCE) {
            return List.of("defense");
        }
        return super.getAliases();
    }
}

