/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.services.map.pois;

import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.core.components.Managers;
import com.wynntils.core.text.StyledText;
import com.wynntils.features.map.MainMapFeature;
import com.wynntils.services.hades.HadesUser;
import com.wynntils.services.map.pois.PlayerPoiBase;
import com.wynntils.utils.mc.SkinUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.buffered.BufferedFontRenderer;
import com.wynntils.utils.render.buffered.BufferedRenderUtils;
import com.wynntils.utils.render.type.HealthTexture;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;

public class PlayerMainMapPoi
extends PlayerPoiBase {
    public PlayerMainMapPoi(HadesUser user) {
        super(user, 1.0f);
    }

    @Override
    public void renderAt(PoseStack poseStack, MultiBufferSource bufferSource, float renderX, float renderY, boolean hovered, float scale, float zoomRenderScale, float zoomLevel, boolean showLabels) {
        poseStack.pushPose();
        poseStack.translate(-this.playerHeadRenderSize / 2.0f, -this.playerHeadRenderSize / 2.0f, 0.0f);
        ResourceLocation skin = SkinUtils.getSkin(this.user.getUuid());
        BufferedRenderUtils.drawTexturedRect(poseStack, bufferSource, skin, renderX, renderY, 0.0f, this.playerHeadRenderSize, this.playerHeadRenderSize, 8, 8, 8, 8, 64, 64);
        BufferedRenderUtils.drawTexturedRect(poseStack, bufferSource, skin, renderX, renderY, 1.0f, this.playerHeadRenderSize, this.playerHeadRenderSize, 40, 8, 8, 8, 64, 64);
        HealthTexture healthTexture = (HealthTexture)Managers.Feature.getFeatureInstance(MainMapFeature.class).remotePlayerHealthTexture.get();
        BufferedRenderUtils.drawProgressBar(poseStack, bufferSource, Texture.HEALTH_BAR, renderX - 10.0f, renderY + this.playerHeadRenderSize + 1.0f, renderX + this.playerHeadRenderSize + 10.0f, renderY + this.playerHeadRenderSize + 7.0f, 0, healthTexture.getTextureY1(), 81, healthTexture.getTextureY2(), (float)this.user.getHealth().getProgress());
        Font font = FontRenderer.getInstance().getFont();
        int width = font.width(this.user.getName());
        BufferedFontRenderer.getInstance().renderText(poseStack, bufferSource, StyledText.fromString(this.user.getName()), renderX - ((float)width - this.playerHeadRenderSize) / 2.0f, renderY + this.playerHeadRenderSize + 8.0f, this.user.getRelationColor(), HorizontalAlignment.LEFT, VerticalAlignment.TOP, (TextShadow)Managers.Feature.getFeatureInstance(MainMapFeature.class).remotePlayerNameShadow.get(), 1.0f);
        poseStack.popPose();
    }
}

