/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.services.map.pois;

import com.mojang.blaze3d.vertex.PoseStack;
import com.wynntils.core.components.Models;
import com.wynntils.core.text.StyledText;
import com.wynntils.models.seaskipper.type.SeaskipperDestination;
import com.wynntils.models.seaskipper.type.SeaskipperDestinationProfile;
import com.wynntils.screens.maps.CustomSeaskipperScreen;
import com.wynntils.services.map.pois.Poi;
import com.wynntils.services.map.type.DisplayPriority;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.mc.type.PoiLocation;
import com.wynntils.utils.render.buffered.BufferedFontRenderer;
import com.wynntils.utils.render.buffered.BufferedRenderUtils;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;

public class SeaskipperDestinationPoi
implements Poi {
    private final SeaskipperDestination destination;
    private final SeaskipperDestinationProfile profile;
    private final int width;
    private final int height;
    private final PoiLocation destinationCenter;
    private float renderedX;
    private float renderedEndX;
    private float renderedY;
    private float renderedEndY;

    public SeaskipperDestinationPoi(SeaskipperDestination destination) {
        this.destination = destination;
        this.profile = destination.profile();
        int startX = this.profile.startX();
        int startZ = this.profile.startZ();
        int endX = this.profile.endX();
        int endZ = this.profile.endZ();
        this.width = endX - startX;
        this.height = endZ - startZ;
        this.destinationCenter = new PoiLocation(startX + this.width / 2, null, startZ + this.height / 2);
    }

    @Override
    public PoiLocation getLocation() {
        return this.destinationCenter;
    }

    @Override
    public DisplayPriority getDisplayPriority() {
        return DisplayPriority.HIGHEST;
    }

    @Override
    public boolean hasStaticLocation() {
        return true;
    }

    @Override
    public void renderAt(PoseStack poseStack, MultiBufferSource bufferSource, float renderX, float renderY, boolean hovered, float scale, float zoomRenderScale, float zoomLevel, boolean showLabels) {
        this.renderPoi(poseStack, bufferSource, renderX, renderY, zoomRenderScale, true);
    }

    public void renderAtWithoutBorders(PoseStack poseStack, MultiBufferSource bufferSource, float renderX, float renderY, float mapZoom) {
        this.renderPoi(poseStack, bufferSource, renderX, renderY, mapZoom, false);
    }

    private void renderPoi(PoseStack poseStack, MultiBufferSource bufferSource, float renderX, float renderY, float mapZoom, boolean renderBorders) {
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.0f, 100.0f);
        float renderWidth = (float)this.width * mapZoom;
        float renderHeight = (float)this.height * mapZoom;
        float actualRenderX = renderX - renderWidth / 2.0f;
        float actualRenderZ = renderY - renderHeight / 2.0f;
        this.renderedX = actualRenderX;
        this.renderedY = actualRenderZ;
        this.renderedEndX = this.renderedX + renderWidth;
        this.renderedEndY = this.renderedY + renderHeight;
        CustomColor color = this.getColor();
        if (renderBorders) {
            BufferedRenderUtils.drawRect(poseStack, bufferSource, color.withAlpha(65), actualRenderX, actualRenderZ, 0.0f, renderWidth, renderHeight);
            BufferedRenderUtils.drawRectBorders(poseStack, bufferSource, color, actualRenderX, actualRenderZ, actualRenderX + renderWidth, actualRenderZ + renderHeight, 0.0f, 1.5f);
        }
        BufferedFontRenderer.getInstance().renderAlignedTextInBox(poseStack, bufferSource, StyledText.fromString(this.profile.destination()), actualRenderX, actualRenderX + renderWidth, actualRenderZ, actualRenderZ + renderHeight, 0.0f, color, HorizontalAlignment.CENTER, VerticalAlignment.MIDDLE, TextShadow.OUTLINE);
        poseStack.popPose();
    }

    @Override
    public int getWidth(float mapZoom, float scale) {
        return (int)((float)this.width * mapZoom);
    }

    @Override
    public int getHeight(float mapZoom, float scale) {
        return (int)((float)this.height * mapZoom);
    }

    @Override
    public String getName() {
        return this.profile.destination();
    }

    public SeaskipperDestination getDestination() {
        return this.destination;
    }

    public int getLevel() {
        return this.profile.combatLevel();
    }

    public boolean isPlayerInside() {
        return this.destination.isPlayerInside();
    }

    public boolean isAvailable() {
        return this.destination.isAvailable();
    }

    private CustomColor getColor() {
        CustomSeaskipperScreen seaskipperScreen;
        if (this.destination.isPlayerInside()) {
            return CommonColors.ORANGE;
        }
        Screen screen = McUtils.mc().screen;
        if (screen instanceof CustomSeaskipperScreen && (seaskipperScreen = (CustomSeaskipperScreen)screen).getSelectedDestination() == this) {
            return CommonColors.GREEN;
        }
        if (!this.destination.isAvailable()) {
            return CommonColors.GRAY;
        }
        if (Models.Emerald.getAmountInInventory() < this.destination.item().getPrice()) {
            return CommonColors.RED;
        }
        return CommonColors.WHITE;
    }
}

