/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.services.mapdata;

import com.wynntils.core.components.Services;
import com.wynntils.services.mapdata.attributes.DefaultMapAttributes;
import com.wynntils.services.mapdata.attributes.type.MapAttributes;
import com.wynntils.services.mapdata.attributes.type.MapDecoration;
import com.wynntils.services.mapdata.attributes.type.MapVisibility;
import com.wynntils.services.mapdata.attributes.type.ResolvedMapAttributes;
import com.wynntils.services.mapdata.attributes.type.ResolvedMapVisibility;
import com.wynntils.services.mapdata.type.MapCategory;
import com.wynntils.services.mapdata.type.MapFeature;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.render.type.TextShadow;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;

public final class MapAttributesResolver {
    private final MapFeature feature;

    private MapAttributesResolver(MapFeature feature) {
        this.feature = feature;
    }

    public static ResolvedMapAttributes resolve(MapFeature feature) {
        MapAttributesResolver resolver = new MapAttributesResolver(feature);
        return new ResolvedMapAttributes((String)resolver.getAttribute(MapAttributes::getLabel), (String)resolver.getAttribute(MapAttributes::getIconId), (Integer)resolver.getAttribute(MapAttributes::getPriority), (Integer)resolver.getAttribute(MapAttributes::getLevel), resolver.getResolvedMapVisibility(MapAttributes::getLabelVisibility), (CustomColor)resolver.getAttribute(MapAttributes::getLabelColor), (TextShadow)resolver.getAttribute(MapAttributes::getLabelShadow), resolver.getResolvedMapVisibility(MapAttributes::getIconVisibility), (CustomColor)resolver.getAttribute(MapAttributes::getIconColor), (MapDecoration)resolver.getAttribute(MapAttributes::getIconDecoration));
    }

    private <T> T getAttribute(Function<MapAttributes, Optional<T>> attributeGetter) {
        Optional<T> featureAttribute = this.getFromFeature(attributeGetter);
        if (featureAttribute.isPresent()) {
            return featureAttribute.get();
        }
        String id = this.getCategoryId();
        while (id != null) {
            Stream<T> attributes = this.getAttributesForCategoryId(attributeGetter, id);
            Optional<T> attribute = attributes.findFirst();
            if (attribute.isPresent()) {
                return attribute.get();
            }
            id = this.getParentCategoryId(id);
        }
        return attributeGetter.apply(DefaultMapAttributes.INSTANCE).get();
    }

    private ResolvedMapVisibility getResolvedMapVisibility(Function<MapAttributes, Optional<MapVisibility>> attributeGetter) {
        return new ResolvedMapVisibility(this.getVisibilityValue(MapVisibility::getMin, attributeGetter), this.getVisibilityValue(MapVisibility::getMax, attributeGetter), this.getVisibilityValue(MapVisibility::getFade, attributeGetter));
    }

    private float getVisibilityValue(Function<MapVisibility, Optional<Float>> valueGetter, Function<MapAttributes, Optional<MapVisibility>> attributeGetter) {
        Optional<Float> featureValue;
        Optional featureVisibility = this.getFromFeature(attributeGetter);
        if (featureVisibility.isPresent() && (featureValue = valueGetter.apply((MapVisibility)featureVisibility.get())).isPresent()) {
            return featureValue.get().floatValue();
        }
        String id = this.getCategoryId();
        while (id != null) {
            Stream<MapVisibility> attributes = this.getAttributesForCategoryId(attributeGetter, id);
            Optional<Float> attribute = attributes.map(valueGetter).filter(Optional::isPresent).map(Optional::get).findFirst();
            if (attribute.isPresent()) {
                return attribute.get().floatValue();
            }
            id = this.getParentCategoryId(id);
        }
        return valueGetter.apply((MapVisibility)attributeGetter.apply(DefaultMapAttributes.INSTANCE).get()).get().floatValue();
    }

    private String getCategoryId() {
        return this.feature.getCategoryId();
    }

    private <T> Optional<T> getFromFeature(Function<MapAttributes, Optional<T>> attributeGetter) {
        Optional<MapAttributes> attributes = this.feature.getAttributes();
        if (attributes.isEmpty()) {
            return Optional.empty();
        }
        return attributeGetter.apply(attributes.get());
    }

    private <T> Stream<T> getAttributesForCategoryId(Function<MapAttributes, Optional<T>> attributeGetter, String categoryId) {
        Stream<MapAttributes> allAttributes = Services.MapData.getCategoryDefinitions(categoryId).map(MapCategory::getAttributes).filter(Optional::isPresent).map(Optional::get);
        return allAttributes.map(attributeGetter).filter(Optional::isPresent).map(Optional::get);
    }

    private String getParentCategoryId(String categoryId) {
        int index = categoryId.lastIndexOf(58);
        if (index == -1) {
            return null;
        }
        return categoryId.substring(0, index);
    }
}

