/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.services.mapdata.providers.json;

import com.mojang.blaze3d.platform.NativeImage;
import com.wynntils.services.mapdata.attributes.type.MapIcon;
import com.wynntils.utils.mc.McUtils;
import java.io.IOException;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;

public class JsonIcon
implements MapIcon {
    private final String iconId;
    private final NativeImage nativeImage;
    private final int width;
    private final int height;
    private final ResourceLocation resource;
    private boolean registered;

    public JsonIcon(String iconId, byte[] texture) throws IOException {
        this.iconId = iconId;
        this.nativeImage = NativeImage.read((byte[])texture);
        this.width = this.nativeImage.getWidth();
        this.height = this.nativeImage.getHeight();
        this.resource = ResourceLocation.fromNamespaceAndPath((String)"wynntils", (String)("icons/" + iconId.replace(":", ".")));
    }

    @Override
    public ResourceLocation getResourceLocation() {
        if (!this.registered) {
            this.registered = true;
            McUtils.mc().getTextureManager().register(this.resource, (AbstractTexture)new DynamicTexture(this.nativeImage));
        }
        return this.resource;
    }

    @Override
    public String getIconId() {
        return this.iconId;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }
}

