/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.services.translation;

import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.wynntils.core.WynntilsMod;
import com.wynntils.services.translation.type.TranslationProvider;
import com.wynntils.utils.TaskUtils;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.apache.commons.io.FileUtils;

public abstract class CachingTranslationProvider
implements TranslationProvider {
    private static final File TRANSLATION_CACHE_ROOT = WynntilsMod.getModStorageDir("translationcache");
    private static Map<String, ConcurrentHashMap<String, List<String>>> translationCaches = new HashMap<String, ConcurrentHashMap<String, List<String>>>();
    private static int counter = 0;

    protected abstract void translateNew(List<String> var1, String var2, Consumer<List<String>> var3);

    protected void saveTranslation(String toLanguage, List<String> message, List<String> translatedMessage) {
        Map translationCache = translationCaches.get(toLanguage);
        translationCache.put(this.createKey(message), translatedMessage);
        if (++counter % 16 == 0) {
            TaskUtils.runAsync(CachingTranslationProvider::saveTranslationCache);
        }
    }

    @Override
    public void translate(List<String> message, String toLanguage, Consumer<List<String>> handleTranslation) {
        if (message.isEmpty()) {
            TaskUtils.runAsync(() -> handleTranslation.accept(List.of()));
            return;
        }
        Map translationCache = translationCaches.computeIfAbsent(toLanguage, k -> new ConcurrentHashMap());
        List cachedTranslation = (List)translationCache.get(this.createKey(message));
        if (cachedTranslation != null) {
            TaskUtils.runAsync(() -> handleTranslation.accept(cachedTranslation));
            return;
        }
        this.translateNew(message, toLanguage, handleTranslation);
    }

    public static synchronized void saveTranslationCache() {
        try {
            if (translationCaches == null) {
                return;
            }
            File f = new File(TRANSLATION_CACHE_ROOT, "translations.json");
            String json = WynntilsMod.GSON.toJson(translationCaches);
            FileUtils.writeStringToFile((File)f, (String)json, (String)"UTF-8");
        }
        catch (IOException e) {
            WynntilsMod.error("Error when trying to save translation cache.", e);
        }
    }

    public static synchronized void loadTranslationCache() {
        File f = new File(TRANSLATION_CACHE_ROOT, "translations.json");
        if (!f.exists()) {
            translationCaches = new HashMap<String, ConcurrentHashMap<String, List<String>>>();
            return;
        }
        try {
            String json = FileUtils.readFileToString((File)f, (String)"UTF-8");
            Type type = new TypeToken<HashMap<String, ConcurrentHashMap<String, List<String>>>>(){}.getType();
            translationCaches = (Map)WynntilsMod.GSON.fromJson(json, type);
        }
        catch (IOException e) {
            WynntilsMod.error("Error when trying to load translation cache.", e);
        }
        catch (JsonSyntaxException | IllegalStateException e) {
            WynntilsMod.error("Translation cache was corrupt when parsing it. Trying to delete it.", e);
            try {
                FileUtils.delete((File)f);
            }
            catch (IOException ioException) {
                WynntilsMod.error("Error when trying to delete translation cache.", ioException);
            }
        }
        finally {
            if (translationCaches == null) {
                translationCaches = new HashMap<String, ConcurrentHashMap<String, List<String>>>();
            }
        }
    }

    private String createKey(List<String> message) {
        return String.join((CharSequence)"", message);
    }
}

