/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.utils.mc;

import com.wynntils.core.text.StyledText;
import com.wynntils.core.text.StyledTextPart;
import com.wynntils.utils.MathUtils;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.wynn.WynnUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;

public final class ComponentUtils {
    private static final Pattern COLOR_CODE_PATTERN = Pattern.compile("(\u00a7[1-9a-f])+");
    private static final int RAINBOW_CYCLE_TIME = 5000;
    private static final Pattern NEWLINE_PATTERN = Pattern.compile("\n");
    private static final ResourceLocation PILL_FONT = ResourceLocation.withDefaultNamespace((String)"banner/pill");
    private static final Style BACKGROUND_STYLE = Style.EMPTY.withFont(PILL_FONT).withColor(ChatFormatting.AQUA);
    private static final Style FOREGROUND_STYLE = Style.EMPTY.withFont(PILL_FONT).withColor(ChatFormatting.BLACK);
    private static final Component WYNNTILS_BACKGROUND_PILL = Component.literal((String)"\ue060\udaff\udfff\ue046\udaff\udfff\ue048\udaff\udfff\ue03d\udaff\udfff\ue03d\udaff\udfff\ue043\udaff\udfff\ue038\udaff\udfff\ue03b\udaff\udfff\ue042\udaff\udfff\ue062\udaff\udfd0").withStyle(BACKGROUND_STYLE);
    private static final Component WYNNTILS_FOREGROUND_PILL = Component.literal((String)"\ue016\ue018\ue00d\ue00d\ue013\ue008\ue00b\ue012\udb00\udc02 ").withStyle(FOREGROUND_STYLE);

    public static List<Component> stripDuplicateBlank(List<Component> lore) {
        String line;
        Component loreLine;
        int index;
        ArrayList<Component> newLore = new ArrayList<Component>();
        boolean oldBlank = false;
        for (index = 0; index < lore.size(); ++index) {
            loreLine = lore.get(index);
            line = WynnUtils.normalizeBadString(loreLine.getString());
            newLore.add(loreLine);
            if (!line.isEmpty()) continue;
            oldBlank = true;
            break;
        }
        if (!oldBlank) {
            return newLore;
        }
        while (index < lore.size()) {
            loreLine = lore.get(index);
            line = WynnUtils.normalizeBadString(loreLine.getString());
            if (!oldBlank || !line.isEmpty()) {
                oldBlank = line.isEmpty();
                newLore.add(loreLine);
            }
            ++index;
        }
        return newLore;
    }

    public static Style getLastPartCodes(StyledText lastPart) {
        StyledTextPart lastTextPart = lastPart.getLastPart();
        if (lastTextPart == null) {
            return Style.EMPTY;
        }
        return lastTextPart.getPartStyle().getStyle();
    }

    public static Component formattedTextToComponent(FormattedText formattedText) {
        MutableComponent component = Component.literal((String)"");
        formattedText.visit((style, string) -> {
            component.append((Component)Component.literal((String)string).withStyle(style));
            return Optional.empty();
        }, Style.EMPTY);
        return component;
    }

    public static int getOptimalTooltipWidth(List<Component> tooltips, int screenWidth, int mouseX) {
        int tooltipX = mouseX + 12;
        int tooltipWidth = tooltips.stream().mapToInt(arg_0 -> ((Font)McUtils.mc().font).width(arg_0)).max().orElse(0);
        if (tooltipX + tooltipWidth + 4 > screenWidth && (tooltipX = mouseX - 16 - tooltipWidth) < 4) {
            tooltipWidth = mouseX > screenWidth / 2 ? mouseX - 12 - 8 : screenWidth - 16 - mouseX;
        }
        return tooltipWidth;
    }

    public static List<Component> wrapTooltips(List<Component> tooltips, int maxWidth) {
        return tooltips.stream().flatMap(x -> ComponentUtils.splitComponent(x, maxWidth).stream()).toList();
    }

    public static List<Component> splitComponent(Component component, int maxWidth) {
        List<Component> split = McUtils.mc().font.getSplitter().splitLines((FormattedText)component, maxWidth, Style.EMPTY).stream().map(ComponentUtils::formattedTextToComponent).collect(Collectors.toList());
        if (split.isEmpty()) {
            split.add((Component)Component.literal((String)""));
        }
        return split;
    }

    public static MutableComponent makeRainbowStyle(String name, boolean useShader) {
        if (useShader) {
            return Component.literal((String)name).withColor(CommonColors.RAINBOW.asInt()).withStyle(ChatFormatting.BOLD);
        }
        MutableComponent newName = Component.literal((String)"").withStyle(ChatFormatting.BOLD);
        int time = (int)(System.currentTimeMillis() % 5000L);
        for (int i = 0; i < name.length(); ++i) {
            int hue = (time + i * 5000 / 7) % 5000;
            Style color = Style.EMPTY.withColor(Color.HSBtoRGB((float)hue / 5000.0f, 0.8f, 0.8f)).withItalic(Boolean.valueOf(false));
            newName.append((Component)Component.literal((String)String.valueOf(name.charAt(i))).setStyle(color));
        }
        return newName;
    }

    public static MutableComponent makeObfuscated(String name, float obfuscationChanceStart, float obfuscationChanceEnd) {
        MutableComponent newName = Component.literal((String)"").withStyle(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.DARK_RED});
        boolean obfuscated = Math.random() < (double)obfuscationChanceStart;
        StringBuilder current = new StringBuilder();
        for (int i = 0; i < name.length() - 1; ++i) {
            current.append(name.charAt(i));
            float chance = MathUtils.lerp(obfuscationChanceStart, obfuscationChanceEnd, (float)(i + 1) / (float)(name.length() - 1));
            if (!obfuscated && Math.random() < (double)chance) {
                newName.append((Component)Component.literal((String)current.toString()));
                current = new StringBuilder();
                obfuscated = true;
                continue;
            }
            if (!obfuscated || !(Math.random() > (double)chance)) continue;
            newName.append((Component)Component.literal((String)current.toString()).withStyle(Style.EMPTY.withObfuscated(Boolean.valueOf(true))));
            current = new StringBuilder();
            obfuscated = false;
        }
        current.append(name.charAt(name.length() - 1));
        if (obfuscated) {
            newName.append((Component)Component.literal((String)current.toString()).withStyle(Style.EMPTY.withObfuscated(Boolean.valueOf(true))));
        } else {
            newName.append((Component)Component.literal((String)current.toString()));
        }
        return newName;
    }

    public static MutableComponent addWynntilsPillHeader(Component component) {
        return Component.empty().append(WYNNTILS_BACKGROUND_PILL).append(WYNNTILS_FOREGROUND_PILL).append(component);
    }
}

