/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.utils.mc;

import com.mojang.blaze3d.platform.Window;
import com.wynntils.core.WynntilsMod;
import com.wynntils.mc.extension.ChatComponentExtension;
import com.wynntils.utils.mc.ComponentUtils;
import java.io.File;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.multiplayer.prediction.PredictiveAction;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;

public final class McUtils {
    public static Minecraft mc() {
        return Minecraft.getInstance();
    }

    public static UUID getUserProfileUUID() {
        if (McUtils.mc() == null) {
            return UUID.fromString("00000000-0000-0000-0000-000000000000");
        }
        return McUtils.mc().getUser().getProfileId();
    }

    public static File getGameDirectory() {
        if (McUtils.mc() == null) {
            return new File("../build/tmp/");
        }
        return McUtils.mc().gameDirectory;
    }

    public static LocalPlayer player() {
        return McUtils.mc().player;
    }

    public static String playerName() {
        return McUtils.player().getName().getString();
    }

    public static Options options() {
        return McUtils.mc().options;
    }

    public static InventoryMenu inventoryMenu() {
        return McUtils.player().inventoryMenu;
    }

    public static AbstractContainerMenu containerMenu() {
        return McUtils.player().containerMenu;
    }

    public static Inventory inventory() {
        return McUtils.player().getInventory();
    }

    public static Window window() {
        return McUtils.mc().getWindow();
    }

    public static double guiScale() {
        return McUtils.window().getGuiScale();
    }

    public static void playSoundUI(SoundEvent sound) {
        McUtils.mc().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)sound, (float)1.0f));
    }

    public static void playSoundUI(SoundEvent sound, float volume) {
        McUtils.mc().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)sound, (float)1.0f, (float)volume));
    }

    public static void playSoundMaster(SoundEvent sound) {
        McUtils.playSoundMaster(sound, 1.0f, 1.0f);
    }

    public static void playSoundMaster(SoundEvent sound, float volume, float pitch) {
        McUtils.playSound(sound, SoundSource.MASTER, volume, pitch);
    }

    public static void playSoundAmbient(SoundEvent sound) {
        McUtils.playSoundAmbient(sound, 1.0f, 1.0f);
    }

    public static void playSoundAmbient(SoundEvent sound, float volume, float pitch) {
        McUtils.playSound(sound, SoundSource.AMBIENT, volume, pitch);
    }

    private static void playSound(SoundEvent sound, SoundSource soundSource, float volume, float pitch) {
        McUtils.mc().getSoundManager().play((SoundInstance)new SimpleSoundInstance(sound.location(), soundSource, volume, pitch, SoundInstance.createUnseededRandom(), false, 0, SoundInstance.Attenuation.NONE, 0.0, 0.0, 0.0, true));
    }

    public static void sendMessageToClient(Component component) {
        McUtils.mc().getChatListener().handleSystemMessage(component, false);
    }

    public static void sendMessageToClientWithPillHeader(Component component) {
        McUtils.sendMessageToClient((Component)ComponentUtils.addWynntilsPillHeader(component));
    }

    public static void removeMessageFromChat(Component component) {
        ((ChatComponentExtension)McUtils.mc().gui.getChat()).deleteMessage(component);
    }

    public static void sendErrorToClient(String errorMsg) {
        WynntilsMod.warn("Chat error message sent: " + errorMsg);
        McUtils.sendMessageToClient((Component)Component.literal((String)errorMsg).withStyle(ChatFormatting.RED));
    }

    public static void sendPacket(Packet<?> packet) {
        if (McUtils.mc().getConnection() == null) {
            WynntilsMod.error("Tried to send packet: \"" + packet.getClass().getSimpleName() + "\", but connection was null.");
            return;
        }
        McUtils.mc().getConnection().send(packet);
    }

    public static void sendSequencedPacket(PredictiveAction predictiveAction) {
        McUtils.mc().gameMode.startPrediction(McUtils.mc().level, predictiveAction);
    }

    public static void sendChat(String message) {
        McUtils.mc().getConnection().sendChat(message);
    }
}

