/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.utils.mc;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public final class PosUtils {
    public static BlockPos newBlockPos(double x, double y, double z) {
        return BlockPos.containing((double)x, (double)y, (double)z);
    }

    public static BlockPos newBlockPos(Position position) {
        return BlockPos.containing((Position)position);
    }

    public static Position newPosition(Entity entity) {
        return new Vec3(entity.getX(), entity.getY(), entity.getZ());
    }

    public static Vec3 toVec3(Position position) {
        return new Vec3(position.x(), position.y(), position.z());
    }

    public static boolean isSame(Position first, Position second) {
        return first.x() == second.x() && first.z() == second.z() && Math.abs(first.y() - second.y()) < 1.5;
    }

    public static boolean equalsIgnoringY(Position pos1, Position pos2) {
        return pos1.x() == pos2.x() && pos1.z() == pos2.z();
    }

    public static boolean closerThanIgnoringY(Position pos1, Position pos2, double distance) {
        double zD;
        double xD = pos1.x() - pos2.x();
        return xD * xD + (zD = pos1.z() - pos2.z()) * zD < distance * distance;
    }
}

