/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.utils.mc;

import com.wynntils.core.components.Handlers;
import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Models;
import com.wynntils.features.tooltips.ItemStatInfoFeature;
import com.wynntils.handlers.tooltip.TooltipBuilder;
import com.wynntils.handlers.tooltip.type.TooltipIdentificationDecorator;
import com.wynntils.handlers.tooltip.type.TooltipStyle;
import com.wynntils.models.gear.type.ItemWeightSource;
import com.wynntils.models.items.WynnItem;
import com.wynntils.models.items.properties.CraftedItemProperty;
import com.wynntils.models.items.properties.IdentifiableItemProperty;
import com.wynntils.models.stats.type.StatListOrdering;
import com.wynntils.utils.mc.ComponentUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.wynn.ColorScaleUtils;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;

public final class TooltipUtils {
    public static int getTooltipWidth(List<ClientTooltipComponent> lines, Font font) {
        return lines.stream().map(clientTooltipComponent -> clientTooltipComponent.getWidth(font)).max(Integer::compareTo).orElse(0);
    }

    public static int getTooltipHeight(List<ClientTooltipComponent> lines) {
        return (lines.size() == 1 ? -2 : 0) + lines.stream().mapToInt(clientTooltip -> clientTooltip.getHeight(FontRenderer.getInstance().getFont())).sum();
    }

    public static List<ClientTooltipComponent> getClientTooltipComponent(List<Component> components) {
        return components.stream().map(Component::getVisualOrderText).map(ClientTooltipComponent::create).toList();
    }

    public static List<Component> getWynnItemTooltip(ItemStack itemStack, WynnItem wynnItem) {
        Optional<CraftedItemProperty> craftedItemPropertyOpt;
        List<Object> tooltip = new ArrayList();
        Optional<IdentifiableItemProperty> identifiableItemPropertyOpt = Models.Item.asWynnItemProperty(itemStack, IdentifiableItemProperty.class);
        if (identifiableItemPropertyOpt.isPresent()) {
            tooltip = TooltipUtils.getIdentifiableItemTooltip(itemStack, wynnItem, identifiableItemPropertyOpt.get());
        }
        if ((craftedItemPropertyOpt = Models.Item.asWynnItemProperty(itemStack, CraftedItemProperty.class)).isPresent()) {
            tooltip = TooltipUtils.getCraftedItemTooltip(itemStack, wynnItem, craftedItemPropertyOpt.get());
        }
        return tooltip;
    }

    private static List<Component> getIdentifiableItemTooltip(ItemStack itemStack, WynnItem wynnItem, IdentifiableItemProperty itemInfo) {
        TooltipBuilder builder = wynnItem.getData().getOrCalculate("tooltip", () -> Handlers.Tooltip.fromParsedItemStack(itemStack, itemInfo));
        if (builder == null) {
            return null;
        }
        ItemStatInfoFeature feature = Managers.Feature.getFeatureInstance(ItemStatInfoFeature.class);
        TooltipIdentificationDecorator decorator = (Boolean)feature.identificationDecorations.get() != false ? feature.getDecorator() : null;
        TooltipStyle currentIdentificationStyle = new TooltipStyle((StatListOrdering)((Object)feature.identificationsOrdering.get()), (Boolean)feature.groupIdentifications.get(), (Boolean)feature.showBestValueLastAlways.get(), (Boolean)feature.showStars.get(), (ItemWeightSource)((Object)feature.itemWeights.get()), false);
        LinkedList<Component> tooltips = new LinkedList<Component>(builder.getTooltipLines(Models.Character.getClassType(), currentIdentificationStyle, decorator));
        if (((Boolean)feature.overallPercentageInName.get()).booleanValue() && itemInfo.hasOverallValue()) {
            TooltipUtils.updateItemName(itemInfo, tooltips);
        }
        return tooltips;
    }

    private static List<Component> getCraftedItemTooltip(ItemStack itemStack, WynnItem wynnItem, CraftedItemProperty craftedItemProperty) {
        TooltipBuilder builder = wynnItem.getData().getOrCalculate("tooltip", () -> Handlers.Tooltip.fromParsedItemStack(itemStack, craftedItemProperty));
        if (builder == null) {
            return null;
        }
        ItemStatInfoFeature isif = Managers.Feature.getFeatureInstance(ItemStatInfoFeature.class);
        TooltipStyle currentIdentificationStyle = new TooltipStyle((StatListOrdering)((Object)isif.identificationsOrdering.get()), (Boolean)isif.groupIdentifications.get(), false, false, ItemWeightSource.NONE, (Boolean)isif.showMaxValues.get());
        return new LinkedList<Component>(builder.getTooltipLines(Models.Character.getClassType(), currentIdentificationStyle, null));
    }

    private static void updateItemName(IdentifiableItemProperty itemInfo, Deque<Component> tooltips) {
        MutableComponent name;
        ItemStatInfoFeature isif = Managers.Feature.getFeatureInstance(ItemStatInfoFeature.class);
        if (((Boolean)isif.perfect.get()).booleanValue() && itemInfo.isPerfect()) {
            name = ComponentUtils.makeRainbowStyle("Perfect " + itemInfo.getName(), true);
        } else if (((Boolean)isif.defective.get()).booleanValue() && itemInfo.isDefective()) {
            name = ComponentUtils.makeObfuscated("Defective " + itemInfo.getName(), ((Float)isif.obfuscationChanceStart.get()).floatValue(), ((Float)isif.obfuscationChanceEnd.get()).floatValue());
        } else {
            name = tooltips.getFirst().copy();
            name.append((Component)ColorScaleUtils.getPercentageTextComponent(isif.getColorMap(), itemInfo.getOverallPercentage(), (Boolean)isif.colorLerp.get(), (Integer)isif.decimalPlaces.get()));
        }
        tooltips.removeFirst();
        tooltips.addFirst((Component)name);
    }
}

