/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.utils.wynn;

import com.wynntils.utils.mc.McUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.protocol.game.ServerboundContainerClickPacket;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.item.ItemStack;

public final class InventoryUtils {
    public static final int COMPASS_SLOT_NUM = 7;
    public static final int CONTENT_BOOK_SLOT_NUM = 8;
    public static final int INGREDIENT_POUCH_SLOT_NUM = 13;
    private static final int RING_1_SLOT_NUM = 9;
    private static final int RING_2_SLOT_NUM = 10;
    private static final int BRACELET_SLOT_NUM = 11;
    private static final int NECKLACE_SLOT_NUM = 12;
    private static final List<Integer> ACCESSORY_SLOTS = List.of(Integer.valueOf(9), Integer.valueOf(10), Integer.valueOf(11), Integer.valueOf(12));

    public static void sendInventorySlotMouseClick(int slotNumber, MouseClickType mouseButton) {
        Int2ObjectOpenHashMap changedSlots = new Int2ObjectOpenHashMap();
        ItemStack itemStack = McUtils.inventory().getItem(slotNumber);
        changedSlots.put(slotNumber, (Object)itemStack);
        McUtils.sendPacket(new ServerboundContainerClickPacket(McUtils.inventoryMenu().containerId, McUtils.inventoryMenu().getStateId(), slotNumber, mouseButton.ordinal(), ClickType.PICKUP, ItemStack.EMPTY, (Int2ObjectMap)changedSlots));
    }

    public static List<ItemStack> getAccessories(Player player) {
        ArrayList<ItemStack> accessories = new ArrayList<ItemStack>();
        ACCESSORY_SLOTS.forEach(slot -> accessories.add((ItemStack)player.getInventory().items.get(slot.intValue())));
        return accessories;
    }

    public static ItemStack getItemInHand() {
        return McUtils.player().getItemInHand(InteractionHand.MAIN_HAND);
    }

    public static enum MouseClickType {
        LEFT_CLICK,
        RIGHT_CLICK;

    }
}

