/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.commands;

import com.google.common.base.CaseFormat;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.wynntils.core.components.Managers;
import com.wynntils.core.consumers.commands.Command;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.consumers.overlays.DynamicOverlay;
import com.wynntils.core.consumers.overlays.Overlay;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.OverlayGroupHolder;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_5250;
import net.minecraft.class_7157;
import org.apache.commons.lang3.StringUtils;

public class ConfigCommand
extends Command {
    private static final SuggestionProvider<class_2168> FEATURE_SUGGESTION_PROVIDER = (context, builder) -> class_2172.method_9264(Managers.Feature.getFeatures().stream().map(Feature::getShortName), (SuggestionsBuilder)builder);
    private static final SuggestionProvider<class_2168> OVERLAY_SUGGESTION_PROVIDER = (context, builder) -> class_2172.method_9265(() -> {
        String featureName = (String)context.getArgument("feature", String.class);
        Optional<Feature> foundFeature = Managers.Feature.getFeatureFromString(featureName);
        return foundFeature.map(feature -> Managers.Overlay.getFeatureOverlays((Feature)feature).stream().map(Overlay::getShortName).iterator()).orElse(Collections.emptyIterator());
    }, (SuggestionsBuilder)builder);
    private static final SuggestionProvider<class_2168> FEATURE_CONFIG_SUGGESTION_PROVIDER = (context, builder) -> class_2172.method_9265(() -> {
        String featureName = (String)context.getArgument("feature", String.class);
        Optional<Feature> foundFeature = Managers.Feature.getFeatureFromString(featureName);
        return foundFeature.map(feature -> feature.getVisibleConfigOptions().stream().map(Config::getFieldName).iterator()).orElse(Collections.emptyIterator());
    }, (SuggestionsBuilder)builder);
    private static final SuggestionProvider<class_2168> OVERLAY_GROUP_FEATURE_SUGGESTION_PROVIDER = (context, builder) -> class_2172.method_9264(Managers.Feature.getFeatures().stream().filter(feature -> !Managers.Overlay.getFeatureOverlayGroups((Feature)feature).isEmpty()).map(Feature::getShortName), (SuggestionsBuilder)builder);
    private static final SuggestionProvider<class_2168> OVERLAY_CONFIG_SUGGESTION_PROVIDER = (context, builder) -> class_2172.method_9265(() -> {
        String featureName = (String)context.getArgument("feature", String.class);
        String overlayName = (String)context.getArgument("overlay", String.class);
        Optional<Feature> featureOptional = Managers.Feature.getFeatureFromString(featureName);
        if (featureOptional.isEmpty()) {
            return Collections.emptyIterator();
        }
        Feature feature = featureOptional.get();
        Optional<Overlay> overlayOptional = Managers.Overlay.getFeatureOverlays(feature).stream().filter(overlay -> overlay.getShortName().equals(overlayName)).findFirst();
        return overlayOptional.map(overlay -> overlay.getVisibleConfigOptions().stream().map(Config::getFieldName).iterator()).orElse(Collections.emptyIterator());
    }, (SuggestionsBuilder)builder);
    private static final SuggestionProvider<class_2168> CONFIG_VALUE_SUGGESTION_PROVIDER = (context, builder) -> {
        String configName;
        String featureName = (String)context.getArgument("feature", String.class);
        Config<?> config = ConfigCommand.getConfigFromArguments((CommandContext<class_2168>)context, featureName, configName = (String)context.getArgument("config", String.class));
        if (config == null) {
            return class_2172.method_9264(Stream.of(new String[0]), (SuggestionsBuilder)builder);
        }
        return class_2172.method_9264(config.getValidLiterals(), (SuggestionsBuilder)builder);
    };
    private static final SuggestionProvider<class_2168> OVERLAY_CONFIG_VALUE_SUGGESTION_PROVIDER = (context, builder) -> {
        String configName;
        String overlayName;
        String featureName = (String)context.getArgument("feature", String.class);
        Config<?> config = ConfigCommand.getOverlayConfigFromArguments((CommandContext<class_2168>)context, featureName, overlayName = (String)context.getArgument("overlay", String.class), configName = (String)context.getArgument("config", String.class));
        if (config == null) {
            return class_2172.method_9264(Stream.of(new String[0]), (SuggestionsBuilder)builder);
        }
        return class_2172.method_9264(config.getValidLiterals(), (SuggestionsBuilder)builder);
    };
    private static final SuggestionProvider<class_2168> OVERLAY_GROUP_SUGGESTION_PROVIDER = (context, builder) -> class_2172.method_9265(() -> {
        String featureName = (String)context.getArgument("feature", String.class);
        Optional<Feature> featureOptional = Managers.Feature.getFeatureFromString(featureName);
        return featureOptional.map(feature -> Managers.Overlay.getFeatureOverlayGroups((Feature)feature).stream().map(OverlayGroupHolder::getFieldName).iterator()).orElse(Collections.emptyIterator());
    }, (SuggestionsBuilder)builder);
    private static final SuggestionProvider<class_2168> OVERLAY_GROUP_REMOVE_ID_SUGGESTION_PROVIDER = (context, builder) -> class_2172.method_9265(() -> {
        String groupName;
        String featureName = (String)context.getArgument("feature", String.class);
        OverlayGroupHolder overlayGroupHolder = ConfigCommand.getOverlayGroupHolderFromArguments((CommandContext<class_2168>)context, featureName, groupName = (String)context.getArgument("group", String.class));
        if (overlayGroupHolder == null) {
            return Collections.emptyIterator();
        }
        return overlayGroupHolder.getOverlays().stream().map(overlay -> ((DynamicOverlay)overlay).getId()).map(String::valueOf).iterator();
    }, (SuggestionsBuilder)builder);

    @Override
    public String getCommandName() {
        return "config";
    }

    @Override
    public LiteralArgumentBuilder<class_2168> getCommandBuilder(LiteralArgumentBuilder<class_2168> base, class_7157 context) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)base.then(this.buildGetConfigNode())).then(this.buildSetConfigNode())).then(this.buildResetConfigNode())).then(this.buildReloadConfigNode())).then(this.buildOverlayGroupNode())).executes(this::syntaxError);
    }

    private LiteralCommandNode<class_2168> buildGetConfigNode() {
        LiteralArgumentBuilder getConfigArgBuilder = class_2170.method_9247((String)"get");
        getConfigArgBuilder.then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"feature", (ArgumentType)StringArgumentType.word()).suggests(FEATURE_SUGGESTION_PROVIDER).then(class_2170.method_9247((String)"overlay").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"overlay", (ArgumentType)StringArgumentType.word()).suggests(OVERLAY_SUGGESTION_PROVIDER).then(class_2170.method_9244((String)"config", (ArgumentType)StringArgumentType.word()).suggests(OVERLAY_CONFIG_SUGGESTION_PROVIDER).executes(this::getSpecificOverlayConfigOption))).executes(this::listAllOverlayConfigs)))).then(class_2170.method_9244((String)"config", (ArgumentType)StringArgumentType.word()).suggests(FEATURE_CONFIG_SUGGESTION_PROVIDER).executes(this::getSpecificConfigOption))).executes(this::listAllConfigOptions));
        return getConfigArgBuilder.build();
    }

    private LiteralCommandNode<class_2168> buildSetConfigNode() {
        LiteralArgumentBuilder setConfigArgBuilder = class_2170.method_9247((String)"set");
        setConfigArgBuilder.then(((RequiredArgumentBuilder)class_2170.method_9244((String)"feature", (ArgumentType)StringArgumentType.word()).suggests(FEATURE_SUGGESTION_PROVIDER).then(class_2170.method_9247((String)"overlay").then(class_2170.method_9244((String)"overlay", (ArgumentType)StringArgumentType.word()).suggests(OVERLAY_SUGGESTION_PROVIDER).then(class_2170.method_9244((String)"config", (ArgumentType)StringArgumentType.word()).suggests(OVERLAY_CONFIG_SUGGESTION_PROVIDER).then(class_2170.method_9244((String)"newValue", (ArgumentType)StringArgumentType.greedyString()).suggests(OVERLAY_CONFIG_VALUE_SUGGESTION_PROVIDER).executes(this::changeOverlayConfig)))))).then(class_2170.method_9244((String)"config", (ArgumentType)StringArgumentType.word()).suggests(FEATURE_CONFIG_SUGGESTION_PROVIDER).then(class_2170.method_9244((String)"newValue", (ArgumentType)StringArgumentType.greedyString()).suggests(CONFIG_VALUE_SUGGESTION_PROVIDER).executes(this::changeFeatureConfig))));
        return setConfigArgBuilder.build();
    }

    private LiteralCommandNode<class_2168> buildResetConfigNode() {
        LiteralArgumentBuilder resetConfigArgBuilder = class_2170.method_9247((String)"reset");
        resetConfigArgBuilder.then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"feature", (ArgumentType)StringArgumentType.word()).suggests(FEATURE_SUGGESTION_PROVIDER).then(class_2170.method_9247((String)"overlay").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"overlay", (ArgumentType)StringArgumentType.word()).suggests(OVERLAY_SUGGESTION_PROVIDER).then(class_2170.method_9244((String)"config", (ArgumentType)StringArgumentType.word()).suggests(OVERLAY_CONFIG_SUGGESTION_PROVIDER).executes(this::resetOverlayConfigOption))).executes(this::resetAllOverlayConfigOptions)))).then(class_2170.method_9244((String)"config", (ArgumentType)StringArgumentType.word()).suggests(FEATURE_CONFIG_SUGGESTION_PROVIDER).executes(this::resetFeatureConfigOption))).executes(this::resetAllConfigOptions));
        return resetConfigArgBuilder.build();
    }

    private LiteralCommandNode<class_2168> buildReloadConfigNode() {
        LiteralArgumentBuilder reloadConfigArgBuilder = class_2170.method_9247((String)"reload");
        reloadConfigArgBuilder.executes(this::reloadAllConfigOptions);
        return reloadConfigArgBuilder.build();
    }

    private LiteralCommandNode<class_2168> buildOverlayGroupNode() {
        LiteralArgumentBuilder overlayGroupArgBuilder = class_2170.method_9247((String)"overlaygroup");
        overlayGroupArgBuilder.then(class_2170.method_9244((String)"feature", (ArgumentType)StringArgumentType.word()).suggests(OVERLAY_GROUP_FEATURE_SUGGESTION_PROVIDER).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"group", (ArgumentType)StringArgumentType.word()).suggests(OVERLAY_GROUP_SUGGESTION_PROVIDER).then(class_2170.method_9247((String)"add").executes(this::addOverlayGroup))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"id", (ArgumentType)StringArgumentType.word()).suggests(OVERLAY_GROUP_REMOVE_ID_SUGGESTION_PROVIDER).executes(this::removeOverlayGroup)))));
        return overlayGroupArgBuilder.build();
    }

    private int addOverlayGroup(CommandContext<class_2168> context) {
        String groupName;
        String featureName = (String)context.getArgument("feature", String.class);
        OverlayGroupHolder overlayGroupHolder = ConfigCommand.getOverlayGroupHolderFromArguments(context, featureName, groupName = (String)context.getArgument("group", String.class));
        if (overlayGroupHolder == null) {
            return 0;
        }
        int newId = Managers.Overlay.extendOverlayGroup(overlayGroupHolder);
        Managers.Config.reloadConfiguration(false);
        Managers.Config.saveConfig();
        Managers.Config.reloadConfiguration(true);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Successfully added a new %s to %s with the id %d.".formatted(overlayGroupHolder.getOverlayClass().getSimpleName(), overlayGroupHolder.getFieldName(), newId)).method_27692(class_124.field_1060), false);
        return 1;
    }

    private int removeOverlayGroup(CommandContext<class_2168> context) {
        String featureName = (String)context.getArgument("feature", String.class);
        String groupName = (String)context.getArgument("group", String.class);
        String idName = (String)context.getArgument("id", String.class);
        OverlayGroupHolder overlayGroupHolder = ConfigCommand.getOverlayGroupHolderFromArguments(context, featureName, groupName);
        if (overlayGroupHolder == null) {
            return 0;
        }
        int id = Integer.parseInt(idName);
        Managers.Overlay.removeIdFromOverlayGroup(overlayGroupHolder, id);
        Managers.Config.reloadConfiguration(false);
        Managers.Config.saveConfig();
        Managers.Config.reloadConfiguration(true);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Successfully removed %s from %s with the id %d.".formatted(overlayGroupHolder.getOverlayClass().getSimpleName(), overlayGroupHolder.getFieldName(), id)).method_27692(class_124.field_1060), false);
        return 1;
    }

    private int reloadAllConfigOptions(CommandContext<class_2168> context) {
        Managers.Config.reloadConfiguration(true);
        Managers.Config.saveConfig();
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Successfully reloaded configs from file.").method_27692(class_124.field_1060), false);
        return 1;
    }

    private int resetOverlayConfigOption(CommandContext<class_2168> context) {
        String configName;
        String overlayName;
        String featureName = (String)context.getArgument("feature", String.class);
        Config<?> config = ConfigCommand.getOverlayConfigFromArguments(context, featureName, overlayName = (String)context.getArgument("overlay", String.class), configName = (String)context.getArgument("config", String.class));
        if (config == null) {
            return 0;
        }
        config.reset();
        Managers.Config.saveConfig();
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Successfully reset ").method_27692(class_124.field_1060).method_10852((class_2561)class_2561.method_43470((String)config.getDisplayName()).method_27692(class_124.field_1073).method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1060)), false);
        return 1;
    }

    private int resetAllOverlayConfigOptions(CommandContext<class_2168> context) {
        String overlayName;
        String featureName = (String)context.getArgument("feature", String.class);
        Overlay overlay = ConfigCommand.getOverlayFromArguments(context, featureName, overlayName = (String)context.getArgument("overlay", String.class));
        if (overlay == null) {
            return 0;
        }
        overlay.getConfigOptions().forEach(Config::reset);
        Managers.Config.saveConfig();
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Successfully reset ").method_27692(class_124.field_1060).method_10852((class_2561)class_2561.method_43470((String)featureName).method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)"'s config options.").method_27692(class_124.field_1060)), false);
        return 1;
    }

    private int listAllOverlayConfigs(CommandContext<class_2168> context) {
        String overlayName;
        String featureName = (String)context.getArgument("feature", String.class);
        Overlay overlay = ConfigCommand.getOverlayFromArguments(context, featureName, overlayName = (String)context.getArgument("overlay", String.class));
        if (overlay == null) {
            return 0;
        }
        class_5250 response = class_2561.method_43470((String)overlayName).method_27692(class_124.field_1075).method_10852((class_2561)class_2561.method_43470((String)"'s config options:\n").method_27692(class_124.field_1068));
        for (Config<?> config : overlay.getVisibleConfigOptions()) {
            class_5250 current = this.getComponentForConfig(config);
            current.method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11745, "/wynntils config set " + featureName + " overlay " + overlayName + " " + config.getFieldName() + " ")));
            response.method_10852((class_2561)current);
        }
        ((class_2168)context.getSource()).method_9226(() -> response, false);
        return 1;
    }

    private int getSpecificOverlayConfigOption(CommandContext<class_2168> context) {
        String configName;
        String overlayName;
        String featureName = (String)context.getArgument("feature", String.class);
        Config<?> config = ConfigCommand.getOverlayConfigFromArguments(context, featureName, overlayName = (String)context.getArgument("overlay", String.class), configName = (String)context.getArgument("config", String.class));
        if (config == null) {
            return 0;
        }
        String longParentName = Arrays.stream(CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, overlayName).split("_")).map(StringUtils::capitalize).collect(Collectors.joining(" "));
        class_5250 response = class_2561.method_43470((String)(longParentName + "\n")).method_27692(class_124.field_1075);
        response.method_10852((class_2561)this.getSpecificConfigComponent(config));
        ((class_2168)context.getSource()).method_9226(() -> response, false);
        return 1;
    }

    private int changeOverlayConfig(CommandContext<class_2168> context) {
        String featureName = (String)context.getArgument("feature", String.class);
        String overlayName = (String)context.getArgument("overlay", String.class);
        String configName = (String)context.getArgument("config", String.class);
        Config<?> config = ConfigCommand.getOverlayConfigFromArguments(context, featureName, overlayName, configName);
        return ConfigCommand.changeConfig(context, config);
    }

    private int getSpecificConfigOption(CommandContext<class_2168> context) {
        String configName;
        String featureName = (String)context.getArgument("feature", String.class);
        Config<?> config = ConfigCommand.getConfigFromArguments(context, featureName, configName = (String)context.getArgument("config", String.class));
        if (config == null) {
            return 0;
        }
        String longParentName = Arrays.stream(CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, featureName).split("_")).map(StringUtils::capitalize).collect(Collectors.joining(" "));
        class_5250 response = class_2561.method_43470((String)(longParentName + "\n")).method_27692(class_124.field_1054);
        response.method_10852((class_2561)this.getSpecificConfigComponent(config));
        ((class_2168)context.getSource()).method_9226(() -> response, false);
        return 1;
    }

    private int listAllConfigOptions(CommandContext<class_2168> context) {
        class_5250 current;
        String featureName = (String)context.getArgument("feature", String.class);
        Feature feature = ConfigCommand.getFeatureFromArguments(context, featureName);
        if (feature == null) {
            return 0;
        }
        class_5250 response = class_2561.method_43470((String)featureName).method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43470((String)"'s config options:\n").method_27692(class_124.field_1068));
        for (Config<?> config : feature.getVisibleConfigOptions()) {
            current = this.getComponentForConfig(config);
            current.method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11745, "/wynntils config set " + featureName + " " + config.getFieldName() + " ")));
            response.method_10852((class_2561)current);
        }
        response.method_27693("\n").method_10852((class_2561)class_2561.method_43470((String)featureName).method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43470((String)"'s overlays:\n").method_27692(class_124.field_1068)));
        for (Overlay overlay : Managers.Overlay.getFeatureOverlays(feature)) {
            current = this.getComponentForOverlay(overlay);
            current.method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11745, "/wynntils config set " + featureName + " overlay " + overlay.getShortName() + " ")));
            response.method_10852((class_2561)current);
        }
        ((class_2168)context.getSource()).method_9226(() -> response, false);
        return 1;
    }

    private int changeFeatureConfig(CommandContext<class_2168> context) {
        String featureName = (String)context.getArgument("feature", String.class);
        String configName = (String)context.getArgument("config", String.class);
        Config<?> config = ConfigCommand.getConfigFromArguments(context, featureName, configName);
        return ConfigCommand.changeConfig(context, config);
    }

    private static <T> int changeConfig(CommandContext<class_2168> context, Config<T> config) {
        if (config == null) {
            return 0;
        }
        String newValue = (String)context.getArgument("newValue", String.class);
        T parsedValue = config.tryParseStringValue(newValue);
        if (parsedValue == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Failed to parse the inputted value to the correct type!").method_27692(class_124.field_1061));
            return 0;
        }
        Object oldValue = config.get();
        String oldValueString = config.getValueString();
        if (Objects.equals(oldValue, parsedValue)) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"The new value is the same as the current setting.").method_27692(class_124.field_1061));
            return 0;
        }
        config.setValue(parsedValue);
        String newValueString = config.getValueString();
        Managers.Config.saveConfig();
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Successfully set ").method_27692(class_124.field_1060).method_10852((class_2561)class_2561.method_43470((String)config.getDisplayName()).method_27692(class_124.field_1073).method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)" from ").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)oldValueString).method_27692(class_124.field_1067).method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)" to ").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)newValueString).method_27692(class_124.field_1067).method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1060)), false);
        return 1;
    }

    private int resetFeatureConfigOption(CommandContext<class_2168> context) {
        String configName;
        String featureName = (String)context.getArgument("feature", String.class);
        Config<?> config = ConfigCommand.getConfigFromArguments(context, featureName, configName = (String)context.getArgument("config", String.class));
        if (config == null) {
            return 0;
        }
        config.reset();
        Managers.Config.saveConfig();
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Successfully reset ").method_27692(class_124.field_1060).method_10852((class_2561)class_2561.method_43470((String)config.getDisplayName()).method_27692(class_124.field_1073).method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1060)), false);
        return 1;
    }

    private int resetAllConfigOptions(CommandContext<class_2168> context) {
        String featureName = (String)context.getArgument("feature", String.class);
        Feature feature = ConfigCommand.getFeatureFromArguments(context, featureName);
        if (feature == null) {
            return 0;
        }
        feature.getVisibleConfigOptions().forEach(Config::reset);
        Managers.Config.saveConfig();
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Successfully reset ").method_27692(class_124.field_1060).method_10852((class_2561)class_2561.method_43470((String)featureName).method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)"'s config options.").method_27692(class_124.field_1060)), false);
        return 1;
    }

    private static Feature getFeatureFromArguments(CommandContext<class_2168> context, String featureName) {
        Optional<Feature> featureOptional = Managers.Feature.getFeatureFromString(featureName);
        if (featureOptional.isEmpty()) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Feature not found!").method_27692(class_124.field_1061));
            return null;
        }
        return featureOptional.get();
    }

    private static Config<?> getConfigFromArguments(CommandContext<class_2168> context, String featureName, String configName) {
        Feature feature = ConfigCommand.getFeatureFromArguments(context, featureName);
        if (feature == null) {
            return null;
        }
        Optional<Config<?>> configOptional = feature.getConfigOptionFromString(configName);
        if (configOptional.isEmpty()) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Config not found!").method_27692(class_124.field_1061));
            return null;
        }
        return configOptional.get();
    }

    private static Config<?> getOverlayConfigFromArguments(CommandContext<class_2168> context, String featureName, String overlayName, String configName) {
        Overlay overlay = ConfigCommand.getOverlayFromArguments(context, featureName, overlayName);
        if (overlay == null) {
            return null;
        }
        Optional<Config<?>> configOptional = overlay.getConfigOptionFromString(configName);
        if (configOptional.isEmpty()) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Config not found!").method_27692(class_124.field_1061));
            return null;
        }
        return configOptional.get();
    }

    private static Overlay getOverlayFromArguments(CommandContext<class_2168> context, String featureName, String overlayName) {
        Feature feature = ConfigCommand.getFeatureFromArguments(context, featureName);
        if (feature == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Feature not found!").method_27692(class_124.field_1061));
            return null;
        }
        Optional<Overlay> overlayOptional = Managers.Overlay.getFeatureOverlays(feature).stream().filter(overlay -> overlay.getShortName().equals(overlayName)).findFirst();
        if (overlayOptional.isEmpty()) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Overlay not found!").method_27692(class_124.field_1061));
            return null;
        }
        return overlayOptional.get();
    }

    private static OverlayGroupHolder getOverlayGroupHolderFromArguments(CommandContext<class_2168> context, String featureName, String overlayGroupName) {
        Feature feature = ConfigCommand.getFeatureFromArguments(context, featureName);
        if (feature == null) {
            return null;
        }
        Optional<OverlayGroupHolder> group = Managers.Overlay.getFeatureOverlayGroups(feature).stream().filter(overlayGroupHolder -> overlayGroupHolder.getFieldName().equalsIgnoreCase(overlayGroupName)).findFirst();
        if (group.isEmpty()) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Overlay group not found!").method_27692(class_124.field_1061));
            return null;
        }
        return group.get();
    }

    private class_5250 getComponentForConfig(Config<?> config) {
        String configNameString = config.getDisplayName();
        String configTypeString = " (" + ((Class)config.getType()).getSimpleName() + ")";
        String valueString = config.getValueString();
        return class_2561.method_43470((String)"\n - ").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)configNameString).method_27694(style -> style.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)("Description: " + config.getDescription())).method_27692(class_124.field_1076)))).method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43470((String)configTypeString).method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)": ")).method_10852((class_2561)class_2561.method_43470((String)valueString).method_27692(class_124.field_1060).method_27694(style -> style.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"Click here to change this setting."))))));
    }

    private class_5250 getComponentForOverlay(Overlay overlay) {
        return class_2561.method_43470((String)"\n - ").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)overlay.getShortName()).method_27692(class_124.field_1075));
    }

    private class_5250 getSpecificConfigComponent(Config<?> config) {
        String valueString = config.getValueString();
        String configTypeString = "(" + ((Class)config.getType()).getSimpleName() + ")";
        class_5250 response = class_2561.method_43470((String)"");
        response.method_10852((class_2561)class_2561.method_43470((String)"Config option: ").method_27692(class_124.field_1068).method_10852((class_2561)class_2561.method_43470((String)config.getDisplayName()).method_27692(class_124.field_1054)).method_27693("\n"));
        response.method_10852((class_2561)class_2561.method_43470((String)"Value: ").method_27692(class_124.field_1068).method_10852((class_2561)class_2561.method_43470((String)configTypeString)).method_10852((class_2561)class_2561.method_43470((String)": ")).method_10852((class_2561)class_2561.method_43470((String)valueString).method_27692(class_124.field_1060))).method_27693("\n");
        response.method_10852((class_2561)class_2561.method_43470((String)"Description: ").method_27692(class_124.field_1068).method_10852((class_2561)class_2561.method_43470((String)config.getDescription()))).method_27693("\n");
        return response;
    }

    private int syntaxError(CommandContext<class_2168> context) {
        ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Missing argument").method_27692(class_124.field_1061));
        return 0;
    }
}

