/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.wynntils.core.components.Services;
import com.wynntils.core.consumers.commands.Command;
import com.wynntils.services.statistics.type.StatisticEntry;
import com.wynntils.services.statistics.type.StatisticKind;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_7157;

public class StatisticsCommand
extends Command {
    private static final SuggestionProvider<class_2168> STATISTIC_SUGGESTION_PROVIDER = (context, builder) -> class_2172.method_9264(Arrays.stream(StatisticKind.values()).map(StatisticKind::getId), (SuggestionsBuilder)builder);

    @Override
    public String getCommandName() {
        return "statistics";
    }

    @Override
    public List<String> getAliases() {
        return List.of("stats", "stat", "st");
    }

    @Override
    public LiteralArgumentBuilder<class_2168> getCommandBuilder(LiteralArgumentBuilder<class_2168> base, class_7157 context) {
        RequiredArgumentBuilder characterStatisticsBuilder = (RequiredArgumentBuilder)class_2170.method_9244((String)"statistic", (ArgumentType)StringArgumentType.greedyString()).suggests(STATISTIC_SUGGESTION_PROVIDER).executes(this::getStatistic);
        RequiredArgumentBuilder overallStatisticsBuilder = (RequiredArgumentBuilder)class_2170.method_9244((String)"statistic", (ArgumentType)StringArgumentType.greedyString()).suggests(STATISTIC_SUGGESTION_PROVIDER).executes(this::getStatisticOverall);
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)base.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"show").then(class_2170.method_9247((String)"overall").executes(this::showOverallStatistics))).then(class_2170.method_9247((String)"o").executes(this::showOverallStatistics))).executes(this::showCharacterStatistics))).then(class_2170.method_9247((String)"list").executes(this::listStatistics))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"get").then(class_2170.method_9247((String)"character").then((ArgumentBuilder)characterStatisticsBuilder))).then(class_2170.method_9247((String)"c").then((ArgumentBuilder)characterStatisticsBuilder))).then(class_2170.method_9247((String)"overall").then((ArgumentBuilder)overallStatisticsBuilder))).then(class_2170.method_9247((String)"o").then((ArgumentBuilder)overallStatisticsBuilder)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reset").then(class_2170.method_9247((String)"confirm").executes(this::doResetStatistics))).executes(this::resetStatistics))).executes(this::syntaxError);
    }

    private int showCharacterStatistics(CommandContext<class_2168> context) {
        class_5250 response = class_2561.method_43470((String)"Statistics:").method_27692(class_124.field_1075);
        for (StatisticKind statistic : Arrays.stream(StatisticKind.values()).sorted(Comparator.comparing(StatisticKind::getName)).toList()) {
            long value = Services.Statistics.getStatistic(statistic).total();
            response.method_10852((class_2561)class_2561.method_43470((String)"\n - ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)statistic.getName()).method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)": ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)statistic.getFormattedValue(value)).method_27692(class_124.field_1077));
        }
        ((class_2168)context.getSource()).method_9226(() -> response, false);
        return 1;
    }

    private int showOverallStatistics(CommandContext<class_2168> context) {
        class_5250 response = class_2561.method_43470((String)"Statistics:").method_27692(class_124.field_1075);
        for (StatisticKind statistic : Arrays.stream(StatisticKind.values()).sorted(Comparator.comparing(StatisticKind::getName)).toList()) {
            long value = Services.Statistics.getOverallStatistic(statistic).total();
            response.method_10852((class_2561)class_2561.method_43470((String)"\n - ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)statistic.getName()).method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)": ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)statistic.getFormattedValue(value)).method_27692(class_124.field_1077));
        }
        ((class_2168)context.getSource()).method_9226(() -> response, false);
        return 1;
    }

    private int listStatistics(CommandContext<class_2168> context) {
        class_5250 response = class_2561.method_43470((String)"Available kinds of statistics:").method_27692(class_124.field_1075);
        for (StatisticKind statistic : Arrays.stream(StatisticKind.values()).sorted(Comparator.comparing(StatisticKind::getId)).toList()) {
            response.method_10852((class_2561)class_2561.method_43470((String)"\n - ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)statistic.getId()).method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)(" (" + statistic.getName() + ")")).method_27692(class_124.field_1077));
        }
        ((class_2168)context.getSource()).method_9226(() -> response, false);
        return 1;
    }

    private int getStatistic(CommandContext<class_2168> context) {
        String statisticId = (String)context.getArgument("statistic", String.class);
        StatisticKind statistic = StatisticKind.from(statisticId);
        if (statistic == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"No such statistic.").method_27692(class_124.field_1061));
            return 0;
        }
        StatisticEntry value = Services.Statistics.getStatistic(statistic);
        class_5250 response = StatisticsCommand.getStatisticComponent(statistic, value);
        ((class_2168)context.getSource()).method_9226(() -> response, false);
        return 1;
    }

    private int getStatisticOverall(CommandContext<class_2168> context) {
        String statisticId = (String)context.getArgument("statistic", String.class);
        StatisticKind statistic = StatisticKind.from(statisticId);
        if (statistic == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"No such statistic.").method_27692(class_124.field_1061));
            return 0;
        }
        StatisticEntry value = Services.Statistics.getOverallStatistic(statistic);
        class_5250 response = StatisticsCommand.getStatisticComponent(statistic, value);
        ((class_2168)context.getSource()).method_9226(() -> response, false);
        return 1;
    }

    private static class_5250 getStatisticComponent(StatisticKind statistic, StatisticEntry value) {
        class_5250 response = class_2561.method_43470((String)statistic.getName()).method_27692(class_124.field_1068).method_10852((class_2561)class_2561.method_43470((String)":\nTotal: ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)statistic.getFormattedValue(value.total())).method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)"\nCount: ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)statistic.getFormattedValue(value.count())).method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)"\nMin: ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)statistic.getFormattedValue(value.min())).method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)"\nMax: ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)statistic.getFormattedValue(value.max())).method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)"\nAverage: ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)statistic.getFormattedValue(value.average())).method_27692(class_124.field_1077));
        return response;
    }

    private int resetStatistics(CommandContext<class_2168> context) {
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"command.wynntils.statistics.warnReset").method_27692(class_124.field_1075), false);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43471((String)"command.wynntils.statistics.clickHere").method_27692(class_124.field_1061).method_27692(class_124.field_1073).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11750, "/statistics reset confirm"))), false);
        return 1;
    }

    private int doResetStatistics(CommandContext<class_2168> context) {
        Services.Statistics.resetStatistics();
        class_5250 response = class_2561.method_43470((String)"All statistics for this character has been reset").method_27692(class_124.field_1075);
        ((class_2168)context.getSource()).method_9226(() -> response, false);
        return 1;
    }

    private int syntaxError(CommandContext<class_2168> context) {
        ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Missing argument").method_27692(class_124.field_1061));
        return 0;
    }
}

