/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.core;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.wynntils.core.components.CoreComponent;
import com.wynntils.core.components.Handler;
import com.wynntils.core.components.Handlers;
import com.wynntils.core.components.Manager;
import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Model;
import com.wynntils.core.components.Models;
import com.wynntils.core.components.Service;
import com.wynntils.core.components.Services;
import com.wynntils.core.events.EventBusWrapper;
import com.wynntils.core.mod.event.WynntilsCrashEvent;
import com.wynntils.core.mod.event.WynntilsInitEvent;
import com.wynntils.core.mod.type.CrashType;
import com.wynntils.utils.mc.McUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_1074;
import net.minecraft.class_1078;
import net.minecraft.class_155;
import net.minecraft.class_2477;
import net.minecraft.class_2966;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.ICancellableEvent;
import net.neoforged.bus.api.IEventBus;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WynntilsMod {
    public static final String MOD_ID = "wynntils";
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"wynntils");
    private static final File MOD_STORAGE_ROOT = new File(McUtils.getGameDirectory(), "wynntils");
    private static ModLoader modLoader;
    private static String version;
    private static boolean developmentBuild;
    private static boolean developmentEnvironment;
    private static IEventBus eventBus;
    private static File modJar;
    private static boolean initCompleted;
    private static final Map<Class<? extends CoreComponent>, List<CoreComponent>> componentMap;

    public static ModLoader getModLoader() {
        return modLoader;
    }

    public static void unregisterEventListener(Object object) {
        eventBus.unregister(object);
    }

    public static void registerEventListener(Object object) {
        eventBus.register(object);
    }

    public static <T extends Event> void registerListener(Consumer<T> eventConsumer) {
        eventBus.addListener(eventConsumer);
    }

    public static <T extends Event> boolean postEvent(T event) {
        try {
            ICancellableEvent cancellableEvent;
            eventBus.post(event);
            return event instanceof ICancellableEvent && (cancellableEvent = (ICancellableEvent)((Object)event)).isCanceled();
        }
        catch (Throwable t) {
            WynntilsMod.handleExceptionInEventListener(t, event);
            return false;
        }
    }

    public static void postEventOnMainThread(Event event) {
        Managers.TickScheduler.scheduleNextTick(() -> WynntilsMod.postEvent(event));
    }

    public static void reloadAllComponentData() {
        componentMap.values().stream().flatMap(Collection::stream).forEach(CoreComponent::reloadData);
    }

    private static void handleExceptionInEventListener(Throwable t, Event event) {
        StackTraceElement[] stackTrace = t.getStackTrace();
        String crashingFeatureName = Arrays.stream(stackTrace).filter(line -> line.getClassName().startsWith("com.wynntils.features.")).findFirst().map(StackTraceElement::getClassName).orElse(null);
        if (crashingFeatureName == null) {
            WynntilsMod.error("Exception in event listener not belonging to a feature", t);
            return;
        }
        if (Managers.Feature == null) {
            WynntilsMod.warn("Cannot lookup feature name: " + crashingFeatureName, t);
            return;
        }
        Managers.Feature.handleExceptionInEventListener(event, crashingFeatureName, t);
    }

    public static File getModJar() {
        return modJar;
    }

    public static String getVersion() {
        return version;
    }

    public static boolean isBeta() {
        return version.contains("beta");
    }

    public static boolean isDevelopmentBuild() {
        return developmentBuild;
    }

    public static boolean isDevelopmentEnvironment() {
        return developmentEnvironment;
    }

    public static File getModStorageDir(String dirName) {
        return new File(MOD_STORAGE_ROOT, dirName);
    }

    public static InputStream getModResourceAsStream(String resourceName) {
        return WynntilsMod.class.getClassLoader().getResourceAsStream("assets/wynntils/" + resourceName);
    }

    public static Logger getLogger() {
        return LOGGER;
    }

    public static void error(String msg) {
        LOGGER.error(msg);
    }

    public static void error(String msg, Throwable t) {
        LOGGER.error(msg, t);
    }

    public static void warn(String msg) {
        LOGGER.warn(msg);
    }

    public static void warn(String msg, Throwable t) {
        LOGGER.warn(msg, t);
    }

    public static void info(String msg) {
        LOGGER.info(msg);
    }

    public static void onResourcesFinishedLoading() {
        if (initCompleted) {
            return;
        }
        initCompleted = true;
        try {
            WynntilsMod.initFeatures();
        }
        catch (Throwable t) {
            LOGGER.error("Failed to initialize Wynntils features", t);
        }
    }

    public static void init(ModLoader loader, String modVersion, boolean isDevelopmentEnvironment, File modFile) {
        modJar = modFile;
        modLoader = loader;
        developmentEnvironment = isDevelopmentEnvironment;
        WynntilsMod.parseVersion(modVersion);
        LOGGER.info("Wynntils: Starting version {} (using {} on Minecraft {})", new Object[]{version, modLoader, class_155.method_16673().method_48019()});
        eventBus = EventBusWrapper.createEventBus();
        WynntilsMod.registerComponents(Managers.class, Manager.class);
        WynntilsMod.registerComponents(Handlers.class, Handler.class);
        WynntilsMod.registerComponents(Models.class, Model.class);
        WynntilsMod.registerComponents(Services.class, Service.class);
        Managers.Storage.initComponents();
        Managers.Download.initComponents(componentMap);
        Managers.Url.loadUrls();
        WynntilsMod.addCrashCallbacks();
        WynntilsMod.postEvent(new WynntilsInitEvent.ModInitFinished());
    }

    public static void setupTestEnv() {
        if (initCompleted) {
            return;
        }
        class_155.method_36208();
        class_2966.method_12851();
        WynntilsMod.init(null, "SNAPSHOT", true, null);
        WynntilsMod.loadI18n();
        Managers.Function.init();
        Managers.Config.init();
        Managers.Storage.initFeatures();
        Services.Statistics.init();
        initCompleted = true;
    }

    private static void loadI18n() {
        Map langMap;
        Path langFile = Path.of("../common/src/main/resources/assets/wynntils/lang/en_us.json", new String[0]);
        Type type = new TypeToken<Map<String, String>>(){}.getType();
        try (BufferedReader reader = Files.newBufferedReader(langFile, StandardCharsets.UTF_8);){
            langMap = (Map)GSON.fromJson((Reader)reader, type);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load " + String.valueOf(langFile), e);
        }
        class_1078 language = new class_1078(langMap, false);
        class_1074.method_29391((class_2477)language);
    }

    private static void registerComponents(Class<?> registryClass, Class<? extends CoreComponent> componentClass) {
        List components = componentMap.computeIfAbsent(componentClass, k -> new ArrayList());
        FieldUtils.getAllFieldsList(registryClass).stream().filter(field -> componentClass.isAssignableFrom(field.getType())).forEach(field -> {
            try {
                CoreComponent component = (CoreComponent)field.get(null);
                WynntilsMod.registerEventListener(component);
                Managers.Storage.registerStorageable(component);
                components.add(component);
            }
            catch (IllegalAccessException e) {
                WynntilsMod.error("Internal error in " + registryClass.getSimpleName(), e);
                throw new RuntimeException(e);
            }
        });
    }

    private static void parseVersion(String modVersion) {
        developmentBuild = modVersion.contains("SNAPSHOT");
        version = "v" + modVersion;
    }

    private static void initFeatures() {
        Managers.Feature.init();
        Managers.Function.init();
        Managers.Config.init();
        Managers.Storage.initFeatures();
        Services.Statistics.init();
        LOGGER.info("Wynntils: {} features and {} functions are now loaded and ready", (Object)Managers.Feature.getFeatures().size(), (Object)Managers.Function.getFunctions().size());
    }

    private static void addCrashCallbacks() {
        Managers.CrashReport.registerCrashContext("In Development", () -> WynntilsMod.isDevelopmentEnvironment() ? "Yes" : "No");
    }

    public static void reportCrash(CrashType type, String niceName, String fullName, String reason, Throwable throwable) {
        WynntilsMod.reportCrash(type, niceName, fullName, reason, true, true, throwable);
    }

    public static void reportCrash(CrashType type, String niceName, String fullName, String reason, boolean shouldSendChat, boolean isDisabled, Throwable throwable) {
        WynntilsMod.warn("Disabling " + type.toString().toLowerCase(Locale.ROOT) + " " + niceName + " due to " + reason);
        WynntilsMod.error("Exception thrown by " + fullName, throwable);
        if (shouldSendChat) {
            McUtils.sendErrorToClient("Wynntils error: " + type.getName() + " '" + niceName + "' has crashed in " + reason + (isDisabled ? " and has been disabled" : ""));
        }
        WynntilsMod.postEvent(new WynntilsCrashEvent(fullName, type, throwable));
    }

    static {
        version = "";
        developmentBuild = false;
        initCompleted = false;
        componentMap = new HashMap<Class<? extends CoreComponent>, List<CoreComponent>>();
    }

    public static enum ModLoader {
        FORGE,
        FABRIC;

    }
}

