/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.core.consumers.functions.expressions;

import com.wynntils.core.components.Managers;
import com.wynntils.core.consumers.functions.Function;
import com.wynntils.core.consumers.functions.arguments.FunctionArguments;
import com.wynntils.core.consumers.functions.arguments.parser.ArgumentParser;
import com.wynntils.core.consumers.functions.expressions.Expression;
import com.wynntils.utils.type.ErrorOr;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class FunctionExpression
extends Expression {
    private static final Pattern FUNCTION_EXPRESSION_PATTERN = Pattern.compile("(?<function>[a-zA-Z_]+)(\\((?<argument>.*)\\))?(\\:(?<formatted>F)?(?<decimals>[0-9]+)?)?", 32);
    private final Function<?> function;
    private final List<Expression> argumentExpressions;
    private final boolean formatted;
    private final int decimals;

    private FunctionExpression(String rawExpression, Function<?> function, List<Expression> argumentExpressions, boolean formatted, int decimals) {
        super(rawExpression);
        this.function = function;
        this.argumentExpressions = argumentExpressions;
        this.formatted = formatted;
        this.decimals = decimals;
    }

    @Override
    public ErrorOr<Object> calculate() {
        ErrorOr<FunctionArguments> arguments = this.getArguments();
        if (arguments.hasError()) {
            return ErrorOr.error(arguments.getError());
        }
        return Managers.Function.getRawFunctionValue(this.function, arguments.getValue());
    }

    @Override
    public ErrorOr<String> calculateFormattedString() {
        ErrorOr<FunctionArguments> arguments = this.getArguments();
        if (arguments.hasError()) {
            return ErrorOr.error(arguments.getError());
        }
        return ErrorOr.of(Managers.Function.getStringFunctionValue(this.function, arguments.getValue(), this.formatted, this.decimals));
    }

    private ErrorOr<FunctionArguments> getArguments() {
        List<ErrorOr> calculatedExpressions = this.argumentExpressions.stream().map(Expression::calculate).toList();
        Optional<ErrorOr> firstError = calculatedExpressions.stream().filter(ErrorOr::hasError).findFirst();
        if (firstError.isPresent()) {
            return ErrorOr.error(firstError.get().getError());
        }
        return this.function.getArgumentsBuilder().buildWithValues(calculatedExpressions.stream().map(ErrorOr::getValue).toList());
    }

    public static ErrorOr<Optional<Expression>> tryParse(String rawExpression) {
        Matcher matcher = FUNCTION_EXPRESSION_PATTERN.matcher(rawExpression);
        if (!matcher.matches()) {
            return ErrorOr.of(Optional.empty());
        }
        Optional<Function<?>> functionOptional = Managers.Function.forName(matcher.group("function"));
        if (functionOptional.isEmpty()) {
            return ErrorOr.of(Optional.empty());
        }
        Function<?> function = functionOptional.get();
        boolean isFormatted = matcher.group("formatted") != null;
        String decimalMatch = matcher.group("decimals");
        int decimals = decimalMatch != null ? Integer.parseInt(decimalMatch) : 2;
        String rawArguments = matcher.group("argument");
        ErrorOr<List<Expression>> argumentExpressions = ArgumentParser.parseArguments(function.getArgumentsBuilder(), rawArguments);
        return argumentExpressions.hasError() ? ErrorOr.error(argumentExpressions.getError()) : ErrorOr.of(Optional.of(new FunctionExpression(rawExpression, function, argumentExpressions.getValue(), isFormatted, decimals)));
    }
}

