/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.core.events;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.events.EventThread;
import java.util.Arrays;
import java.util.Locale;
import net.neoforged.bus.BusBuilderImpl;
import net.neoforged.bus.EventBus;
import net.neoforged.bus.api.BusBuilder;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;

public class EventBusWrapper
extends EventBus {
    private EventBusWrapper(BusBuilderImpl busBuilder) {
        super(busBuilder);
    }

    public static IEventBus createEventBus() {
        if (WynntilsMod.isDevelopmentEnvironment()) {
            return new DevelopmentEnvironment((BusBuilderImpl)BusBuilder.builder());
        }
        return new EventBusWrapper((BusBuilderImpl)BusBuilder.builder());
    }

    @Override
    public void register(Object target) {
        boolean anyEvents = Arrays.stream(target.getClass().getMethods()).anyMatch(method -> method.isAnnotationPresent(SubscribeEvent.class));
        if (!anyEvents) {
            return;
        }
        super.register(target);
    }

    private static final class DevelopmentEnvironment
    extends EventBusWrapper {
        private DevelopmentEnvironment(BusBuilderImpl busBuilder) {
            super(busBuilder);
        }

        @Override
        public <T extends Event> T post(T event) {
            Class<?> eventClass = event.getClass();
            EventThread threadAnnotation = eventClass.getDeclaredAnnotation(EventThread.class);
            String threadName = Thread.currentThread().getName();
            if (threadAnnotation == null) {
                if (!threadName.equals("Render thread")) {
                    WynntilsMod.warn("Handling non-annotated event " + eventClass.getSimpleName() + " on thread " + threadName);
                }
            } else {
                boolean threadOk;
                switch (threadAnnotation.value()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case RENDER: {
                        boolean bl = threadName.equals("Render thread");
                        break;
                    }
                    case IO: {
                        boolean bl;
                        if (threadName.startsWith("Netty Epoll Client IO #") || threadName.startsWith("Netty Client IO #")) {
                            bl = true;
                            break;
                        }
                        bl = false;
                        break;
                    }
                    case WORKER: {
                        boolean bl = threadName.toLowerCase(Locale.ROOT).contains("pool");
                        break;
                    }
                    case ANY: {
                        boolean bl = threadOk = true;
                    }
                }
                if (!threadOk) {
                    WynntilsMod.warn("Handling event " + eventClass.getSimpleName() + " annotated as " + String.valueOf((Object)threadAnnotation.value()) + " on thread " + threadName);
                }
            }
            return super.post(event);
        }
    }
}

