/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.core.persisted.config;

import com.google.gson.reflect.TypeToken;
import com.wynntils.core.WynntilsMod;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.consumers.overlays.Overlay;
import com.wynntils.core.consumers.overlays.RenderState;
import com.wynntils.mc.event.RenderEvent;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.reflect.FieldUtils;

public class OverlayGroupHolder {
    private final Field field;
    private final Feature parent;
    private final int defaultCount;
    private final RenderEvent.ElementType elementType;
    private final RenderState renderState;
    private final Class<?> overlayClass;

    public OverlayGroupHolder(Field field, Feature parent, RenderEvent.ElementType elementType, RenderState renderState, int defaultCount) {
        this.field = field;
        this.parent = parent;
        this.elementType = elementType;
        this.renderState = renderState;
        this.defaultCount = defaultCount;
        Type genericType = this.field.getGenericType();
        if (!(genericType instanceof ParameterizedType)) {
            throw new IllegalArgumentException("Field " + field.getName() + " is not a list.");
        }
        ParameterizedType parameterizedType = (ParameterizedType)genericType;
        this.overlayClass = TypeToken.get((Type)parameterizedType.getActualTypeArguments()[0]).getRawType();
    }

    public String getConfigKey() {
        return this.parent.getJsonName() + ".groupedOverlay." + this.field.getName() + ".ids";
    }

    public int getOverlayCount() {
        try {
            return ((List)FieldUtils.readField((Field)this.field, (Object)this.parent, (boolean)true)).size();
        }
        catch (IllegalAccessException e) {
            return this.defaultCount;
        }
    }

    public List<? extends Overlay> getOverlays() {
        try {
            return (List)FieldUtils.readField((Field)this.field, (Object)this.parent, (boolean)true);
        }
        catch (IllegalAccessException e) {
            return List.of();
        }
    }

    public RenderEvent.ElementType getElementType() {
        return this.elementType;
    }

    public RenderState getRenderState() {
        return this.renderState;
    }

    public int getDefaultCount() {
        return this.defaultCount;
    }

    public Feature getParent() {
        return this.parent;
    }

    public String getFieldName() {
        return this.field.getName();
    }

    public Class<?> getOverlayClass() {
        return this.overlayClass;
    }

    public void initGroup(List<Integer> ids) {
        try {
            ArrayList<Overlay> overlays = new ArrayList<Overlay>();
            for (Integer id : ids) {
                overlays.add((Overlay)this.overlayClass.getConstructor(Integer.TYPE).newInstance(id));
            }
            FieldUtils.writeField((Field)this.field, (Object)this.parent, overlays, (boolean)true);
        }
        catch (Exception e) {
            WynntilsMod.error("Failed to initialize grouped overlay: " + this.field.getName(), e);
        }
    }
}

