/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.core.persisted.upfixers.config;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.wynntils.core.persisted.PersistedValue;
import com.wynntils.core.persisted.upfixers.Upfixer;
import com.wynntils.services.map.pois.CustomPoi;
import java.util.Set;

public class CustomPoiVisibilityUpfixer
implements Upfixer {
    private static final String CUSTOM_POIS_ARRAY = "mapFeature.customPois";
    private static final String CUSTOM_POIS_VISIBILITY = "visibility";
    private static final String CUSTOM_POIS_MINZOOM = "minZoom";

    @Override
    public boolean apply(JsonObject configObject, Set<PersistedValue<?>> persisteds) {
        JsonArray customPois = configObject.getAsJsonArray(CUSTOM_POIS_ARRAY);
        if (customPois == null) {
            return true;
        }
        for (JsonElement pois : customPois) {
            JsonObject poi = pois.getAsJsonObject();
            if (poi.has(CUSTOM_POIS_MINZOOM)) {
                float oldMinZoom = poi.getAsJsonPrimitive(CUSTOM_POIS_MINZOOM).getAsFloat();
                CustomPoi.Visibility visibility = CustomPoi.Visibility.DEFAULT;
                if (oldMinZoom == 2.1474836E9f) {
                    visibility = CustomPoi.Visibility.HIDDEN;
                } else if (oldMinZoom == -2.1474836E9f) {
                    visibility = CustomPoi.Visibility.ALWAYS;
                }
                poi.addProperty(CUSTOM_POIS_VISIBILITY, visibility.name());
                poi.remove(CUSTOM_POIS_MINZOOM);
                continue;
            }
            if (poi.has(CUSTOM_POIS_VISIBILITY) && !poi.get(CUSTOM_POIS_VISIBILITY).isJsonNull()) continue;
            poi.addProperty(CUSTOM_POIS_VISIBILITY, CustomPoi.Visibility.DEFAULT.name());
        }
        return true;
    }

    @Override
    public String getUpfixerName() {
        return "custom_poi_visibility";
    }
}

