/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.core.text;

import com.google.common.collect.Iterables;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.wynntils.core.text.PartStyle;
import com.wynntils.core.text.StyledTextPart;
import com.wynntils.core.text.type.StyleType;
import com.wynntils.utils.MathUtils;
import com.wynntils.utils.type.IterationDecision;
import com.wynntils.utils.type.Pair;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import net.minecraft.class_7417;

public final class StyledText
implements Iterable<StyledTextPart> {
    private static final char POSITIVE_SPACE_HIGH_SURROGATE = '\udb00';
    private static final char NEGATIVE_SPACE_HIGH_SURROGATE = '\udaff';
    public static final StyledText EMPTY = new StyledText(List.of(), List.of(), List.of());
    private final List<StyledTextPart> parts;
    private final List<class_2558> clickEvents;
    private final List<class_2568> hoverEvents;

    private StyledText(List<StyledTextPart> parts, List<class_2558> clickEvents, List<class_2568> hoverEvents) {
        this.parts = parts.stream().filter(styledTextPart -> !styledTextPart.isEmpty()).map((? super T styledTextPart) -> new StyledTextPart((StyledTextPart)styledTextPart, this)).collect(Collectors.toList());
        this.clickEvents = Collections.unmodifiableList(clickEvents);
        this.hoverEvents = Collections.unmodifiableList(hoverEvents);
    }

    public static StyledText fromComponent(class_2561 component) {
        ArrayList<StyledTextPart> parts = new ArrayList<StyledTextPart>();
        LinkedList<Pair<class_2561, class_2583>> deque = new LinkedList<Pair<class_2561, class_2583>>();
        deque.add(new Pair<class_2561, class_2583>(component, class_2583.field_24360));
        while (!deque.isEmpty()) {
            Pair currentPair = (Pair)deque.pop();
            class_2561 current = (class_2561)currentPair.key();
            class_2583 parentStyle = (class_2583)currentPair.value();
            String componentString = class_5250.method_43477((class_7417)current.method_10851()).getString();
            List<StyledTextPart> styledTextParts = StyledTextPart.fromCodedString(componentString, current.method_10866(), null, parentStyle);
            class_2583 styleToFollowForChildren = current.method_10866().method_27702(parentStyle);
            List<Pair> siblingPairs = current.method_10855().stream().map((? super T sibling) -> new Pair<class_2561, class_2583>((class_2561)sibling, styleToFollowForChildren)).collect(Collectors.toList());
            Collections.reverse(siblingPairs);
            siblingPairs.forEach(deque::addFirst);
            parts.addAll(styledTextParts.stream().filter(part -> !part.isEmpty()).toList());
        }
        return StyledText.fromParts(parts);
    }

    public static StyledText fromJson(JsonArray jsonArray) {
        return new StyledText(StyledTextPart.fromJson(jsonArray), List.of(), List.of());
    }

    public static StyledText fromString(String codedString) {
        return new StyledText(StyledTextPart.fromCodedString(codedString, class_2583.field_24360, null, class_2583.field_24360), List.of(), List.of());
    }

    public static StyledText fromModifiedString(String codedString, StyledText styledText) {
        List<class_2568> hoverEvents = List.copyOf(styledText.hoverEvents);
        List<class_2558> clickEvents = List.copyOf(styledText.clickEvents);
        return new StyledText(StyledTextPart.fromCodedString(codedString, class_2583.field_24360, styledText, class_2583.field_24360), clickEvents, hoverEvents);
    }

    public static StyledText fromUnformattedString(String unformattedString) {
        StyledTextPart part = new StyledTextPart(unformattedString, class_2583.field_24360, null, class_2583.field_24360);
        return new StyledText(List.of(part), List.of(), List.of());
    }

    public static StyledText fromPart(StyledTextPart part) {
        return StyledText.fromParts(List.of(part));
    }

    public static StyledText fromParts(List<StyledTextPart> parts) {
        ArrayList<class_2558> clickEvents = new ArrayList<class_2558>();
        ArrayList<class_2568> hoverEvents = new ArrayList<class_2568>();
        for (StyledTextPart part : parts) {
            class_2568 hoverEvent;
            class_2558 clickEvent = part.getPartStyle().getClickEvent();
            if (clickEvent != null && !clickEvents.contains(clickEvent)) {
                clickEvents.add(clickEvent);
            }
            if ((hoverEvent = part.getPartStyle().getHoverEvent()) == null || hoverEvents.contains(hoverEvent)) continue;
            hoverEvents.add(hoverEvent);
        }
        return new StyledText(parts, clickEvents, hoverEvents);
    }

    public String getString(StyleType type) {
        StringBuilder builder = new StringBuilder();
        PartStyle previousStyle = null;
        for (StyledTextPart part : this.parts) {
            builder.append(part.getString(previousStyle, type));
            previousStyle = part.getPartStyle();
        }
        return builder.toString();
    }

    public String getString() {
        return this.getString(StyleType.DEFAULT);
    }

    public String getStringWithoutFormatting() {
        return this.getString(StyleType.NONE);
    }

    public class_5250 getComponent() {
        if (this.parts.isEmpty()) {
            return class_2561.method_43473();
        }
        class_5250 component = class_2561.method_43473();
        for (StyledTextPart part : this.parts) {
            component.method_10852((class_2561)part.getComponent());
        }
        return component;
    }

    public int length() {
        return this.parts.stream().mapToInt(StyledTextPart::length).sum();
    }

    public int length(StyleType styleType) {
        return this.getString(styleType).length();
    }

    public static StyledText join(StyledText styledTextSeparator, StyledText ... texts) {
        ArrayList<StyledTextPart> parts = new ArrayList<StyledTextPart>();
        int length = texts.length;
        for (int i = 0; i < length; ++i) {
            StyledText text = texts[i];
            parts.addAll(text.parts);
            if (i == length - 1) continue;
            parts.addAll(styledTextSeparator.parts);
        }
        return StyledText.fromParts(parts);
    }

    public static StyledText join(StyledText styledTextSeparator, Iterable<StyledText> texts) {
        return StyledText.join(styledTextSeparator, (StyledText[])Iterables.toArray(texts, StyledText.class));
    }

    public static StyledText join(String codedStringSeparator, StyledText ... texts) {
        return StyledText.join(StyledText.fromString(codedStringSeparator), texts);
    }

    public static StyledText join(String codedStringSeparator, Iterable<StyledText> texts) {
        return StyledText.join(StyledText.fromString(codedStringSeparator), (StyledText[])Iterables.toArray(texts, StyledText.class));
    }

    public static StyledText concat(StyledText ... texts) {
        return StyledText.fromParts(Arrays.stream(texts).map((? super T text) -> text.parts).flatMap(Collection::stream).toList());
    }

    public static StyledText concat(Iterable<StyledText> texts) {
        return StyledText.concat((StyledText[])Iterables.toArray(texts, StyledText.class));
    }

    public StyledText getNormalized() {
        return StyledText.fromParts(this.parts.stream().map(StyledTextPart::asNormalized).collect(Collectors.toList()));
    }

    public StyledText stripAlignment() {
        return this.iterate((part, functionParts) -> {
            String text = part.getString(null, StyleType.NONE);
            if (text.contains(String.valueOf('\udb00')) || text.contains(String.valueOf('\udaff'))) {
                StringBuilder builder = new StringBuilder();
                for (int i = 0; i < text.length(); ++i) {
                    char ch = text.charAt(i);
                    if (Character.isHighSurrogate(ch) && (ch == '\udb00' || ch == '\udaff')) {
                        if (i + 1 >= text.length() || !Character.isLowSurrogate(text.charAt(i + 1))) continue;
                        ++i;
                        continue;
                    }
                    builder.append(ch);
                }
                functionParts.set(0, new StyledTextPart(builder.toString(), part.getPartStyle().getStyle(), null, class_2583.field_24360));
            }
            return IterationDecision.CONTINUE;
        });
    }

    public StyledText trim() {
        if (this.parts.isEmpty()) {
            return this;
        }
        ArrayList<StyledTextPart> newParts = new ArrayList<StyledTextPart>(this.parts);
        newParts.set(0, ((StyledTextPart)newParts.getFirst()).stripLeading());
        int lastIndex = newParts.size() - 1;
        newParts.set(lastIndex, ((StyledTextPart)newParts.get(lastIndex)).stripTrailing());
        return StyledText.fromParts(newParts);
    }

    public boolean isEmpty() {
        return this.parts.isEmpty();
    }

    public boolean isBlank() {
        return this.parts.stream().allMatch(StyledTextPart::isBlank);
    }

    public boolean contains(String codedString) {
        return this.contains(codedString, StyleType.DEFAULT);
    }

    public boolean contains(StyledText styledText) {
        return this.contains(styledText.getString(StyleType.DEFAULT), StyleType.DEFAULT);
    }

    public boolean contains(String codedString, StyleType styleType) {
        return this.getString(styleType).contains(codedString);
    }

    public boolean contains(StyledText styledText, StyleType styleType) {
        return this.contains(styledText.getString(styleType), styleType);
    }

    public boolean startsWith(String codedString) {
        return this.startsWith(codedString, StyleType.DEFAULT);
    }

    public boolean startsWith(StyledText styledText) {
        return this.startsWith(styledText.getString(StyleType.DEFAULT), StyleType.DEFAULT);
    }

    public boolean startsWith(String codedString, StyleType styleType) {
        return this.getString(styleType).startsWith(codedString);
    }

    public boolean startsWith(StyledText styledText, StyleType styleType) {
        return this.startsWith(styledText.getString(styleType), styleType);
    }

    public boolean endsWith(String codedString) {
        return this.endsWith(codedString, StyleType.DEFAULT);
    }

    public boolean endsWith(StyledText styledText) {
        return this.endsWith(styledText.getString(StyleType.DEFAULT), StyleType.DEFAULT);
    }

    public boolean endsWith(String codedString, StyleType styleType) {
        return this.getString(styleType).endsWith(codedString);
    }

    public boolean endsWith(StyledText styledText, StyleType styleType) {
        return this.endsWith(styledText.getString(styleType), styleType);
    }

    public Matcher getMatcher(Pattern pattern) {
        return this.getMatcher(pattern, StyleType.DEFAULT);
    }

    public Matcher getMatcher(Pattern pattern, StyleType styleType) {
        return pattern.matcher(this.getString(styleType));
    }

    public boolean matches(Pattern pattern) {
        return this.matches(pattern, StyleType.DEFAULT);
    }

    public boolean matches(Pattern pattern, StyleType styleType) {
        return pattern.matcher(this.getString(styleType)).matches();
    }

    public boolean find(Pattern pattern) {
        return this.find(pattern, StyleType.DEFAULT);
    }

    public boolean find(Pattern pattern, StyleType styleType) {
        return pattern.matcher(this.getString(styleType)).find();
    }

    public StyledText append(StyledText styledText) {
        return StyledText.concat(this, styledText);
    }

    public StyledText append(String codedString) {
        return this.append(StyledText.fromString(codedString));
    }

    public StyledText appendPart(StyledTextPart part) {
        ArrayList<StyledTextPart> newParts = new ArrayList<StyledTextPart>(this.parts);
        newParts.add(part);
        return StyledText.fromParts(newParts);
    }

    public StyledText prepend(StyledText styledText) {
        return StyledText.concat(styledText, this);
    }

    public StyledText prepend(String codedString) {
        return this.prepend(StyledText.fromString(codedString));
    }

    public StyledText prependPart(StyledTextPart part) {
        ArrayList<StyledTextPart> newParts = new ArrayList<StyledTextPart>(this.parts);
        newParts.addFirst(part);
        return StyledText.fromParts(newParts);
    }

    public StyledText[] split(String regex) {
        return this.split(regex, false);
    }

    public StyledText[] split(String regex, boolean keepTrailingEmpty) {
        if (this.parts.isEmpty()) {
            return new StyledText[]{EMPTY};
        }
        Pattern pattern = Pattern.compile(regex);
        ArrayList<StyledText> splitTexts = new ArrayList<StyledText>();
        ArrayList<StyledTextPart> splitParts = new ArrayList<StyledTextPart>();
        for (int i = 0; i < this.parts.size(); ++i) {
            StyledTextPart part = this.parts.get(i);
            String partString = part.getString(null, StyleType.NONE);
            int maxSplit = !keepTrailingEmpty && i == this.parts.size() - 1 ? 0 : -1;
            List<String> stringParts = Arrays.stream(pattern.split(partString, maxSplit)).toList();
            Matcher matcher = pattern.matcher(partString);
            if (matcher.find()) {
                for (int j = 0; j < stringParts.size(); ++j) {
                    String stringPart = stringParts.get(j);
                    splitParts.add(new StyledTextPart(stringPart, part.getPartStyle().getStyle(), null, class_2583.field_24360));
                    if (j == stringParts.size() - 1) continue;
                    splitTexts.add(StyledText.fromParts(splitParts));
                    splitParts.clear();
                }
                continue;
            }
            splitParts.add(part);
        }
        if (!splitParts.isEmpty()) {
            splitTexts.add(StyledText.fromParts(splitParts));
        }
        return (StyledText[])splitTexts.toArray(StyledText[]::new);
    }

    public StyledText substring(int beginIndex) {
        return this.substring(beginIndex, this.length(), StyleType.NONE);
    }

    public StyledText substring(int beginIndex, StyleType styleType) {
        return this.substring(beginIndex, this.length(styleType), styleType);
    }

    public StyledText substring(int beginIndex, int endIndex) {
        return this.substring(beginIndex, endIndex, StyleType.NONE);
    }

    public StyledText substring(int beginIndex, int endIndex, StyleType styleType) {
        if (endIndex < beginIndex) {
            throw new IndexOutOfBoundsException("endIndex must be greater than beginIndex");
        }
        if (beginIndex < 0) {
            throw new IndexOutOfBoundsException("beginIndex must be greater than or equal to 0");
        }
        if (endIndex > this.length(styleType)) {
            throw new IndexOutOfBoundsException("endIndex must be less than or equal to length(styleType)");
        }
        ArrayList<StyledTextPart> includedParts = new ArrayList<StyledTextPart>();
        int currentIndex = 0;
        PartStyle previousPartStyle = null;
        for (StyledTextPart part : this.parts) {
            if (currentIndex >= beginIndex && currentIndex + part.length() < endIndex) {
                includedParts.add(part);
            } else if (MathUtils.rangesIntersect(currentIndex, currentIndex + part.length(), beginIndex, endIndex - 1)) {
                int startIndexInPart = Math.max(0, beginIndex - currentIndex);
                int endIndexInPart = Math.min(part.length(), endIndex - currentIndex);
                String fullString = part.getString(previousPartStyle, styleType);
                String beforeSubstring = fullString.substring(0, startIndexInPart);
                String includedSubstring = fullString.substring(startIndexInPart, endIndexInPart);
                if (beforeSubstring.endsWith(String.valueOf('\u00a7')) || includedSubstring.endsWith(String.valueOf('\u00a7'))) {
                    throw new IllegalArgumentException("The substring splits a formatting code.");
                }
                includedParts.addAll(StyledTextPart.fromCodedString(includedSubstring, part.getPartStyle().getStyle(), null, class_2583.field_24360));
            }
            currentIndex += part.getString(previousPartStyle, styleType).length();
            previousPartStyle = part.getPartStyle();
        }
        return StyledText.fromParts(includedParts);
    }

    public StyledText[] partition(int ... indexes) {
        return this.partition(StyleType.NONE, indexes);
    }

    public StyledText[] partition(StyleType styleType, int ... indexes) {
        if (indexes.length == 0) {
            return new StyledText[]{this};
        }
        ArrayList<StyledText> splitTexts = new ArrayList<StyledText>();
        int currentIndex = 0;
        for (int index : indexes) {
            if (index < currentIndex) {
                throw new IllegalArgumentException("Indexes must be in ascending order");
            }
            splitTexts.add(this.substring(currentIndex, index, styleType));
            currentIndex = index;
        }
        splitTexts.add(this.substring(currentIndex, styleType));
        return (StyledText[])splitTexts.toArray(StyledText[]::new);
    }

    public StyledText replaceFirst(String regex, String replacement) {
        return this.replaceFirst(Pattern.compile(regex), replacement);
    }

    public StyledText replaceFirst(Pattern pattern, String replacement) {
        ArrayList<StyledTextPart> newParts = new ArrayList<StyledTextPart>();
        for (StyledTextPart part : this.parts) {
            String partString = part.getString(null, StyleType.NONE);
            Matcher matcher = pattern.matcher(partString);
            if (matcher.find()) {
                String replacedString = matcher.replaceFirst(replacement);
                newParts.add(new StyledTextPart(replacedString, part.getPartStyle().getStyle(), null, class_2583.field_24360));
                newParts.addAll(this.parts.subList(this.parts.indexOf(part) + 1, this.parts.size()));
                break;
            }
            newParts.add(part);
        }
        return StyledText.fromParts(newParts);
    }

    public StyledText replaceAll(String regex, String replacement) {
        return this.replaceAll(Pattern.compile(regex), replacement);
    }

    public StyledText replaceAll(Pattern pattern, String replacement) {
        ArrayList<StyledTextPart> newParts = new ArrayList<StyledTextPart>();
        for (StyledTextPart part : this.parts) {
            String partString = part.getString(null, StyleType.NONE);
            Matcher matcher = pattern.matcher(partString);
            if (matcher.find()) {
                String replacedString = matcher.replaceAll(replacement);
                newParts.add(new StyledTextPart(replacedString, part.getPartStyle().getStyle(), null, class_2583.field_24360));
                continue;
            }
            newParts.add(part);
        }
        return StyledText.fromParts(newParts);
    }

    public StyledText[] getPartsAsTextArray() {
        return (StyledText[])this.parts.stream().map(StyledText::fromPart).toArray(StyledText[]::new);
    }

    public StyledText iterate(BiFunction<StyledTextPart, List<StyledTextPart>, IterationDecision> function) {
        ArrayList<StyledTextPart> newParts = new ArrayList<StyledTextPart>();
        for (int i = 0; i < this.parts.size(); ++i) {
            StyledTextPart part = this.parts.get(i);
            ArrayList<StyledTextPart> functionParts = new ArrayList<StyledTextPart>();
            functionParts.add(part);
            IterationDecision decision = function.apply(part, functionParts);
            newParts.addAll(functionParts);
            if (decision != IterationDecision.BREAK) continue;
            newParts.addAll(this.parts.subList(i + 1, this.parts.size()));
            break;
        }
        return StyledText.fromParts(newParts);
    }

    public StyledText iterateBackwards(BiFunction<StyledTextPart, List<StyledTextPart>, IterationDecision> function) {
        ArrayList<StyledTextPart> newParts = new ArrayList<StyledTextPart>();
        for (int i = this.parts.size() - 1; i >= 0; --i) {
            StyledTextPart part = this.parts.get(i);
            ArrayList<StyledTextPart> functionParts = new ArrayList<StyledTextPart>();
            functionParts.add(part);
            IterationDecision decision = function.apply(part, functionParts);
            newParts.addAll(0, functionParts);
            if (decision != IterationDecision.BREAK) continue;
            newParts.addAll(0, this.parts.subList(0, i));
            break;
        }
        return StyledText.fromParts(newParts);
    }

    public StyledText map(Function<StyledTextPart, StyledTextPart> function) {
        return StyledText.fromParts(this.parts.stream().map(function).collect(Collectors.toList()));
    }

    public StyledText withoutFormatting() {
        return this.iterate((part, functionParts) -> {
            functionParts.set(0, new StyledTextPart(part.getString(null, StyleType.NONE), class_2583.field_24360, null, class_2583.field_24360));
            return IterationDecision.CONTINUE;
        });
    }

    public boolean equalsString(String string) {
        return this.equalsString(string, StyleType.DEFAULT);
    }

    public boolean equalsString(String string, StyleType styleType) {
        return this.getString(styleType).equals(string);
    }

    public StyledTextPart getFirstPart() {
        if (this.parts.isEmpty()) {
            return null;
        }
        return this.parts.getFirst();
    }

    public StyledTextPart getLastPart() {
        if (this.parts.isEmpty()) {
            return null;
        }
        return this.parts.getLast();
    }

    public int getPartCount() {
        return this.parts.size();
    }

    int getClickEventIndex(class_2558 clickEvent) {
        for (int i = 0; i < this.clickEvents.size(); ++i) {
            class_2558 event = this.clickEvents.get(i);
            if (!event.equals((Object)clickEvent)) continue;
            return i + 1;
        }
        return -1;
    }

    class_2558 getClickEvent(int index) {
        return (class_2558)Iterables.get(this.clickEvents, (int)(index - 1), null);
    }

    int getHoverEventIndex(class_2568 hoverEvent) {
        for (int i = 0; i < this.hoverEvents.size(); ++i) {
            class_2568 event = this.hoverEvents.get(i);
            if (!event.equals((Object)hoverEvent)) continue;
            return i + 1;
        }
        return -1;
    }

    class_2568 getHoverEvent(int index) {
        return (class_2568)Iterables.get(this.hoverEvents, (int)(index - 1), null);
    }

    private StyledTextPart getPartBefore(StyledTextPart part) {
        int index = this.parts.indexOf(part);
        if (index == 0) {
            return null;
        }
        return this.parts.get(index - 1);
    }

    @Override
    public Iterator<StyledTextPart> iterator() {
        return this.parts.iterator();
    }

    public String toString() {
        return "StyledText{'" + this.getString(StyleType.COMPLETE) + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StyledText that = (StyledText)o;
        return Objects.deepEquals(this.parts, that.parts) && Objects.deepEquals(this.clickEvents, that.clickEvents) && Objects.deepEquals(this.hoverEvents, that.hoverEvents);
    }

    public int hashCode() {
        return Objects.hash(this.parts, this.clickEvents, this.hoverEvents);
    }

    public static class StyledTextSerializer
    implements JsonSerializer<StyledText>,
    JsonDeserializer<StyledText> {
        public StyledText deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return StyledText.fromString(json.getAsString());
        }

        public JsonElement serialize(StyledText src, Type typeOfSrc, JsonSerializationContext context) {
            return context.serialize((Object)src.getString());
        }
    }
}

