/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.chat;

import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.core.text.PartStyle;
import com.wynntils.core.text.StyledText;
import com.wynntils.core.text.StyledTextPart;
import com.wynntils.core.text.type.StyleType;
import com.wynntils.handlers.chat.event.ChatMessageEvent;
import com.wynntils.handlers.chat.type.RecipientType;
import com.wynntils.utils.colors.ColorChatFormatting;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.type.IterationDecision;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_2583;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;

@ConfigCategory(value=Category.CHAT)
public class ChatMentionFeature
extends Feature {
    private static final Pattern END_OF_HEADER_PATTERN = Pattern.compile(".*:\\s?");
    private static final Pattern NON_WORD_CHARACTERS = Pattern.compile("\\W");
    @Persisted
    private final Config<Boolean> markMention = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> dingMention = new Config<Boolean>(true);
    @Persisted
    private final Config<ColorChatFormatting> mentionColor = new Config<ColorChatFormatting>(ColorChatFormatting.YELLOW);
    @Persisted
    private final Config<String> aliases = new Config<String>("");
    @Persisted
    private final Config<Boolean> suppressMentionsInInfo = new Config<Boolean>(false);
    private List<Pattern> mentionPatterns = this.buildPattern();

    @Override
    protected void onConfigUpdate(Config<?> config) {
        this.mentionPatterns = this.buildPattern();
    }

    private List<Pattern> buildPattern() {
        ArrayList<Pattern> returnable = new ArrayList<Pattern>();
        ArrayList<String> splitAliases = new ArrayList<String>();
        splitAliases.add(McUtils.mc().method_1548().method_1676());
        splitAliases.addAll(Arrays.asList(((String)this.aliases.get()).split(",")));
        for (String alias : splitAliases) {
            if (alias.isEmpty()) continue;
            Matcher nonWordMatcher = NON_WORD_CHARACTERS.matcher(alias);
            if (nonWordMatcher.find()) {
                String quotedAlias = Pattern.quote(alias);
                returnable.add(Pattern.compile("(?:\\s|^)(" + quotedAlias + ")(?:\\s|$)", 2));
                continue;
            }
            returnable.add(Pattern.compile("(?<!\\[)\\b(" + alias + ")\\b(?!:|])", 2));
        }
        return returnable;
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onChat(ChatMessageEvent.Edit e) {
        StyledText modified;
        if (e.getRecipientType() == RecipientType.INFO && ((Boolean)this.suppressMentionsInInfo.get()).booleanValue()) {
            return;
        }
        StyledText message = e.getMessage();
        if (message.equals(modified = message.iterateBackwards((part, changes) -> {
            if (END_OF_HEADER_PATTERN.matcher(part.getString(null, StyleType.NONE)).matches()) {
                return IterationDecision.BREAK;
            }
            StyledTextPart partToReplace = part;
            for (Pattern pattern : this.mentionPatterns) {
                Matcher matcher = pattern.matcher(partToReplace.getString(null, StyleType.NONE));
                while (matcher.find()) {
                    String match = partToReplace.getString(null, StyleType.NONE);
                    String firstPart = match.substring(0, matcher.start());
                    String mentionPart = match.substring(matcher.start(), matcher.end());
                    String lastPart = match.substring(matcher.end());
                    PartStyle partStyle = partToReplace.getPartStyle();
                    StyledTextPart first = new StyledTextPart(firstPart, partStyle.getStyle(), null, class_2583.field_24360);
                    StyledTextPart mention = new StyledTextPart(mentionPart, partStyle.getStyle().method_10977(((ColorChatFormatting)((Object)((Object)this.mentionColor.get()))).getChatFormatting()), null, first.getPartStyle().getStyle());
                    StyledTextPart last = new StyledTextPart(lastPart, partStyle.getStyle(), null, class_2583.field_24360);
                    changes.remove(partToReplace);
                    changes.add(first);
                    changes.add(mention);
                    changes.add(last);
                    partToReplace = last;
                    matcher = pattern.matcher(lastPart);
                }
            }
            return IterationDecision.CONTINUE;
        }))) {
            return;
        }
        if (((Boolean)this.markMention.get()).booleanValue()) {
            e.setMessage(modified);
        }
        if (((Boolean)this.dingMention.get()).booleanValue()) {
            McUtils.playSoundUI((class_3414)class_3417.field_14622.comp_349());
        }
    }
}

