/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.combat;

import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.consumers.features.properties.RegisterKeyBind;
import com.wynntils.core.keybinds.KeyBind;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.mc.event.ArmSwingEvent;
import com.wynntils.mc.event.ChangeCarriedItemEvent;
import com.wynntils.mc.event.TickEvent;
import com.wynntils.mc.event.UseItemEvent;
import com.wynntils.models.character.type.ClassType;
import com.wynntils.models.items.properties.ClassableItemProperty;
import com.wynntils.models.items.properties.RequirementItemProperty;
import com.wynntils.models.spells.type.SpellDirection;
import com.wynntils.models.worlds.event.WorldStateEvent;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.wynn.ItemUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.neoforged.bus.api.SubscribeEvent;

@ConfigCategory(value=Category.COMBAT)
public class QuickCastFeature
extends Feature {
    @RegisterKeyBind
    private final KeyBind castFirstSpell = new KeyBind("Cast 1st Spell", 90, false, this::castFirstSpell);
    @RegisterKeyBind
    private final KeyBind castSecondSpell = new KeyBind("Cast 2nd Spell", 88, false, this::castSecondSpell);
    @RegisterKeyBind
    private final KeyBind castThirdSpell = new KeyBind("Cast 3rd Spell", 67, false, this::castThirdSpell);
    @RegisterKeyBind
    private final KeyBind castFourthSpell = new KeyBind("Cast 4th Spell", 86, false, this::castFourthSpell);
    @Persisted
    private final Config<Integer> leftClickTickDelay = new Config<Integer>(3);
    @Persisted
    private final Config<Integer> rightClickTickDelay = new Config<Integer>(3);
    @Persisted
    private final Config<Boolean> blockAttacks = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> checkValidWeapon = new Config<Boolean>(true);
    @Persisted
    private final Config<SafeCastType> safeCasting = new Config<SafeCastType>(SafeCastType.NONE);
    @Persisted
    private final Config<Integer> spellCooldown = new Config<Integer>(0);
    private int lastSpellTick = 0;
    private int packetCountdown = 0;

    @SubscribeEvent
    public void onSwing(ArmSwingEvent event) {
        this.lastSpellTick = McUtils.player().field_6012;
        if (!((Boolean)this.blockAttacks.get()).booleanValue()) {
            return;
        }
        if (event.getActionContext() != ArmSwingEvent.ArmSwingContext.ATTACK_OR_START_BREAKING_BLOCK) {
            return;
        }
        if (event.getHand() != class_1268.field_5808) {
            return;
        }
        if (Models.Spell.isSpellQueueEmpty()) {
            return;
        }
        event.setCanceled(true);
    }

    @SubscribeEvent
    public void onUseItem(UseItemEvent event) {
        this.lastSpellTick = McUtils.player().field_6012;
        if (!((Boolean)this.blockAttacks.get()).booleanValue()) {
            return;
        }
        if (Models.Spell.isSpellQueueEmpty()) {
            return;
        }
        event.setCanceled(true);
    }

    @SubscribeEvent
    public void onHeldItemChange(ChangeCarriedItemEvent event) {
        this.resetState();
    }

    @SubscribeEvent
    public void onWorldChange(WorldStateEvent e) {
        this.resetState();
    }

    private void castFirstSpell() {
        this.tryCastSpell(SpellUnit.PRIMARY, SpellUnit.SECONDARY, SpellUnit.PRIMARY);
    }

    private void castSecondSpell() {
        this.tryCastSpell(SpellUnit.PRIMARY, SpellUnit.PRIMARY, SpellUnit.PRIMARY);
    }

    private void castThirdSpell() {
        this.tryCastSpell(SpellUnit.PRIMARY, SpellUnit.SECONDARY, SpellUnit.SECONDARY);
    }

    private void castFourthSpell() {
        this.tryCastSpell(SpellUnit.PRIMARY, SpellUnit.PRIMARY, SpellUnit.SECONDARY);
    }

    private void tryCastSpell(SpellUnit a, SpellUnit b, SpellUnit c) {
        boolean isArcher;
        if (!Models.Spell.isSpellQueueEmpty()) {
            return;
        }
        SpellDirection[] spellInProgress = Models.Spell.getLastSpell();
        if (spellInProgress.length == 3) {
            spellInProgress = SpellDirection.NO_SPELL;
        }
        if (this.safeCasting.get() == SafeCastType.BLOCK_ALL && spellInProgress.length != 0) {
            QuickCastFeature.sendCancelReason(class_2561.method_43471((String)"feature.wynntils.quickCast.spellInProgress"));
            return;
        }
        if (this.safeCasting.get() == SafeCastType.FINISH_COMPATIBLE && spellInProgress.length != 0 && this.lastSpellTick == 0) {
            QuickCastFeature.sendCancelReason(class_2561.method_43471((String)"feature.wynntils.quickCast.spellInProgress"));
            return;
        }
        boolean bl = isArcher = Models.Character.getClassType() == ClassType.ARCHER;
        if (((Boolean)this.checkValidWeapon.get()).booleanValue()) {
            class_1799 heldItem = McUtils.player().method_5998(class_1268.field_5808);
            if (!ItemUtils.isWeapon(heldItem)) {
                QuickCastFeature.sendCancelReason(class_2561.method_43471((String)"feature.wynntils.quickCast.notAWeapon"));
                return;
            }
            Optional<ClassableItemProperty> classItemPropOpt = Models.Item.asWynnItemProperty(heldItem, ClassableItemProperty.class);
            if (classItemPropOpt.isEmpty()) {
                QuickCastFeature.sendCancelReason(class_2561.method_43471((String)"feature.wynntils.quickCast.notAWeapon"));
                return;
            }
            isArcher = classItemPropOpt.get().getRequiredClass() == ClassType.ARCHER;
            Optional<RequirementItemProperty> reqItemPropOpt = Models.Item.asWynnItemProperty(heldItem, RequirementItemProperty.class);
            if (reqItemPropOpt.isPresent() && !reqItemPropOpt.get().meetsActualRequirements()) {
                QuickCastFeature.sendCancelReason(class_2561.method_43471((String)"feature.wynntils.quickCast.notMetRequirements"));
                return;
            }
        }
        boolean isSpellInverted = isArcher;
        List<SpellDirection> unconfirmedSpell = Stream.of(a, b, c).map(x -> x == SpellUnit.PRIMARY == isSpellInverted ? SpellDirection.LEFT : SpellDirection.RIGHT).toList();
        ArrayList<SpellDirection> confirmedSpell = new ArrayList<SpellDirection>(unconfirmedSpell);
        if (this.safeCasting.get() == SafeCastType.FINISH_COMPATIBLE && spellInProgress.length != 0) {
            for (int i = 0; i < spellInProgress.length; ++i) {
                if (spellInProgress[i] != unconfirmedSpell.get(i)) {
                    QuickCastFeature.sendCancelReason(class_2561.method_43471((String)"feature.wynntils.quickCast.incompatibleInProgress"));
                    return;
                }
                confirmedSpell.removeFirst();
            }
        }
        Models.Spell.addSpellToQueue(confirmedSpell);
    }

    @SubscribeEvent
    public void onTick(TickEvent e) {
        if (!Models.WorldState.onWorld()) {
            return;
        }
        if (this.packetCountdown > 0) {
            --this.packetCountdown;
        }
        if (this.packetCountdown > 0) {
            return;
        }
        if (Models.Spell.isSpellQueueEmpty()) {
            return;
        }
        SpellDirection nextDirection = Models.Spell.checkNextSpellDirection();
        if (nextDirection == null) {
            return;
        }
        int comparisonTime = nextDirection == SpellDirection.LEFT ? (Integer)this.leftClickTickDelay.get() : (Integer)this.rightClickTickDelay.get();
        if (McUtils.player().field_6012 - this.lastSpellTick < comparisonTime) {
            return;
        }
        Models.Spell.sendNextSpell();
        this.lastSpellTick = McUtils.player().field_6012;
        if (Models.Spell.isSpellQueueEmpty()) {
            this.lastSpellTick = 0;
            this.packetCountdown = Math.max(this.packetCountdown, (Integer)this.spellCooldown.get());
        }
    }

    private void resetState() {
        this.lastSpellTick = 0;
        this.packetCountdown = 0;
    }

    private static void sendCancelReason(class_5250 reason) {
        Managers.Notification.queueMessage((class_2561)reason.method_27692(class_124.field_1061));
    }

    public static enum SafeCastType {
        NONE,
        BLOCK_ALL,
        FINISH_COMPATIBLE;

    }

    public static enum SpellUnit {
        PRIMARY,
        SECONDARY;

    }
}

