/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.debug;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.consumers.features.properties.RegisterCommand;
import com.wynntils.core.consumers.features.properties.RegisterKeyBind;
import com.wynntils.core.consumers.features.properties.StartDisabled;
import com.wynntils.core.keybinds.KeyBind;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.core.text.StyledText;
import com.wynntils.models.items.WynnItem;
import com.wynntils.utils.mc.LoreUtils;
import com.wynntils.utils.mc.McUtils;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1304;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;

@StartDisabled
@ConfigCategory(value=Category.DEBUG)
public class LogItemInfoFeature
extends Feature {
    @RegisterKeyBind
    private final KeyBind logItemInfoKeyBind = new KeyBind("Log Item Info", 260, true, this::onLogItemInfoPress, this::onLogItemInfoInventoryPress);
    @RegisterCommand
    private final LiteralCommandNode<class_2168> commandNode = ((LiteralArgumentBuilder)class_2170.method_9247((String)"show").executes(this::showCommand)).build();

    private void onLogItemInfoPress() {
        this.logItem(McUtils.player().method_6118(class_1304.field_6173));
    }

    private void onLogItemInfoInventoryPress(class_1735 hoveredSlot) {
        if (hoveredSlot == null) {
            return;
        }
        this.logItem(hoveredSlot.method_7677());
    }

    private void logItem(class_1799 itemStack) {
        String description = LogItemInfoFeature.getDescription(itemStack);
        WynntilsMod.info(description);
        McUtils.sendMessageToClient((class_2561)class_2561.method_43470((String)description).method_27692(class_124.field_1075));
    }

    private int showCommand(CommandContext<class_2168> context) {
        String description = LogItemInfoFeature.getDescription(McUtils.player().method_6118(class_1304.field_6173));
        WynntilsMod.info(description);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)description).method_27692(class_124.field_1075), false);
        return 1;
    }

    private static String getDescription(class_1799 itemStack) {
        Optional<WynnItem> wynnItemOpt = Models.Item.getWynnItem(itemStack);
        String wynnItemDesc = wynnItemOpt.isPresent() ? wynnItemOpt.get().toString() : "<N/A>";
        return "[Logging Item]\nName: " + String.valueOf(StyledText.fromComponent(itemStack.method_7964())) + "\nLore:\n" + String.valueOf(StyledText.join("\n", LoreUtils.getLore(itemStack))) + "\nItem Type: " + String.valueOf(itemStack.method_7909()) + "\nDamage Value: " + itemStack.method_7919() + "\nWynn Item: " + wynnItemDesc + "\nNBT: " + itemStack.method_57380().toString().replace('\u00a7', '&') + "\nGlint: " + itemStack.method_7958();
    }
}

