/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.embellishments;

import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.consumers.features.properties.StartDisabled;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.mc.event.DataComponentGetEvent;
import com.wynntils.models.items.properties.ShinyItemProperty;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_1844;
import net.minecraft.class_9282;
import net.neoforged.bus.api.SubscribeEvent;

@StartDisabled
@ConfigCategory(value=Category.EMBELLISHMENTS)
public class RemoveShinyGlintFeature
extends Feature {
    private static final int SHINY_GLINT_COLOR = 0x1FFF00;
    @Persisted
    private final Config<Boolean> replaceGlint = new Config<Boolean>(true);

    @SubscribeEvent
    public void onGetPotionContents(DataComponentGetEvent.PotionContents event) {
        if (!this.hasShinyStat(event.getItemStack())) {
            return;
        }
        class_1844 itemStackPotionContents = (class_1844)event.getOriginalValue();
        Optional potionColor = itemStackPotionContents.comp_2379();
        if (potionColor.isEmpty()) {
            return;
        }
        if ((Integer)potionColor.get() != 0x1FFF00) {
            return;
        }
        event.setValue(new class_1844(itemStackPotionContents.comp_2378(), Optional.empty(), itemStackPotionContents.comp_2380(), itemStackPotionContents.comp_3209()));
    }

    @SubscribeEvent
    public void onGetDyeColor(DataComponentGetEvent.DyedItemColor event) {
        if (!this.hasShinyStat(event.getItemStack())) {
            return;
        }
        class_9282 dyeColor = (class_9282)event.getOriginalValue();
        if (dyeColor == null) {
            return;
        }
        if (dyeColor.comp_2384() != 0x1FFF00) {
            return;
        }
        event.setValue(null);
    }

    @SubscribeEvent
    public void onGetEnchantmentOverride(DataComponentGetEvent.EnchantmentGlintOverride event) {
        if (!this.hasShinyStat(event.getItemStack())) {
            return;
        }
        if (((Boolean)this.replaceGlint.get()).booleanValue()) {
            event.setValue(true);
        }
    }

    private boolean hasShinyStat(class_1799 itemStack) {
        Optional<ShinyItemProperty> shinyItemProperty = Models.Item.asWynnItemProperty(itemStack, ShinyItemProperty.class);
        return shinyItemProperty.isPresent() && shinyItemProperty.get().getShinyStat().isPresent();
    }
}

