/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.inventory;

import com.wynntils.core.components.Models;
import com.wynntils.core.components.Services;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.consumers.features.properties.RegisterKeyBind;
import com.wynntils.core.keybinds.KeyBind;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.core.persisted.config.HiddenConfig;
import com.wynntils.core.text.StyledText;
import com.wynntils.mc.event.ContainerCloseEvent;
import com.wynntils.mc.event.ScreenOpenedEvent;
import com.wynntils.mc.event.SlotRenderEvent;
import com.wynntils.models.containers.containers.reward.RewardContainer;
import com.wynntils.models.containers.type.FullscreenContainerProperty;
import com.wynntils.models.items.WynnItem;
import com.wynntils.models.items.properties.NamedItemProperty;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.Texture;
import com.wynntils.utils.render.buffered.BufferedRenderUtils;
import com.wynntils.utils.wynn.ContainerUtils;
import com.wynntils.utils.wynn.WynnUtils;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.class_1074;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_4597;
import net.neoforged.bus.api.SubscribeEvent;

@ConfigCategory(value=Category.INVENTORY)
public class ItemFavoriteFeature
extends Feature {
    @RegisterKeyBind
    private final KeyBind itemFavoriteKeyBind = new KeyBind("Favorite/Unfavorite Item", -1, true, null, this::tryChangeFavoriteStateOnHoveredSlot);
    @Persisted
    private final Config<Boolean> allowFavoritingAllItems = new Config<Boolean>(false);
    @Persisted
    public final HiddenConfig<Set<String>> favoriteItems = new HiddenConfig(new TreeSet());
    @Persisted
    private final Config<Integer> lootChestCloseOverride = new Config<Integer>(3);
    private int lootChestCloseOverrideCounter = 0;

    @SubscribeEvent
    public void onChestCloseAttempt(ContainerCloseEvent.Pre e) {
        if (!Models.WorldState.onWorld()) {
            return;
        }
        if (!(Models.Container.getCurrentContainer() instanceof RewardContainer)) {
            return;
        }
        boolean containsFavorite = false;
        class_2371<class_1799> items = ContainerUtils.getItems(McUtils.screen());
        for (int i = 0; i < 27; ++i) {
            class_1799 itemStack = (class_1799)items.get(i);
            if (!this.isFavorited(itemStack)) continue;
            containsFavorite = true;
            break;
        }
        if (!containsFavorite) {
            return;
        }
        if ((Integer)this.lootChestCloseOverride.get() == 0) {
            McUtils.sendErrorToClient(class_1074.method_4662((String)"feature.wynntils.itemFavorite.closingBlocked", (Object[])new Object[0]));
            e.setCanceled(true);
            return;
        }
        ++this.lootChestCloseOverrideCounter;
        if (this.lootChestCloseOverrideCounter >= (Integer)this.lootChestCloseOverride.get()) {
            return;
        }
        McUtils.sendErrorToClient(class_1074.method_4662((String)"feature.wynntils.itemFavorite.closingBlockedOverride", (Object[])new Object[]{(Integer)this.lootChestCloseOverride.get() - this.lootChestCloseOverrideCounter}));
        e.setCanceled(true);
    }

    @SubscribeEvent
    public void onScreenOpen(ScreenOpenedEvent.Post event) {
        this.lootChestCloseOverrideCounter = 0;
    }

    @SubscribeEvent
    public void onRenderSlot(SlotRenderEvent.CountPre event) {
        if (Models.Container.getCurrentContainer() instanceof FullscreenContainerProperty) {
            return;
        }
        class_1799 itemStack = event.getSlot().method_7677();
        if (this.isFavorited(itemStack)) {
            ItemFavoriteFeature.renderFavoriteItem(event);
        }
    }

    private boolean isFavorited(class_1799 itemStack) {
        Optional<WynnItem> wynnItemOpt = Models.Item.getWynnItem(itemStack);
        if (wynnItemOpt.isEmpty()) {
            return false;
        }
        WynnItem wynnItem = wynnItemOpt.get();
        int currentRevision = Services.Favorites.getRevision();
        Integer revision = (Integer)wynnItem.getData().get("favorite");
        if (revision != null && (revision == currentRevision || revision == -currentRevision)) {
            return revision > 0;
        }
        boolean isFavorite = Services.Favorites.calculateFavorite(itemStack, wynnItem);
        wynnItem.getData().store("favorite", isFavorite ? currentRevision : -currentRevision);
        return isFavorite;
    }

    private static void renderFavoriteItem(SlotRenderEvent.CountPre event) {
        BufferedRenderUtils.drawScalingTexturedRect(event.getPoseStack(), (class_4597)event.getGuiGraphics().field_44658, Texture.FAVORITE_ICON.resource(), event.getSlot().field_7873 + 10, event.getSlot().field_7872, 200.0f, 9.0f, 9.0f, Texture.FAVORITE_ICON.width(), Texture.FAVORITE_ICON.height());
    }

    private void tryChangeFavoriteStateOnHoveredSlot(class_1735 hoveredSlot) {
        if (hoveredSlot == null || !hoveredSlot.method_7681()) {
            return;
        }
        String itemName = null;
        Optional<NamedItemProperty> namedItemPropertyOpt = Models.Item.asWynnItemProperty(hoveredSlot.method_7677(), NamedItemProperty.class);
        if (namedItemPropertyOpt.isPresent()) {
            itemName = namedItemPropertyOpt.get().getName();
        } else if (((Boolean)this.allowFavoritingAllItems.get()).booleanValue()) {
            itemName = WynnUtils.normalizeBadString(StyledText.fromComponent(hoveredSlot.method_7677().method_7964()).getStringWithoutFormatting());
        }
        if (itemName != null && !itemName.isBlank()) {
            Services.Favorites.toggleFavorite(itemName);
        }
    }
}

