/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.overlays;

import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.consumers.features.properties.RegisterKeyBind;
import com.wynntils.core.consumers.overlays.annotations.OverlayInfo;
import com.wynntils.core.keybinds.KeyBind;
import com.wynntils.core.notifications.MessageContainer;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.core.text.StyledText;
import com.wynntils.handlers.chat.type.NpcDialogueType;
import com.wynntils.mc.event.KeyInputEvent;
import com.wynntils.mc.event.PacketEvent;
import com.wynntils.mc.event.RenderEvent;
import com.wynntils.mc.event.TickEvent;
import com.wynntils.models.npcdialogue.event.NpcDialogueProcessingEvent;
import com.wynntils.models.npcdialogue.type.NpcDialogue;
import com.wynntils.models.worlds.event.WorldStateEvent;
import com.wynntils.overlays.NpcDialogueOverlay;
import com.wynntils.utils.mc.McUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_2561;
import net.minecraft.class_2848;
import net.neoforged.bus.api.SubscribeEvent;

@ConfigCategory(value=Category.OVERLAYS)
public class NpcDialogueFeature
extends Feature {
    private static final StyledText PRESS_SHIFT_TO_CONTINUE = StyledText.fromComponent((class_2561)class_2561.method_43471((String)"feature.wynntils.npcDialogue.pressShiftToContinue"));
    @OverlayInfo(renderType=RenderEvent.ElementType.GUI)
    private final NpcDialogueOverlay npcDialogueOverlay = new NpcDialogueOverlay();
    @RegisterKeyBind
    public final KeyBind cancelAutoProgressKeybind = new KeyBind("Cancel Dialog Auto Progress", 89, false, this::cancelAutoProgress);
    @RegisterKeyBind
    public final KeyBind npcDialogKeyOverrideKeybind = new KeyBind("Progress NPC Dialogue", -1, true, this::progressNPCDialogue);
    @Persisted
    private final Config<NpcDialogueChatDisplayType> chatDisplayType = new Config<NpcDialogueChatDisplayType>(NpcDialogueChatDisplayType.NORMAL);
    @Persisted
    private final Config<Boolean> autoProgress = new Config<Boolean>(false);
    @Persisted
    public final Config<Integer> dialogAutoProgressDefaultTime = new Config<Integer>(1600);
    @Persisted
    public final Config<Integer> dialogAutoProgressAdditionalTimePerWord = new Config<Integer>(300);
    @Persisted
    public final Config<Boolean> overrideSneakKey = new Config<Boolean>(true);
    private final ScheduledExecutorService autoProgressExecutor = Executors.newSingleThreadScheduledExecutor();
    private ScheduledFuture<?> scheduledAutoProgressKeyPress = null;
    private final ScheduledExecutorService npcDialogKeyOverrideExecutor = Executors.newSingleThreadScheduledExecutor();
    private boolean isReleaseShiftScheduled;
    private List<class_2561> currentlyDisplayedDialogue = null;
    private NpcDialogue currentDialogue = null;
    private List<NpcDialogue> confirmationlessDialogues = new ArrayList<NpcDialogue>();
    private MessageContainer autoProgressContainer = null;
    private List<class_2561> lastDialogue = null;
    private MessageContainer displayedHelperContainer = null;
    private StyledText displayedHelperMessage = null;

    public NpcDialogueFeature() {
        Models.NpcDialogue.addNpcDialogExtractionDependent(this);
    }

    @SubscribeEvent
    public void onNpcDialogue(NpcDialogueProcessingEvent.Pre event) {
        NpcDialogue dialogue = event.getDialogue();
        NpcDialogueType dialogueType = dialogue.dialogueType();
        if (dialogueType == NpcDialogueType.CONFIRMATIONLESS) {
            return;
        }
        if (((Boolean)this.autoProgress.get()).booleanValue() && dialogueType == NpcDialogueType.NORMAL && !dialogue.isEmpty()) {
            this.scheduledAutoProgressKeyPress = this.scheduledSneakPress(dialogue.currentDialogue());
            this.updateAutoProgressNotification();
        }
    }

    @SubscribeEvent
    public void onNpcDialoguePost(NpcDialogueProcessingEvent.Post event) {
        NpcDialogue dialogue = event.getDialogue();
        if (!Managers.Overlay.isEnabled(this.npcDialogueOverlay) && this.chatDisplayType.get() == NpcDialogueChatDisplayType.LEGACY) {
            this.printLegacyDialogueInChat(event.getPostProcessedDialogueComponent(), dialogue.dialogueType(), dialogue.isProtected());
        }
    }

    @SubscribeEvent
    public void onDialogueSneakPress(KeyInputEvent e) {
        if (this.npcDialogKeyOverrideKeybind.getKeyMapping().method_1415()) {
            return;
        }
        if (!((Boolean)this.overrideSneakKey.get()).booleanValue()) {
            return;
        }
        if (e.getKey() != McUtils.options().field_1832.field_1655.method_1444()) {
            return;
        }
        if (Models.NpcDialogue.getCurrentDialogue().dialogueType() == NpcDialogueType.NORMAL && Models.NpcDialogue.getCurrentDialogue().isProtected()) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent event) {
        if (Managers.Overlay.isEnabled(this.npcDialogueOverlay)) {
            return;
        }
        this.updateAutoProgressNotification();
        if (this.chatDisplayType.get() == NpcDialogueChatDisplayType.NORMAL) {
            this.updateDialogueScreen();
        }
        if (this.chatDisplayType.get() == NpcDialogueChatDisplayType.LEGACY) {
            if (!Models.NpcDialogue.isInDialogue()) {
                this.lastDialogue = null;
                this.removeHelperMessage();
                this.resetAutoProgressContainer();
                return;
            }
            this.displayHelperMessage();
        }
    }

    @SubscribeEvent
    public void onPacketSent(PacketEvent.PacketSentEvent<?> e) {
        Object t = e.getPacket();
        if (!(t instanceof class_2848)) {
            return;
        }
        class_2848 packet = (class_2848)t;
        if (packet.method_12365() != class_2848.class_2849.field_12979) {
            return;
        }
        if (this.scheduledAutoProgressKeyPress != null) {
            this.scheduledAutoProgressKeyPress.cancel(true);
            this.autoProgressExecutor.schedule(() -> McUtils.sendPacket(new class_2848((class_1297)McUtils.player(), class_2848.class_2849.field_12984)), 100L, TimeUnit.MILLISECONDS);
            this.scheduledAutoProgressKeyPress = null;
        }
        if (this.isReleaseShiftScheduled) {
            this.npcDialogKeyOverrideExecutor.schedule(() -> McUtils.sendPacket(new class_2848((class_1297)McUtils.player(), class_2848.class_2849.field_12984)), 100L, TimeUnit.MILLISECONDS);
            this.isReleaseShiftScheduled = false;
        }
    }

    @SubscribeEvent
    public void onWorldStateChange(WorldStateEvent e) {
        this.cancelAutoProgress();
        this.currentlyDisplayedDialogue = null;
        this.currentDialogue = null;
        this.confirmationlessDialogues = new ArrayList<NpcDialogue>();
        this.autoProgressContainer = null;
        this.lastDialogue = null;
        this.displayedHelperMessage = null;
        this.displayedHelperContainer = null;
    }

    private void cancelAutoProgress() {
        if (this.scheduledAutoProgressKeyPress == null) {
            return;
        }
        this.scheduledAutoProgressKeyPress.cancel(true);
        this.resetAutoProgressContainer();
    }

    public ScheduledFuture<?> getScheduledAutoProgressKeyPress() {
        return this.scheduledAutoProgressKeyPress;
    }

    private void progressNPCDialogue() {
        if (Models.NpcDialogue.getCurrentDialogue().dialogueType() == NpcDialogueType.NORMAL) {
            this.isReleaseShiftScheduled = true;
            McUtils.sendPacket(new class_2848((class_1297)McUtils.player(), class_2848.class_2849.field_12979));
        }
    }

    private ScheduledFuture<?> scheduledSneakPress(List<StyledText> dialogue) {
        long delay = Models.NpcDialogue.calculateMessageReadTime(dialogue);
        return this.autoProgressExecutor.schedule(() -> McUtils.sendPacket(new class_2848((class_1297)McUtils.player(), class_2848.class_2849.field_12979)), delay, TimeUnit.MILLISECONDS);
    }

    private void printLegacyDialogueInChat(List<class_2561> dialogues, NpcDialogueType type, boolean isProtected) {
        if (!Objects.equals(dialogues, this.lastDialogue)) {
            this.lastDialogue = dialogues;
            dialogues.forEach(McUtils::sendMessageToClient);
        }
        if (type == NpcDialogueType.SELECTION) {
            this.displayedHelperMessage = StyledText.fromComponent((class_2561)class_2561.method_43471((String)"feature.wynntils.npcDialogue.selectAnOption").method_27692(class_124.field_1061));
            this.displayHelperMessage();
        } else if (type == NpcDialogueType.NORMAL) {
            this.displayedHelperMessage = this.getNormalDisplayedHelperMessage();
            this.displayHelperMessage();
        }
    }

    private StyledText getNormalDisplayedHelperMessage() {
        if (!this.npcDialogKeyOverrideKeybind.getKeyMapping().method_1415()) {
            String keyName = this.npcDialogKeyOverrideKeybind.getKeyMapping().method_16007().getString();
            if (((Boolean)this.overrideSneakKey.get()).booleanValue()) {
                return StyledText.fromComponent((class_2561)class_2561.method_43469((String)"feature.wynntils.npcDialogue.keyToProgress", (Object[])new Object[]{keyName}).method_27692(class_124.field_1060));
            }
            return StyledText.fromComponent((class_2561)class_2561.method_43469((String)"feature.wynntils.npcDialogue.shiftOrKeyToProgress", (Object[])new Object[]{keyName}).method_27692(class_124.field_1060));
        }
        return StyledText.fromComponent((class_2561)class_2561.method_43471((String)"feature.wynntils.npcDialogue.shiftToProgress").method_27692(class_124.field_1060));
    }

    private void updateDialogueScreen() {
        List<NpcDialogue> confirmationlessDialogues = Models.NpcDialogue.getConfirmationlessDialogues();
        NpcDialogue currentDialogue = Models.NpcDialogue.getCurrentDialogue();
        if (currentDialogue == null || currentDialogue.isEmpty() && confirmationlessDialogues.isEmpty()) {
            this.clearLastDialogue();
            return;
        }
        if (Objects.equals(currentDialogue, this.currentDialogue) && Objects.equals(confirmationlessDialogues, this.confirmationlessDialogues)) {
            return;
        }
        this.currentDialogue = currentDialogue;
        this.confirmationlessDialogues = confirmationlessDialogues;
        ArrayList<class_2561> screenLines = new ArrayList<class_2561>();
        for (NpcDialogue confirmationlessDialogue : confirmationlessDialogues) {
            screenLines.add((class_2561)class_2561.method_43473());
            screenLines.addAll(confirmationlessDialogue.dialogueComponent());
        }
        if (!currentDialogue.isEmpty()) {
            screenLines.add((class_2561)class_2561.method_43473());
            screenLines.addAll(currentDialogue.currentDialogue().stream().map(StyledText::getComponent).toList());
            screenLines.add((class_2561)class_2561.method_43473());
            StyledText PRESS_SHIFT_OR_KEY_TO_CONTINUE = this.getPressShiftOrKeyToContinue();
            screenLines.add((class_2561)PRESS_SHIFT_OR_KEY_TO_CONTINUE.getComponent());
            screenLines.add((class_2561)class_2561.method_43473());
        } else {
            screenLines.add((class_2561)class_2561.method_43473());
        }
        this.clearLastDialogue();
        screenLines.forEach(McUtils::sendMessageToClient);
        this.currentlyDisplayedDialogue = screenLines;
    }

    private StyledText getPressShiftOrKeyToContinue() {
        if (!this.npcDialogKeyOverrideKeybind.getKeyMapping().method_1415()) {
            String keyName = this.npcDialogKeyOverrideKeybind.getKeyMapping().method_16007().getString();
            if (((Boolean)this.overrideSneakKey.get()).booleanValue()) {
                return StyledText.fromComponent((class_2561)class_2561.method_43469((String)"feature.wynntils.npcDialogue.pressKeyToContinue", (Object[])new Object[]{keyName}));
            }
            return StyledText.fromComponent((class_2561)class_2561.method_43469((String)"feature.wynntils.npcDialogue.pressShiftOrKeyToContinue", (Object[])new Object[]{keyName}));
        }
        return PRESS_SHIFT_TO_CONTINUE;
    }

    private void updateAutoProgressNotification() {
        if (!((Boolean)this.autoProgress.get()).booleanValue()) {
            return;
        }
        if (this.getScheduledAutoProgressKeyPress() == null) {
            return;
        }
        if (this.getScheduledAutoProgressKeyPress().isCancelled()) {
            return;
        }
        long timeUntilProgress = this.getScheduledAutoProgressKeyPress().getDelay(TimeUnit.MILLISECONDS);
        StyledText autoProgressStyledText = StyledText.fromComponent((class_2561)class_2561.method_43469((String)"feature.wynntils.npcDialogue.autoProgressMessage", (Object[])new Object[]{Math.max(0, Math.round((float)timeUntilProgress / 1000.0f)), this.cancelAutoProgressKeybind.getKeyMapping().method_16007().getString()}).method_27692(class_124.field_1060));
        this.autoProgressContainer = this.autoProgressContainer != null ? Managers.Notification.editMessage(this.autoProgressContainer, autoProgressStyledText) : Managers.Notification.queueMessage(autoProgressStyledText);
    }

    private void clearLastDialogue() {
        if (this.currentlyDisplayedDialogue != null) {
            this.currentlyDisplayedDialogue.forEach(McUtils::removeMessageFromChat);
            this.currentlyDisplayedDialogue = null;
        }
        this.resetAutoProgressContainer();
    }

    private void resetAutoProgressContainer() {
        if (this.autoProgressContainer != null) {
            Managers.Notification.removeMessage(this.autoProgressContainer);
            this.autoProgressContainer = null;
        }
    }

    private void displayHelperMessage() {
        if (this.displayedHelperMessage == null) {
            return;
        }
        if (this.displayedHelperContainer == null) {
            this.displayedHelperContainer = Managers.Notification.queueMessage(this.displayedHelperMessage);
            return;
        }
        this.displayedHelperContainer = Managers.Notification.editMessage(this.displayedHelperContainer, this.displayedHelperMessage);
    }

    private void removeHelperMessage() {
        this.displayedHelperMessage = null;
        if (this.displayedHelperContainer != null) {
            Managers.Notification.removeMessage(this.displayedHelperContainer);
            this.displayedHelperContainer = null;
        }
    }

    public static enum NpcDialogueChatDisplayType {
        NORMAL,
        LEGACY;

    }
}

