/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.tooltips;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Models;
import com.wynntils.core.components.Services;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.core.text.StyledText;
import com.wynntils.mc.event.ItemTooltipRenderEvent;
import com.wynntils.models.emeralds.type.EmeraldUnits;
import com.wynntils.models.gear.type.GearInfo;
import com.wynntils.models.gear.type.GearTier;
import com.wynntils.models.items.items.game.GearBoxItem;
import com.wynntils.utils.mc.LoreUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.neoforged.bus.api.SubscribeEvent;

@ConfigCategory(value=Category.TOOLTIPS)
public class ItemGuessFeature
extends Feature {
    @Persisted
    private final Config<Boolean> showGuessesPrice = new Config<Boolean>(true);

    @SubscribeEvent
    public void onTooltipPre(ItemTooltipRenderEvent.Pre event) {
        Optional<GearBoxItem> gearBoxItemOpt = Models.Item.asWynnItem(event.getItemStack(), GearBoxItem.class);
        if (gearBoxItemOpt.isEmpty()) {
            return;
        }
        List<class_2561> tooltips = LoreUtils.appendTooltip(event.getItemStack(), event.getTooltips(), this.getTooltipAddon(gearBoxItemOpt.get()));
        event.setTooltips(tooltips);
    }

    private List<class_2561> getTooltipAddon(GearBoxItem gearBoxItem) {
        int level;
        ArrayList<class_2561> addon = new ArrayList<class_2561>();
        List<GearInfo> possibleGear = Models.Gear.getPossibleGears(gearBoxItem);
        GearTier gearTier = gearBoxItem.getGearTier();
        if (possibleGear.isEmpty()) {
            return addon;
        }
        addon.add((class_2561)class_2561.method_43470((String)"- ").method_27692(class_124.field_1060).method_10852((class_2561)class_2561.method_43471((String)"feature.wynntils.itemGuess.possibilities").method_27692(class_124.field_1080)));
        TreeMap<Integer, List> levelToItems = new TreeMap<Integer, List>();
        for (GearInfo gearInfo : possibleGear) {
            level = gearInfo != null ? gearInfo.requirements().level() : -1;
            class_5250 itemDesc = class_2561.method_43470((String)gearInfo.name()).method_27692(gearTier.getChatFormatting());
            if (Services.Favorites.isFavorite(gearInfo.name())) {
                itemDesc.method_27692(class_124.field_1073);
            }
            levelToItems.computeIfAbsent(level, i -> new ArrayList()).add(itemDesc);
        }
        for (Map.Entry entry : levelToItems.entrySet()) {
            level = (Integer)entry.getKey();
            List itemsForLevel = (List)entry.getValue();
            if (itemsForLevel.isEmpty()) {
                WynntilsMod.warn("No items for level " + level + " in gear box " + String.valueOf((Object)gearBoxItem.getGearTier()) + " " + String.valueOf(gearBoxItem.getLevelRange()) + "!");
                continue;
            }
            class_5250 guesses = class_2561.method_43470((String)"    ");
            guesses.method_10852((class_2561)class_2561.method_43470((String)"- ").method_27692(class_124.field_1060).method_10852((class_2561)class_2561.method_43469((String)"feature.wynntils.itemGuess.levelLine", (Object[])new Object[]{level == -1 ? "?" : Integer.valueOf(level)}).method_27692(class_124.field_1080)));
            if (((Boolean)this.showGuessesPrice.get()).booleanValue() && level != -1) {
                guesses.method_10852((class_2561)class_2561.method_43470((String)" [").method_10852((class_2561)class_2561.method_43470((String)(gearTier.getGearIdentificationCost(level) + " " + EmeraldUnits.EMERALD.getSymbol())).method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)"]")).method_27692(class_124.field_1080));
            }
            guesses.method_10852((class_2561)StyledText.fromString("\u00a77: ").getComponent());
            class_5250 itemsComponent = class_2561.method_43473();
            itemsComponent.method_10852((class_2561)itemsForLevel.getFirst());
            itemsForLevel.stream().skip(1L).forEach(i -> itemsComponent.method_10852((class_2561)class_2561.method_43470((String)", ").method_27692(class_124.field_1080)).method_10852((class_2561)i));
            if (itemsForLevel.isEmpty()) continue;
            guesses.method_10852((class_2561)itemsComponent);
            addon.add((class_2561)guesses);
        }
        return addon;
    }
}

