/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.tooltips;

import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.mc.event.ItemTooltipRenderEvent;
import com.wynntils.mc.event.TooltipRenderEvent;
import com.wynntils.utils.mc.ComponentUtils;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.mc.TooltipUtils;
import java.util.List;
import net.minecraft.class_1041;
import net.minecraft.class_2561;
import net.minecraft.class_4587;
import net.minecraft.class_5684;
import net.minecraft.class_8000;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import org.joml.Vector2i;
import org.joml.Vector2ic;

@ConfigCategory(value=Category.TOOLTIPS)
public class TooltipFittingFeature
extends Feature {
    @Persisted
    public final Config<Float> universalScale = new Config<Float>(Float.valueOf(1.0f));
    @Persisted
    private final Config<Boolean> fitToScreen = new Config<Boolean>(true);
    @Persisted
    private final Config<Boolean> wrapText = new Config<Boolean>(true);
    private boolean scaledLast = false;
    private float lastScaleFactor = 1.0f;

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onTooltipPre(ItemTooltipRenderEvent.Pre e) {
        class_1041 window = McUtils.mc().method_22683();
        if (((Boolean)this.wrapText.get()).booleanValue()) {
            int tooltipWidth = ComponentUtils.getOptimalTooltipWidth(e.getTooltips(), (int)((float)window.method_4486() / ((Float)this.universalScale.get()).floatValue()), (int)((float)e.getMouseX() / ((Float)this.universalScale.get()).floatValue()));
            List<class_2561> wrappedTooltips = ComponentUtils.wrapTooltips(e.getTooltips(), tooltipWidth);
            e.setTooltips(wrappedTooltips);
        }
        float scaleFactor = ((Float)this.universalScale.get()).floatValue();
        if (((Boolean)this.fitToScreen.get()).booleanValue()) {
            List<class_2561> tooltips = e.getTooltips();
            List<class_5684> clientTooltipComponents = TooltipUtils.getClientTooltipComponent(tooltips);
            int tooltipHeight = TooltipUtils.getTooltipHeight(clientTooltipComponents);
            tooltipHeight = (int)((float)tooltipHeight * ((Float)this.universalScale.get()).floatValue());
            if ((tooltipHeight += 10) > window.method_4502()) {
                scaleFactor *= (float)window.method_4502() / (float)tooltipHeight;
            }
        }
        this.lastScaleFactor = scaleFactor;
        class_4587 poseStack = e.getPoseStack();
        poseStack.method_22903();
        poseStack.method_22905(scaleFactor, scaleFactor, 1.0f);
        this.scaledLast = true;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onTooltipPost(ItemTooltipRenderEvent.Post e) {
        if (!this.scaledLast) {
            return;
        }
        e.getPoseStack().method_22909();
        this.scaledLast = false;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onTooltipRendering(TooltipRenderEvent event) {
        if (!this.scaledLast) {
            return;
        }
        event.setPositioner(new ScaledTooltipPositioner(this.lastScaleFactor));
    }

    private static final class ScaledTooltipPositioner
    implements class_8000 {
        private final float scaleFactor;

        private ScaledTooltipPositioner(float scaleFactor) {
            this.scaleFactor = scaleFactor;
        }

        public Vector2ic method_47944(int screenWidth, int screenHeight, int mouseX, int mouseY, int tooltipWidth, int tooltipHeight) {
            Vector2i vector2i = new Vector2i(mouseX, mouseY).add(12, -12);
            this.positionTooltip(screenWidth, screenHeight, vector2i, (int)((float)tooltipWidth * this.scaleFactor), (int)((float)tooltipHeight * this.scaleFactor));
            vector2i.div(this.scaleFactor);
            return vector2i;
        }

        private void positionTooltip(int screenWidth, int screenHeight, Vector2i tooltipPos, int tooltipWidth, int tooltipHeight) {
            int renderedTooltipHeight;
            if (tooltipPos.x + tooltipWidth > screenWidth) {
                tooltipPos.x = Math.max(tooltipPos.x - 24 - tooltipWidth, 4);
            }
            if (tooltipPos.y + (renderedTooltipHeight = tooltipHeight + 3) > screenHeight) {
                tooltipPos.y = screenHeight - renderedTooltipHeight;
            }
        }
    }
}

