/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.trademarket;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.models.containers.containers.trademarket.TradeMarketSellContainer;
import com.wynntils.models.trademarket.event.TradeMarketChatInputEvent;
import com.wynntils.models.trademarket.event.TradeMarketSellDialogueUpdatedEvent;
import com.wynntils.models.trademarket.type.TradeMarketState;
import com.wynntils.screens.base.widgets.WynntilsButton;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.wynn.ContainerUtils;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_476;
import net.neoforged.bus.api.SubscribeEvent;

@ConfigCategory(value=Category.TRADEMARKET)
public class TradeMarketBulkSellFeature
extends Feature {
    private static final int AMOUNT_ITEM_SLOT = 31;
    @Persisted
    private final Config<Integer> bulkSell1Amount = new Config<Integer>(64);
    @Persisted
    private final Config<Integer> bulkSell2Amount = new Config<Integer>(0);
    @Persisted
    private final Config<Integer> bulkSell3Amount = new Config<Integer>(0);
    private boolean sendAmountMessage = false;
    private int amountToSend = 0;

    @SubscribeEvent
    public void onSellDialogueUpdated(TradeMarketSellDialogueUpdatedEvent e) {
        class_437 class_4372 = McUtils.screen();
        if (!(class_4372 instanceof class_476)) {
            return;
        }
        class_476 containerScreen = (class_476)class_4372;
        if (!(Models.Container.getCurrentContainer() instanceof TradeMarketSellContainer)) {
            return;
        }
        String soldItemName = Models.TradeMarket.getSoldItemName();
        this.removeSellButtons(containerScreen);
        if (soldItemName == null) {
            return;
        }
        this.addSellButtons(containerScreen, soldItemName);
    }

    @SubscribeEvent
    public void onTradeMarketChatInput(TradeMarketChatInputEvent e) {
        if (e.getState() != TradeMarketState.AMOUNT_CHAT_INPUT) {
            return;
        }
        if (!this.sendAmountMessage) {
            return;
        }
        WynntilsMod.info("Trying to bulk sell " + this.amountToSend + " items");
        e.setResponse(String.valueOf(this.amountToSend));
        this.sendAmountMessage = false;
    }

    private void addSellButtons(class_476 containerScreen, String soldItemName) {
        containerScreen.method_37063((class_364)new SellButton(containerScreen.field_2776 - 60 - 1, containerScreen.field_2800 + 30, () -> Models.Inventory.getAmountInInventory(soldItemName), true));
        if ((Integer)this.bulkSell1Amount.get() > 0) {
            containerScreen.method_37063((class_364)new SellButton(containerScreen.field_2776 - 60 - 1, containerScreen.field_2800 + 51, this.bulkSell1Amount::get, false));
        }
        if ((Integer)this.bulkSell2Amount.get() > 0) {
            containerScreen.method_37063((class_364)new SellButton(containerScreen.field_2776 - 60 - 1, containerScreen.field_2800 + 72, this.bulkSell2Amount::get, false));
        }
        if ((Integer)this.bulkSell3Amount.get() > 0) {
            containerScreen.method_37063((class_364)new SellButton(containerScreen.field_2776 - 60 - 1, containerScreen.field_2800 + 103, this.bulkSell3Amount::get, false));
        }
    }

    private void removeSellButtons(class_476 containerScreen) {
        containerScreen.field_22786.stream().filter(child -> child instanceof SellButton).toList().forEach(arg_0 -> ((class_476)containerScreen).method_37066(arg_0));
    }

    private final class SellButton
    extends WynntilsButton {
        private static final int BUTTON_WIDTH = 60;
        private static final int BUTTON_HEIGHT = 20;
        private final Supplier<Integer> amountSupplier;

        private SellButton(int x, int y, Supplier<Integer> amountSupplier, boolean isAll) {
            super(x, y, 60, 20, (class_2561)(isAll ? class_2561.method_43471((String)"feature.wynntils.tradeMarketBulkSell.sellAll") : class_2561.method_43469((String)"feature.wynntils.tradeMarketBulkSell.sell", (Object[])new Object[]{amountSupplier.get()})));
            this.amountSupplier = amountSupplier;
        }

        public void method_25306() {
            TradeMarketBulkSellFeature.this.amountToSend = this.amountSupplier.get();
            TradeMarketBulkSellFeature.this.sendAmountMessage = true;
            ContainerUtils.clickOnSlot(31, McUtils.containerMenu().field_7763, 0, (List<class_1799>)McUtils.containerMenu().method_7602());
        }
    }
}

