/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.utilities;

import com.mojang.blaze3d.systems.RenderSystem;
import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Models;
import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.Config;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.core.text.StyledText;
import com.wynntils.mc.event.ContainerClickEvent;
import com.wynntils.mc.event.ContainerCloseEvent;
import com.wynntils.mc.event.SetSlotEvent;
import com.wynntils.mc.event.SlotRenderEvent;
import com.wynntils.mc.event.TickEvent;
import com.wynntils.models.containers.Container;
import com.wynntils.models.containers.containers.BlacksmithContainer;
import com.wynntils.models.containers.containers.ItemIdentifierAugmentsContainer;
import com.wynntils.models.containers.containers.ItemIdentifierContainer;
import com.wynntils.models.containers.containers.trademarket.TradeMarketSellContainer;
import com.wynntils.models.containers.type.BoundedContainerProperty;
import com.wynntils.models.gear.type.GearTier;
import com.wynntils.models.items.WynnItem;
import com.wynntils.models.items.items.game.TomeItem;
import com.wynntils.models.items.properties.GearTierItemProperty;
import com.wynntils.models.items.properties.IdentifiableItemProperty;
import com.wynntils.models.items.properties.LeveledItemProperty;
import com.wynntils.utils.colors.CommonColors;
import com.wynntils.utils.colors.CustomColor;
import com.wynntils.utils.mc.KeyboardUtils;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.render.FontRenderer;
import com.wynntils.utils.render.RenderUtils;
import com.wynntils.utils.render.type.HorizontalAlignment;
import com.wynntils.utils.render.type.TextShadow;
import com.wynntils.utils.render.type.VerticalAlignment;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1707;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_476;
import net.minecraft.class_6382;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;

@ConfigCategory(value=Category.UTILITIES)
public class ValuablesProtectionFeature
extends Feature {
    @Persisted
    private final Config<Float> tradeMarketPriceThreshold = new Config<Float>(Float.valueOf(90.0f));
    @Persisted
    private final Config<ProtectableNPCs> mythicWarningNPCs = new Config<ProtectableNPCs>(ProtectableNPCs.BLACKSMITH_AND_TRADE_MARKET);
    @Persisted
    private final Config<ProtectableNPCs> highRollWarningNPCs = new Config<ProtectableNPCs>(ProtectableNPCs.ALL);
    @Persisted
    private final Config<Float> highRollThreshold = new Config<Float>(Float.valueOf(80.0f));
    @Persisted
    private final Config<Boolean> tomesWarning = new Config<Boolean>(false);
    @Persisted
    private final Config<Integer> craftedBlacksmithLevel = new Config<Integer>(0);
    @Persisted
    private final Config<Boolean> requireCtrlToSell = new Config<Boolean>(false);
    private static final class_2960 CIRCLE_TEXTURE = class_2960.method_60656((String)"textures/wynn/gui/tutorial.png");
    private static final int BLACKSMITH_IDENTIFIER_CONFIRM_BUTTON_SLOT = 17;
    private static final int TM_ITEM_SLOT = 22;
    private static final int TM_PRICE_SLOT = 28;
    private static final int TM_CONFIRM_BUTTON_SLOT = 34;
    private static final StyledText WITHDRAW_STATE = StyledText.fromString("\u00a7a\u00a7lWithdraw Items");
    private Class<? extends BoundedContainerProperty> currentContainerType;
    private List<Integer> slotsToWarn = new ArrayList<Integer>();
    private HintTextWidget ctrlHintTextWidget;
    private final List<HintTextWidget> tmHintTextWidgets = new ArrayList<HintTextWidget>();
    private int emphasizeAnimationFrame = 0;
    private int emphasizeAnimationDelay = 0;
    private int emphasizeDirection = 1;

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onRenderSlot(SlotRenderEvent.Pre e) {
        Container currentContainer = Models.Container.getCurrentContainer();
        if (this.currentContainerType != null && !this.currentContainerType.isInstance(currentContainer)) {
            return;
        }
        if (!this.slotsToWarn.contains(e.getSlot().field_7874)) {
            return;
        }
        RenderSystem.enableDepthTest();
        RenderUtils.drawTexturedRectWithColor(e.getPoseStack(), CIRCLE_TEXTURE, CommonColors.RED, e.getSlot().field_7873 - 16, e.getSlot().field_7872 - 16, 200.0f, 48.0f, 48.0f, 0, this.emphasizeAnimationFrame * 48, 48, 48, 48, 192);
        RenderSystem.disableDepthTest();
    }

    @SubscribeEvent
    public void onSetSlot(SetSlotEvent.Post e) {
        class_437 class_4372 = McUtils.screen();
        if (!(class_4372 instanceof class_476)) {
            return;
        }
        class_476 cs = (class_476)class_4372;
        Container currentContainer = Models.Container.getCurrentContainer();
        if (currentContainer == null) {
            return;
        }
        boolean isIdentifier = ProtectableNPCs.IDENTIFIER.getContainers().stream().anyMatch(container -> container.equals(currentContainer.getClass()));
        if (isIdentifier && StyledText.fromComponent(((class_1707)cs.method_17577()).method_7611(17).method_7677().method_7964()).equals(WITHDRAW_STATE)) {
            this.resetAll();
            return;
        }
        this.resetAll();
        this.doBlacksmithIdentifierChecks(currentContainer, cs);
        this.doTradeMarketChecks(currentContainer, cs);
    }

    private void doBlacksmithIdentifierChecks(Container currentContainer, class_476 cs) {
        for (Class<? extends BoundedContainerProperty> container : ProtectableNPCs.BLACKSMITH_AND_IDENTIFIER.getContainers()) {
            if (!currentContainer.getClass().equals(container)) continue;
            this.currentContainerType = container;
            for (int i : ((BoundedContainerProperty)((Object)currentContainer)).getBounds().getSlots()) {
                IdentifiableItemProperty identifiableItemProperty;
                boolean shouldWarn;
                WynnItem item;
                Optional<WynnItem> itemOpt = Models.Item.getWynnItem((class_1799)((class_1707)cs.method_17577()).method_7602().get(i));
                if (itemOpt.isEmpty() || (item = itemOpt.get()) instanceof TomeItem && !((Boolean)this.tomesWarning.get()).booleanValue()) continue;
                boolean bl = shouldWarn = ((ProtectableNPCs)((Object)this.highRollWarningNPCs.get())).getContainers().contains(container) && item instanceof IdentifiableItemProperty && (identifiableItemProperty = (IdentifiableItemProperty)((Object)item)).getOverallPercentage() >= ((Float)this.highRollThreshold.get()).floatValue();
                if (item instanceof GearTierItemProperty) {
                    LeveledItemProperty lip;
                    GearTierItemProperty gtip = (GearTierItemProperty)((Object)item);
                    if (((ProtectableNPCs)((Object)this.mythicWarningNPCs.get())).getContainers().contains(container) && gtip.getGearTier() == GearTier.MYTHIC) {
                        shouldWarn = true;
                    }
                    if ((Integer)this.craftedBlacksmithLevel.get() > 0 && gtip.getGearTier() == GearTier.CRAFTED && item instanceof LeveledItemProperty && (lip = (LeveledItemProperty)((Object)item)).getLevel() >= (Integer)this.craftedBlacksmithLevel.get()) {
                        shouldWarn = true;
                    }
                }
                if (!shouldWarn) continue;
                this.slotsToWarn.add(i);
            }
        }
        if (!this.slotsToWarn.isEmpty() && ((Boolean)this.requireCtrlToSell.get()).booleanValue()) {
            this.ctrlHintTextWidget = new HintTextWidget(cs.field_22789 / 2, cs.field_2800 - 6, cs.field_22789, 11, class_1074.method_4662((String)"feature.wynntils.valuablesProtection.ctrlClick", (Object[])new Object[]{class_1074.method_4662((String)("feature.wynntils.valuablesProtection." + (ProtectableNPCs.IDENTIFIER.getContainers().contains(this.currentContainerType) ? "identifying" : "selling")), (Object[])new Object[0])}), HorizontalAlignment.CENTER, CommonColors.WHITE);
            cs.method_37060((class_4068)this.ctrlHintTextWidget);
        }
    }

    private void doTradeMarketChecks(Container currentContainer, class_476 cs) {
        if (currentContainer instanceof TradeMarketSellContainer) {
            IdentifiableItemProperty identifiableItemProperty;
            boolean warnableItem;
            Optional<WynnItem> optItem = Models.Item.getWynnItem((class_1799)((class_1707)cs.method_17577()).method_7602().get(22));
            if (optItem.isEmpty()) {
                return;
            }
            WynnItem item = optItem.get();
            boolean bl = warnableItem = ((ProtectableNPCs)((Object)this.highRollWarningNPCs.get())).getContainers().contains(TradeMarketSellContainer.class) && item instanceof IdentifiableItemProperty && (identifiableItemProperty = (IdentifiableItemProperty)((Object)item)).getOverallPercentage() >= ((Float)this.highRollThreshold.get()).floatValue();
            if (item instanceof GearTierItemProperty) {
                GearTierItemProperty gtip = (GearTierItemProperty)((Object)item);
                if (((ProtectableNPCs)((Object)this.mythicWarningNPCs.get())).getContainers().contains(TradeMarketSellContainer.class) && gtip.getGearTier() == GearTier.MYTHIC) {
                    warnableItem = true;
                }
            }
            if (!warnableItem) {
                return;
            }
            int salePrice = Models.TradeMarket.getUnitPrice();
            int lowestPrice = Models.TradeMarket.getPriceCheckInfo().ask();
            if (salePrice == -1 || lowestPrice == -1) {
                return;
            }
            this.slotsToWarn.add(28);
            if ((double)salePrice < (double)lowestPrice * ((double)((Float)this.tradeMarketPriceThreshold.get()).floatValue() / 100.0)) {
                this.ctrlHintTextWidget = new HintTextWidget(cs.field_22789 - cs.field_2776 + 2, cs.field_22790 / 2, cs.field_2776, 11, class_1074.method_4662((String)"feature.wynntils.valuablesProtection.ctrlClick", (Object[])new Object[]{class_1074.method_4662((String)"feature.wynntils.valuablesProtection.selling", (Object[])new Object[0])}), HorizontalAlignment.LEFT, CommonColors.WHITE);
                cs.method_37060((class_4068)this.ctrlHintTextWidget);
                this.tmHintTextWidgets.add(new HintTextWidget(cs.field_22789 - cs.field_2776 + 2, cs.field_22790 / 2 + 20, cs.field_2776, 11, class_1074.method_4662((String)"feature.wynntils.valuablesProtection.tmWarning", (Object[])new Object[]{salePrice + " " + String.valueOf(class_124.field_1063) + "(" + Models.Emerald.getFormattedString(salePrice, false) + ")" + String.valueOf(class_124.field_1070), this.tradeMarketPriceThreshold.get(), lowestPrice + " " + String.valueOf(class_124.field_1063) + "(" + Models.Emerald.getFormattedString(lowestPrice, false) + ")" + String.valueOf(class_124.field_1070)}), HorizontalAlignment.LEFT, CommonColors.LIGHT_GRAY));
                this.tmHintTextWidgets.add(new HintTextWidget(cs.field_22789 - cs.field_2776 + 2, cs.field_22790 / 2 + 56, cs.field_2776, 11, class_1074.method_4662((String)"feature.wynntils.valuablesProtection.settingsHint", (Object[])new Object[0]), HorizontalAlignment.LEFT, CommonColors.GRAY));
                this.tmHintTextWidgets.forEach(arg_0 -> ((class_476)cs).method_37060(arg_0));
            } else {
                this.resetAll();
            }
        }
    }

    @SubscribeEvent
    public void onSlotClicked(ContainerClickEvent e) {
        if (this.slotsToWarn.isEmpty() || KeyboardUtils.isControlDown() || !((Boolean)this.requireCtrlToSell.get()).booleanValue()) {
            return;
        }
        if (e.getSlotNum() != 17 && e.getSlotNum() != 34) {
            return;
        }
        e.setCanceled(true);
        for (int i = 0; i < 12; i += 6) {
            Managers.TickScheduler.scheduleLater(() -> {
                if (this.ctrlHintTextWidget != null) {
                    this.ctrlHintTextWidget.setTextColor(CommonColors.RED);
                }
            }, i);
            Managers.TickScheduler.scheduleLater(() -> {
                if (this.ctrlHintTextWidget != null) {
                    this.ctrlHintTextWidget.setTextColor(CommonColors.WHITE);
                }
            }, i + 3);
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent e) {
        if (!(McUtils.screen() instanceof class_476)) {
            return;
        }
        ++this.emphasizeAnimationDelay;
        if (this.emphasizeAnimationDelay % 4 == 0) {
            this.emphasizeAnimationFrame += this.emphasizeDirection;
            if (this.emphasizeAnimationFrame == 4 || this.emphasizeAnimationFrame == -1) {
                this.emphasizeDirection *= -1;
                this.emphasizeAnimationFrame = Math.max(0, Math.min(3, this.emphasizeAnimationFrame));
            }
        }
    }

    @SubscribeEvent
    public void onContainerClose(ContainerCloseEvent.Post e) {
        this.resetAll();
    }

    private void resetAll() {
        class_437 class_4372 = McUtils.screen();
        if (class_4372 instanceof class_476) {
            class_476 cs = (class_476)class_4372;
            cs.method_37066((class_364)this.ctrlHintTextWidget);
            this.tmHintTextWidgets.forEach(arg_0 -> ((class_476)cs).method_37066(arg_0));
        }
        this.ctrlHintTextWidget = null;
        this.tmHintTextWidgets.clear();
        this.slotsToWarn = new ArrayList<Integer>();
        this.currentContainerType = null;
    }

    private static enum ProtectableNPCs {
        NONE(List.of()),
        BLACKSMITH(List.of(BlacksmithContainer.class)),
        TRADE_MARKET(List.of(TradeMarketSellContainer.class)),
        IDENTIFIER(List.of(ItemIdentifierContainer.class, ItemIdentifierAugmentsContainer.class)),
        BLACKSMITH_AND_TRADE_MARKET(List.of(BlacksmithContainer.class, TradeMarketSellContainer.class)),
        BLACKSMITH_AND_IDENTIFIER(List.of(BlacksmithContainer.class, ItemIdentifierContainer.class, ItemIdentifierAugmentsContainer.class)),
        TRADE_MARKET_AND_IDENTIFIER(List.of(TradeMarketSellContainer.class, ItemIdentifierContainer.class, ItemIdentifierAugmentsContainer.class)),
        ALL(List.of(BlacksmithContainer.class, TradeMarketSellContainer.class, ItemIdentifierContainer.class, ItemIdentifierAugmentsContainer.class));

        private final List<Class<? extends BoundedContainerProperty>> containers;

        private ProtectableNPCs(List<Class<? extends BoundedContainerProperty>> containers) {
            this.containers = containers;
        }

        public List<Class<? extends BoundedContainerProperty>> getContainers() {
            return this.containers;
        }
    }

    private static final class HintTextWidget
    extends class_339 {
        private final String text;
        private final HorizontalAlignment horizontalAlignment;
        private CustomColor textColor;

        private HintTextWidget(int x, int y, int width, int height, String text, HorizontalAlignment horizontalAlignment, CustomColor defaultColor) {
            super(x, y, width, height, (class_2561)class_2561.method_43470((String)text));
            this.text = text;
            this.horizontalAlignment = horizontalAlignment;
            this.textColor = defaultColor;
        }

        protected void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
            FontRenderer.getInstance().renderText(guiGraphics.method_51448(), StyledText.fromString(this.text), (float)this.method_46426(), (float)this.method_46427(), (float)this.method_25368(), this.textColor, this.horizontalAlignment, VerticalAlignment.BOTTOM, TextShadow.NORMAL, class_327.class_6415.field_33993);
        }

        protected void method_47399(class_6382 narrationElementOutput) {
        }

        protected void setTextColor(CustomColor textColor) {
            this.textColor = textColor;
        }
    }
}

