/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.features.wynntils;

import com.wynntils.core.consumers.features.Feature;
import com.wynntils.core.crowdsource.type.CrowdSourcedDataType;
import com.wynntils.core.persisted.Persisted;
import com.wynntils.core.persisted.config.Category;
import com.wynntils.core.persisted.config.ConfigCategory;
import com.wynntils.core.persisted.config.HiddenConfig;
import com.wynntils.models.worlds.event.WorldStateEvent;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.type.ConfirmedBoolean;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import net.neoforged.bus.api.SubscribeEvent;

@ConfigCategory(value=Category.WYNNTILS)
public class DataCrowdSourcingFeature
extends Feature {
    @Persisted
    public final HiddenConfig<Map<CrowdSourcedDataType, ConfirmedBoolean>> crowdSourcedDataTypeEnabledMap = new HiddenConfig(new TreeMap());

    @SubscribeEvent
    public void onWorldChange(WorldStateEvent event) {
        if (!event.isFirstJoinWorld()) {
            return;
        }
        Map enabledMap = (Map)this.crowdSourcedDataTypeEnabledMap.get();
        List<CrowdSourcedDataType> nonConfirmedDataTypes = Arrays.stream(CrowdSourcedDataType.values()).filter(dataType -> !enabledMap.containsKey(dataType)).toList();
        if (nonConfirmedDataTypes.isEmpty()) {
            return;
        }
        class_5250 component = class_2561.method_43470((String)"Wynntils Crowd Sourcing\n").method_27692(class_124.field_1075);
        component.method_10852((class_2561)class_2561.method_43470((String)"Wynntils can collect data during your\ngameplay to improve the mod.\nThis data does not contain any personal information,\nand is only stored locally on your computer.\nTo share this data with the Wynntils team,\nyou must copy it to the clipboard and send it to us,\nduring periods when we are collecting data.\n").method_27692(class_124.field_1080));
        component.method_10852((class_2561)class_2561.method_43470((String)"\nThe following data types are not confirmed to be collected:\n"));
        for (CrowdSourcedDataType dataType2 : nonConfirmedDataTypes) {
            component.method_10852((class_2561)class_2561.method_43470((String)" - ").method_27692(class_124.field_1080));
            component.method_10852((class_2561)class_2561.method_43470((String)dataType2.getTranslatedName()).method_27692(class_124.field_1054));
            component.method_10852((class_2561)class_2561.method_43470((String)"\n"));
        }
        component.method_10852((class_2561)class_2561.method_43470((String)"\nYou can confirm or deny the collection of each data type in the Wynntils Crowd Sourcing Screen, which you can access from the Wynntils Menu or by clicking ")).method_10852((class_2561)class_2561.method_43470((String)"here.").method_27692(class_124.field_1060).method_27692(class_124.field_1073).method_27696(class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_11750, "/wynntils crowdsourcing"))));
        McUtils.sendMessageToClient((class_2561)component);
    }
}

