/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.functions;

import com.wynntils.core.components.Models;
import com.wynntils.core.components.Services;
import com.wynntils.core.consumers.functions.Function;
import com.wynntils.core.consumers.functions.arguments.Argument;
import com.wynntils.core.consumers.functions.arguments.FunctionArguments;
import com.wynntils.models.bonustotems.BonusTotem;
import com.wynntils.models.bonustotems.type.BonusTotemType;
import com.wynntils.models.territories.profile.TerritoryProfile;
import com.wynntils.models.token.type.TokenGatekeeper;
import com.wynntils.models.worlds.profile.ServerProfile;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.mc.type.Location;
import com.wynntils.utils.type.CappedValue;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_2374;

public class WorldFunctions {

    public static class InMappedAreaFunction
    extends Function<Boolean> {
        @Override
        public Boolean getValue(FunctionArguments arguments) {
            float width = arguments.getArgument("width").getDoubleValue().floatValue();
            float height = arguments.getArgument("height").getDoubleValue().floatValue();
            float scale = arguments.getArgument("scale").getDoubleValue().floatValue();
            return Services.Map.isPlayerInMappedArea(width, height, scale);
        }

        @Override
        public FunctionArguments.Builder getArgumentsBuilder() {
            return new FunctionArguments.OptionalArgumentBuilder(List.of(new Argument<Integer>("width", Number.class, 130), new Argument<Integer>("height", Number.class, 130), new Argument<Integer>("scale", Number.class, 1)));
        }
    }

    public static class CurrentTerritoryOwnerFunction
    extends Function<String> {
        @Override
        public String getValue(FunctionArguments arguments) {
            TerritoryProfile territoryProfile = Models.Territory.getTerritoryProfileForPosition((class_2374)McUtils.player().method_19538());
            if (territoryProfile == null) {
                return "";
            }
            return arguments.getArgument("prefixOnly").getBooleanValue() != false ? territoryProfile.getGuildPrefix() : territoryProfile.getGuild();
        }

        @Override
        protected List<String> getAliases() {
            return List.of("territory_owner");
        }

        @Override
        public FunctionArguments.Builder getArgumentsBuilder() {
            return new FunctionArguments.OptionalArgumentBuilder(List.of(new Argument<Boolean>("prefixOnly", Boolean.class, false)));
        }
    }

    public static class CurrentTerritoryFunction
    extends Function<String> {
        @Override
        public String getValue(FunctionArguments arguments) {
            TerritoryProfile territoryProfile = Models.Territory.getTerritoryProfileForPosition((class_2374)McUtils.player().method_19538());
            if (territoryProfile == null) {
                return "";
            }
            return territoryProfile.getName();
        }

        @Override
        protected List<String> getAliases() {
            return List.of("territory");
        }
    }

    public static class PingFunction
    extends Function<Integer> {
        @Override
        public Integer getValue(FunctionArguments arguments) {
            return Services.Ping.getPing();
        }
    }

    public static class MobTotemTimeLeftFunction
    extends Function<String> {
        @Override
        public String getValue(FunctionArguments arguments) {
            BonusTotem bonusTotem = Models.BonusTotem.getBonusTotem(BonusTotemType.MOB, arguments.getArgument("totemNumber").getIntegerValue() - 1);
            if (bonusTotem == null) {
                return "";
            }
            return bonusTotem.getTimerString();
        }

        @Override
        public FunctionArguments.Builder getArgumentsBuilder() {
            return new FunctionArguments.RequiredArgumentBuilder(List.of(new Argument<Object>("totemNumber", Integer.class, null)));
        }
    }

    public static class MobTotemFunction
    extends Function<Location> {
        @Override
        public Location getValue(FunctionArguments arguments) {
            BonusTotem bonusTotem = Models.BonusTotem.getBonusTotem(BonusTotemType.MOB, arguments.getArgument("totemNumber").getIntegerValue() - 1);
            if (bonusTotem == null) {
                return new Location(0, 0, 0);
            }
            return Location.containing(bonusTotem.getPosition());
        }

        @Override
        public FunctionArguments.Builder getArgumentsBuilder() {
            return new FunctionArguments.RequiredArgumentBuilder(List.of(new Argument<Object>("totemNumber", Integer.class, null)));
        }
    }

    public static class MobTotemDistanceFunction
    extends Function<Double> {
        @Override
        public Double getValue(FunctionArguments arguments) {
            BonusTotem bonusTotem = Models.BonusTotem.getBonusTotem(BonusTotemType.MOB, arguments.getArgument("totemNumber").getIntegerValue() - 1);
            if (bonusTotem == null) {
                return 0.0;
            }
            return bonusTotem.getDistanceToPlayer();
        }

        @Override
        public FunctionArguments.Builder getArgumentsBuilder() {
            return new FunctionArguments.RequiredArgumentBuilder(List.of(new Argument<Object>("totemNumber", Integer.class, null)));
        }
    }

    public static class MobTotemOwnerFunction
    extends Function<String> {
        @Override
        public String getValue(FunctionArguments arguments) {
            BonusTotem bonusTotem = Models.BonusTotem.getBonusTotem(BonusTotemType.MOB, arguments.getArgument("totemNumber").getIntegerValue() - 1);
            if (bonusTotem == null) {
                return "";
            }
            return bonusTotem.getOwner();
        }

        @Override
        public FunctionArguments.Builder getArgumentsBuilder() {
            return new FunctionArguments.RequiredArgumentBuilder(List.of(new Argument<Object>("totemNumber", Integer.class, null)));
        }
    }

    public static class MobTotemCountFunction
    extends Function<Integer> {
        @Override
        public Integer getValue(FunctionArguments arguments) {
            return Models.BonusTotem.getBonusTotemsByType(BonusTotemType.MOB).size();
        }
    }

    public static class TokenGatekeeperTypeFunction
    extends Function<String> {
        @Override
        public String getValue(FunctionArguments arguments) {
            List<TokenGatekeeper> gatekeeperList;
            int index = arguments.getArgument("gatekeeperNumber").getIntegerValue() - 1;
            if (index >= (gatekeeperList = Models.Token.getGatekeepers()).size() || index < 0) {
                return "";
            }
            return gatekeeperList.get(index).getGatekeeperTokenName().getString();
        }

        @Override
        public FunctionArguments.Builder getArgumentsBuilder() {
            return new FunctionArguments.OptionalArgumentBuilder(List.of(new Argument<Integer>("gatekeeperNumber", Integer.class, 0)));
        }

        @Override
        protected List<String> getAliases() {
            return List.of("token_type");
        }
    }

    public static class TokenGatekeeperFunction
    extends Function<CappedValue> {
        @Override
        public CappedValue getValue(FunctionArguments arguments) {
            List<TokenGatekeeper> gatekeeperList;
            int index = arguments.getArgument("gatekeeperNumber").getIntegerValue() - 1;
            if (index >= (gatekeeperList = Models.Token.getGatekeepers()).size() || index < 0) {
                return CappedValue.EMPTY;
            }
            return Models.Token.getCollected(gatekeeperList.get(index));
        }

        @Override
        public FunctionArguments.Builder getArgumentsBuilder() {
            return new FunctionArguments.OptionalArgumentBuilder(List.of(new Argument<Integer>("gatekeeperNumber", Integer.class, 0)));
        }

        @Override
        protected List<String> getAliases() {
            return List.of("token");
        }
    }

    public static class TokenGatekeeperDepositedFunction
    extends Function<CappedValue> {
        @Override
        public CappedValue getValue(FunctionArguments arguments) {
            List<TokenGatekeeper> gatekeeperList;
            int index = arguments.getArgument("gatekeeperNumber").getIntegerValue() - 1;
            if (index >= (gatekeeperList = Models.Token.getGatekeepers()).size() || index < 0) {
                return CappedValue.EMPTY;
            }
            return gatekeeperList.get(index).getDeposited();
        }

        @Override
        public FunctionArguments.Builder getArgumentsBuilder() {
            return new FunctionArguments.OptionalArgumentBuilder(List.of(new Argument<Integer>("gatekeeperNumber", Integer.class, 0)));
        }

        @Override
        protected List<String> getAliases() {
            return List.of("token_dep");
        }
    }

    public static class TokenGatekeeperCountFunction
    extends Function<Integer> {
        @Override
        public Integer getValue(FunctionArguments arguments) {
            return Models.Token.getGatekeepers().size();
        }

        @Override
        protected List<String> getAliases() {
            return List.of("token_count");
        }
    }

    public static class GatheringTotemTimeLeftFunction
    extends Function<String> {
        @Override
        public String getValue(FunctionArguments arguments) {
            BonusTotem bonusTotem = Models.BonusTotem.getBonusTotem(BonusTotemType.GATHERING, arguments.getArgument("totemNumber").getIntegerValue() - 1);
            if (bonusTotem == null) {
                return "";
            }
            return bonusTotem.getTimerString();
        }

        @Override
        public FunctionArguments.Builder getArgumentsBuilder() {
            return new FunctionArguments.RequiredArgumentBuilder(List.of(new Argument<Object>("totemNumber", Integer.class, null)));
        }
    }

    public static class GatheringTotemFunction
    extends Function<Location> {
        @Override
        public Location getValue(FunctionArguments arguments) {
            BonusTotem bonusTotem = Models.BonusTotem.getBonusTotem(BonusTotemType.GATHERING, arguments.getArgument("totemNumber").getIntegerValue() - 1);
            if (bonusTotem == null) {
                return new Location(0, 0, 0);
            }
            return Location.containing(bonusTotem.getPosition());
        }

        @Override
        public FunctionArguments.Builder getArgumentsBuilder() {
            return new FunctionArguments.RequiredArgumentBuilder(List.of(new Argument<Object>("totemNumber", Integer.class, null)));
        }
    }

    public static class GatheringTotemDistanceFunction
    extends Function<Double> {
        @Override
        public Double getValue(FunctionArguments arguments) {
            BonusTotem bonusTotem = Models.BonusTotem.getBonusTotem(BonusTotemType.GATHERING, arguments.getArgument("totemNumber").getIntegerValue() - 1);
            if (bonusTotem == null) {
                return 0.0;
            }
            return bonusTotem.getDistanceToPlayer();
        }

        @Override
        public FunctionArguments.Builder getArgumentsBuilder() {
            return new FunctionArguments.RequiredArgumentBuilder(List.of(new Argument<Object>("totemNumber", Integer.class, null)));
        }
    }

    public static class GatheringTotemOwnerFunction
    extends Function<String> {
        @Override
        public String getValue(FunctionArguments arguments) {
            BonusTotem bonusTotem = Models.BonusTotem.getBonusTotem(BonusTotemType.GATHERING, arguments.getArgument("totemNumber").getIntegerValue() - 1);
            if (bonusTotem == null) {
                return "";
            }
            return bonusTotem.getOwner();
        }

        @Override
        public FunctionArguments.Builder getArgumentsBuilder() {
            return new FunctionArguments.RequiredArgumentBuilder(List.of(new Argument<Object>("totemNumber", Integer.class, null)));
        }
    }

    public static class GatheringTotemCountFunction
    extends Function<Integer> {
        @Override
        public Integer getValue(FunctionArguments arguments) {
            return Models.BonusTotem.getBonusTotemsByType(BonusTotemType.GATHERING).size();
        }
    }

    public static class InStreamFunction
    extends Function<Boolean> {
        @Override
        public Boolean getValue(FunctionArguments arguments) {
            return Models.WorldState.isInStream();
        }

        @Override
        protected List<String> getAliases() {
            return List.of("streamer");
        }
    }

    public static class WorldStateFunction
    extends Function<String> {
        @Override
        public String getValue(FunctionArguments arguments) {
            return Models.WorldState.getCurrentState().toString().toUpperCase(Locale.ROOT);
        }
    }

    public static class NewestWorldFunction
    extends Function<String> {
        private static final String NO_DATA = "<unknown>";

        @Override
        public String getValue(FunctionArguments arguments) {
            String server = Models.ServerList.getNewestServer();
            if (server == null) {
                return NO_DATA;
            }
            return server;
        }
    }

    public static class WorldUptimeFunction
    extends Function<String> {
        private static final String NO_DATA = "<unknown>";
        private static final String NO_WORLD = "<not on world>";

        @Override
        public String getValue(FunctionArguments arguments) {
            ServerProfile server;
            String worldName = arguments.getArgument("worldName").getStringValue();
            if (worldName.isEmpty()) {
                if (!Models.WorldState.onWorld()) {
                    return NO_WORLD;
                }
                worldName = Models.WorldState.getCurrentWorldName();
            }
            if ((server = Models.ServerList.getServer(worldName)) == null) {
                return NO_DATA;
            }
            return server.getUptime();
        }

        @Override
        public FunctionArguments.Builder getArgumentsBuilder() {
            return new FunctionArguments.OptionalArgumentBuilder(List.of(new Argument<String>("worldName", String.class, "")));
        }

        @Override
        protected List<String> getAliases() {
            return List.of("uptime", "current_world_uptime");
        }
    }

    public static class CurrentWorldFunction
    extends Function<String> {
        private static final String NO_DATA = "<unknown>";
        private static final String NO_WORLD = "<not on world>";

        @Override
        public String getValue(FunctionArguments arguments) {
            if (!Models.WorldState.onWorld()) {
                return NO_WORLD;
            }
            String currentWorldName = Models.WorldState.getCurrentWorldName();
            return currentWorldName.isEmpty() ? NO_DATA : currentWorldName;
        }

        @Override
        protected List<String> getAliases() {
            return List.of("world");
        }
    }
}

