/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.hades.protocol.builders;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.wynntils.hades.objects.HadesConnection;
import com.wynntils.hades.protocol.enums.PacketDirection;
import com.wynntils.hades.protocol.interfaces.HadesHandlerFactory;
import com.wynntils.hades.protocol.io.HadesCompressionDecoder;
import com.wynntils.hades.protocol.io.HadesCompressionEncoder;
import com.wynntils.hades.protocol.io.HadesIntPrepender;
import com.wynntils.hades.protocol.io.HadesIntSplitter;
import com.wynntils.hades.protocol.io.HadesPacketDecoder;
import com.wynntils.hades.protocol.io.HadesPacketEncoder;
import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.net.Inet6Address;
import java.net.InetAddress;

public class HadesNetworkBuilder {
    PacketDirection direction;
    InetAddress address;
    int serverPort = 0;
    int compressionThreshold = 0;
    HadesHandlerFactory handlerFactory;

    public HadesNetworkBuilder setDirection(PacketDirection direction) {
        this.direction = direction;
        return this;
    }

    public HadesNetworkBuilder setAddress(InetAddress address, int serverPort) {
        this.address = address;
        this.serverPort = serverPort;
        return this;
    }

    public HadesNetworkBuilder setCompressionThreshold(int compressionThreshold) {
        this.compressionThreshold = compressionThreshold;
        return this;
    }

    public HadesNetworkBuilder setHandlerFactory(HadesHandlerFactory handlerFactory) {
        this.handlerFactory = handlerFactory;
        return this;
    }

    private EventLoopGroup getEventLoopGroup() {
        return Epoll.isAvailable() ? new EpollEventLoopGroup(0, new ThreadFactoryBuilder().setNameFormat("Hades Epoll IO #%d").setDaemon(true).build()) : new NioEventLoopGroup(0, new ThreadFactoryBuilder().setNameFormat("Hades IO #%d").setDaemon(true).build());
    }

    private Class<? extends SocketChannel> getClientChannel() {
        return Epoll.isAvailable() ? EpollSocketChannel.class : NioSocketChannel.class;
    }

    private Class<? extends ServerSocketChannel> getServerChannel() {
        return Epoll.isAvailable() ? EpollServerSocketChannel.class : NioServerSocketChannel.class;
    }

    private void setupChannel(Channel ch, HadesConnection manager) {
        ch.config().setOption(ChannelOption.TCP_NODELAY, (Object)true);
        ch.config().setOption(ChannelOption.SO_KEEPALIVE, (Object)true);
        ch.pipeline().addLast("splitter", (ChannelHandler)new HadesIntSplitter());
        ch.pipeline().addLast("decoder", (ChannelHandler)new HadesPacketDecoder(this.direction.getDecodeRegistry()));
        ch.pipeline().addLast("prepender", (ChannelHandler)new HadesIntPrepender());
        ch.pipeline().addLast("encoder", (ChannelHandler)new HadesPacketEncoder(this.direction.getEncodeRegistry()));
        ch.pipeline().addLast("handler", (ChannelHandler)manager);
        if (this.compressionThreshold != 0) {
            ch.pipeline().addBefore("decoder", "decompress", (ChannelHandler)new HadesCompressionDecoder(this.compressionThreshold));
            ch.pipeline().addBefore("encoder", "compress", (ChannelHandler)new HadesCompressionEncoder(this.compressionThreshold));
        }
    }

    public HadesConnection buildClient() {
        assert (this.direction != null && this.direction == PacketDirection.SERVER);
        if (this.address instanceof Inet6Address) {
            System.setProperty("java.net.preferIPv4Stack", "false");
        }
        final HadesConnection manager = new HadesConnection(this.direction, this.handlerFactory);
        ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(this.getEventLoopGroup())).handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) {
                HadesNetworkBuilder.this.setupChannel(ch, manager);
            }
        })).channel(this.getClientChannel())).connect(this.address, this.serverPort).syncUninterruptibly();
        return manager;
    }

    public void buildServer() {
        assert (this.address != null && this.serverPort != 0 && this.direction == PacketDirection.CLIENT);
        ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(this.getEventLoopGroup()).channel(this.getServerChannel())).childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) {
                HadesConnection manager = new HadesConnection(PacketDirection.CLIENT, HadesNetworkBuilder.this.handlerFactory);
                HadesNetworkBuilder.this.setupChannel(ch, manager);
            }
        }).localAddress(this.address, this.serverPort)).bind().syncUninterruptibly();
    }
}

