/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.hades.protocol.packets.client;

import com.wynntils.hades.protocol.enums.HadesVersion;
import com.wynntils.hades.protocol.interfaces.HadesPacket;
import com.wynntils.hades.protocol.interfaces.adapters.IHadesServerAdapter;
import com.wynntils.hades.utils.HadesBuffer;

public class HCPacketAuthenticate
implements HadesPacket<IHadesServerAdapter> {
    String token;
    HadesVersion version;

    public HCPacketAuthenticate() {
    }

    public HCPacketAuthenticate(String token) {
        this.token = token;
    }

    public HCPacketAuthenticate(String token, HadesVersion version) {
        this.token = token;
        this.version = version;
    }

    public String getToken() {
        return this.token;
    }

    public HadesVersion getVersion() {
        return this.version;
    }

    @Override
    public void readData(HadesBuffer buffer) {
        this.token = buffer.readString();
        this.version = buffer.readableBytes() > 0 ? buffer.readEnum(HadesVersion.class) : HadesVersion.UNKNOWN;
    }

    @Override
    public void writeData(HadesBuffer buffer) {
        buffer.writeString(this.token);
        buffer.writeEnum(this.version);
    }

    @Override
    public void process(IHadesServerAdapter handler) {
        handler.handleAuthentication(this);
    }
}

