/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.handlers.tooltip.impl.identifiable.components;

import com.wynntils.core.components.Models;
import com.wynntils.handlers.tooltip.impl.identifiable.IdentifiableTooltipComponent;
import com.wynntils.models.gear.type.GearRestrictions;
import com.wynntils.models.gear.type.GearTier;
import com.wynntils.models.rewards.type.TomeInfo;
import com.wynntils.models.rewards.type.TomeInstance;
import com.wynntils.models.rewards.type.TomeRequirements;
import com.wynntils.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class TomeTooltipComponent
extends IdentifiableTooltipComponent<TomeInfo, TomeInstance> {
    @Override
    public List<class_2561> buildHeaderTooltip(TomeInfo tomeInfo, TomeInstance tomeInstance, boolean hideUnidentified) {
        ArrayList<class_2561> header = new ArrayList<class_2561>();
        String prefix = tomeInstance == null && !hideUnidentified ? "Unidentified " : "";
        header.add((class_2561)class_2561.method_43470((String)(prefix + tomeInfo.name())).method_27692(tomeInfo.tier().getChatFormatting()));
        header.add((class_2561)class_2561.method_43473());
        TomeRequirements requirements = tomeInfo.requirements();
        int level = requirements.level();
        if (level != 0) {
            boolean fulfilled = Models.CombatXp.getCombatLevel().current() >= level;
            header.add((class_2561)this.buildRequirementLine("Combat Lv. Min: " + level, fulfilled));
            header.add((class_2561)class_2561.method_43473());
        }
        return header;
    }

    @Override
    public List<class_2561> buildFooterTooltip(TomeInfo tomeInfo, TomeInstance tomeInstance, boolean showItemType) {
        ArrayList<class_2561> footer = new ArrayList<class_2561>();
        footer.add((class_2561)class_2561.method_43473());
        GearTier gearTier = tomeInfo.tier();
        class_5250 itemTypeName = showItemType ? class_2561.method_43470((String)"Tome") : class_2561.method_43470((String)"Raid Reward");
        class_5250 tier = class_2561.method_43470((String)gearTier.getName()).method_27692(gearTier.getChatFormatting()).method_27693(" ").method_10852((class_2561)itemTypeName);
        if (tomeInstance != null && tomeInstance.rerolls() > 1) {
            tier.method_27693(" [" + tomeInstance.rerolls() + "]");
        }
        footer.add((class_2561)tier);
        if (tomeInfo.metaInfo().restrictions() != GearRestrictions.NONE) {
            footer.add((class_2561)class_2561.method_43470((String)StringUtils.capitalizeFirst(tomeInfo.metaInfo().restrictions().getDescription())).method_27692(class_124.field_1061));
        }
        return footer;
    }
}

