/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.abilities;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Model;
import com.wynntils.core.components.Models;
import com.wynntils.core.text.StyledText;
import com.wynntils.handlers.labels.event.TextDisplayChangedEvent;
import com.wynntils.mc.event.AddEntityEvent;
import com.wynntils.mc.event.ChangeCarriedItemEvent;
import com.wynntils.mc.event.RemoveEntitiesEvent;
import com.wynntils.models.abilities.event.TotemEvent;
import com.wynntils.models.abilities.type.ShamanTotem;
import com.wynntils.models.character.event.CharacterUpdateEvent;
import com.wynntils.models.character.type.ClassType;
import com.wynntils.models.spells.event.SpellEvent;
import com.wynntils.models.spells.type.SpellType;
import com.wynntils.utils.mc.McUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1297;
import net.minecraft.class_1531;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_746;
import net.minecraft.class_8113;
import net.neoforged.bus.api.SubscribeEvent;

public final class ShamanTotemModel
extends Model {
    private static final Pattern SHAMAN_TOTEM_TIMER = Pattern.compile("\u00a7b(?<username>.+)'(?:s)? \u00a77Totem\n(\u00a7c\\+(?<regen>\\d+)\u2764\u00a77/s )?(\u00a7e\ue013 \u00a77(\\d+)s )?\u00a7d\ue01f \u00a77(?<time>\\d+)s");
    private static final int MAX_TOTEM_COUNT = 4;
    private static final double TOTEM_SEARCH_RADIUS = 1.0;
    private static final int TOTEM_DATA_DELAY_TICKS = 2;
    private static final int CAST_MAX_DELAY_MS = 240;
    private final ShamanTotem[] totems = new ShamanTotem[4];
    private final Integer[] timerlessTotemVisibleIds = new Integer[4];
    private final Map<Integer, Integer> orphanedTimers = new HashMap<Integer, Integer>();
    private int nextTotemSlot = 1;
    private long totemCastTimestamp = 0L;

    public ShamanTotemModel() {
        super(List.of());
    }

    @SubscribeEvent
    public void onTotemSpellCast(SpellEvent.Cast e) {
        if (e.getSpellType() != SpellType.TOTEM) {
            return;
        }
        this.totemCastTimestamp = System.currentTimeMillis();
    }

    @SubscribeEvent
    public void onTotemSpawn(AddEntityEvent e) {
        if (!Models.WorldState.onWorld()) {
            return;
        }
        if (Models.Character.getClassType() != ClassType.SHAMAN) {
            return;
        }
        class_1297 entity = this.getBufferedEntity(e.getId());
        if (!(entity instanceof class_1531)) {
            return;
        }
        class_1531 totemAS = (class_1531)entity;
        if (!this.isClose((class_2374)totemAS.method_19538(), (class_2374)McUtils.mc().field_1724.method_19538())) {
            return;
        }
        Managers.TickScheduler.scheduleLater(() -> {
            ShamanTotem newTotem;
            if (System.currentTimeMillis() - this.totemCastTimestamp > 240L && !Models.Inventory.hasAutoCasterItem()) {
                return;
            }
            ArrayList inv = new ArrayList();
            totemAS.method_5661().forEach(inv::add);
            if (inv.size() < 4) {
                return;
            }
            class_1799 data = (class_1799)inv.get(3);
            if (data.method_7909() != class_1802.field_8776) {
                return;
            }
            if (data.method_7919() != 28 && data.method_7919() != 29) {
                return;
            }
            int totemNumber = this.getNextTotemSlot();
            WynntilsMod.postEvent(new TotemEvent.Summoned(totemNumber, totemAS));
            this.totems[totemNumber - 1] = newTotem = new ShamanTotem(totemNumber, -1, totemAS.method_5628(), -1, ShamanTotem.TotemState.SUMMONED, (class_2374)totemAS.method_19538());
            this.timerlessTotemVisibleIds[totemNumber - 1] = totemAS.method_5628();
        }, 2);
    }

    @SubscribeEvent
    public void onTimerRename(TextDisplayChangedEvent.Text event) {
        if (!Models.WorldState.onWorld()) {
            return;
        }
        if (Models.Character.getClassType() != ClassType.SHAMAN) {
            return;
        }
        class_8113.class_8123 textDisplay = event.getTextDisplay();
        StyledText name = event.getText();
        if (name.isEmpty()) {
            return;
        }
        Matcher m = name.getMatcher(SHAMAN_TOTEM_TIMER);
        if (!m.matches()) {
            return;
        }
        if (!m.group("username").equals(McUtils.playerName())) {
            return;
        }
        int parsedTime = Integer.parseInt(m.group("time"));
        int timerId = textDisplay.method_5628();
        if (this.getBoundTotem(timerId) == null) {
            this.findAndLinkTotem(timerId, parsedTime, textDisplay);
        } else {
            this.updateTotem(timerId, parsedTime, textDisplay);
        }
    }

    private void findAndLinkTotem(int timerId, int parsedTime, class_8113.class_8123 textDisplay) {
        List possibleTotems = McUtils.mc().field_1687.method_18467(class_1531.class, new class_238(textDisplay.method_19538().field_1352 - 1.0, textDisplay.method_19538().field_1351 - 1.0, textDisplay.method_19538().field_1350 - 1.0, textDisplay.method_19538().field_1352 + 1.0, textDisplay.method_19538().field_1351 + 5.0, textDisplay.method_19538().field_1350 + 1.0));
        for (class_1531 possibleTotem : possibleTotems) {
            for (int i = 0; i < this.timerlessTotemVisibleIds.length; ++i) {
                if (this.timerlessTotemVisibleIds[i] == null || possibleTotem.method_5628() != this.timerlessTotemVisibleIds[i].intValue()) continue;
                ShamanTotem totem = this.totems[i];
                totem.setTimerEntityId(timerId);
                totem.setTime(parsedTime);
                totem.setPosition((class_2374)possibleTotem.method_19538());
                totem.setState(ShamanTotem.TotemState.ACTIVE);
                WynntilsMod.postEvent(new TotemEvent.Activated(totem.getTotemNumber(), (class_2374)possibleTotem.method_19538()));
                this.timerlessTotemVisibleIds[i] = null;
                if (this.orphanedTimers.containsKey(timerId) && this.orphanedTimers.get(timerId) > 1) {
                    WynntilsMod.info("Matched an orphaned totem timer " + timerId + " to a totem " + totem.getTotemNumber() + " after " + String.valueOf(this.orphanedTimers.get(timerId)) + " attempts.");
                    this.orphanedTimers.remove(timerId);
                }
                return;
            }
        }
        this.orphanedTimers.merge(timerId, 1, Integer::sum);
        if (this.orphanedTimers.get(timerId) == 2) {
            WynntilsMod.warn("Matched an unbound totem timer " + timerId + " but couldn't find a totem to bind it to.");
        }
    }

    private void updateTotem(int timerId, int parsedTime, class_8113.class_8123 textDisplay) {
        ShamanTotem boundTotem = this.getBoundTotem(timerId);
        if (boundTotem == null) {
            return;
        }
        for (ShamanTotem totem : this.totems) {
            if (boundTotem != totem) continue;
            totem.setTime(parsedTime);
            totem.setPosition((class_2374)textDisplay.method_19538());
            WynntilsMod.postEvent(new TotemEvent.Updated(totem.getTotemNumber(), parsedTime, (class_2374)textDisplay.method_19538()));
            break;
        }
    }

    @SubscribeEvent
    public void onTotemDestroy(RemoveEntitiesEvent e) {
        if (!Models.WorldState.onWorld()) {
            return;
        }
        List<Integer> destroyedEntities = e.getEntityIds();
        for (ShamanTotem totem : this.totems) {
            if (totem == null || !destroyedEntities.contains(totem.getTimerEntityId()) && !destroyedEntities.contains(totem.getVisibleEntityId())) continue;
            this.removeTotem(totem.getTotemNumber());
        }
    }

    @SubscribeEvent
    public void onClassChange(CharacterUpdateEvent e) {
        this.removeAllTotems();
    }

    @SubscribeEvent
    public void onHeldItemChange(ChangeCarriedItemEvent e) {
        this.removeAllTotems();
    }

    private class_1297 getBufferedEntity(int entityId) {
        class_1297 entity = McUtils.mc().field_1687.method_8469(entityId);
        if (entity != null) {
            return entity;
        }
        if (entityId == -1) {
            return new class_1531((class_1937)McUtils.mc().field_1687, 0.0, 0.0, 0.0);
        }
        return null;
    }

    private void removeTotem(int totem) {
        WynntilsMod.postEvent(new TotemEvent.Removed(totem, this.totems[totem - 1]));
        this.totems[totem - 1] = null;
        this.timerlessTotemVisibleIds[totem - 1] = null;
        this.nextTotemSlot = totem;
    }

    private void removeAllTotems() {
        for (int i = 1; i <= 4; ++i) {
            this.removeTotem(i);
        }
        this.nextTotemSlot = 1;
    }

    private int getNextTotemSlot() {
        int toReturn = this.nextTotemSlot;
        this.nextTotemSlot = this.nextTotemSlot == 4 ? 1 : ++this.nextTotemSlot;
        return toReturn;
    }

    private ShamanTotem getBoundTotem(int timerId) {
        for (ShamanTotem totem : this.totems) {
            if (totem == null || totem.getTimerEntityId() != timerId) continue;
            return totem;
        }
        return null;
    }

    private boolean isClose(class_2374 pos1, class_2374 pos2) {
        class_746 player = McUtils.player();
        double dX = player.method_23317() - player.field_6038;
        double dZ = player.method_23321() - player.field_5989;
        double dY = player.method_23318() - player.field_5971;
        double speedMultiplier = Math.sqrt(dX * dX + dZ * dZ + dY * dY) * 20.0;
        speedMultiplier = Math.max(speedMultiplier, 1.0);
        return Math.abs(pos1.method_10216() - pos2.method_10216()) < speedMultiplier && Math.abs(pos1.method_10214() - pos2.method_10214()) < speedMultiplier && Math.abs(pos1.method_10215() - pos2.method_10215()) < speedMultiplier;
    }

    public List<ShamanTotem> getActiveTotems() {
        return Arrays.stream(this.totems).filter(Objects::nonNull).toList();
    }

    public ShamanTotem getTotem(int totemNumber) {
        if (totemNumber < 1 || totemNumber > 4) {
            return null;
        }
        return this.totems[totemNumber - 1];
    }
}

