/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.abilities.bossbars;

import com.wynntils.core.WynntilsMod;
import com.wynntils.handlers.bossbar.TrackedBar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MomentumBar
extends TrackedBar {
    private static final Pattern MOMENTUM_PATTERN = Pattern.compile("\u00a7f(?<momentum>\\d+)\u00a77 Momentum(?<max> \u00a78\\[\u00a7fMAX\u00a78\\])?");
    private int momentum = 0;
    private boolean max = false;

    public MomentumBar() {
        super(MOMENTUM_PATTERN);
    }

    public int getMomentum() {
        return this.momentum;
    }

    public boolean isMax() {
        return this.max;
    }

    @Override
    public void onUpdateName(Matcher match) {
        try {
            this.max = match.group("max") != null;
            this.momentum = Integer.parseInt(match.group("momentum"));
        }
        catch (NumberFormatException e) {
            WynntilsMod.error(String.format("Failed to parse momentum count for momentum bar (%s)", match.group("momentum")));
        }
    }

    @Override
    public void onUpdateProgress(float progress) {
        this.updateValue((int)(progress * 100.0f), 100);
    }
}

