/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.activities.discoveries;

import com.wynntils.core.WynntilsMod;
import com.wynntils.core.components.Managers;
import com.wynntils.core.components.Model;
import com.wynntils.core.components.Models;
import com.wynntils.core.net.ApiResponse;
import com.wynntils.core.net.UrlId;
import com.wynntils.core.text.StyledText;
import com.wynntils.models.activities.discoveries.DiscoveryInfo;
import com.wynntils.models.activities.event.ActivityUpdatedEvent;
import com.wynntils.models.activities.type.ActivityInfo;
import com.wynntils.models.activities.type.ActivitySortOrder;
import com.wynntils.models.activities.type.ActivityType;
import com.wynntils.models.activities.type.DiscoveryType;
import com.wynntils.models.marker.MarkerModel;
import com.wynntils.screens.maps.MainMapScreen;
import com.wynntils.utils.mc.McUtils;
import com.wynntils.utils.mc.type.Location;
import com.wynntils.utils.type.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_2561;

public final class DiscoveryModel
extends Model {
    private final Map<String, DiscoveryStorage> discoveryStorage = new HashMap<String, DiscoveryStorage>();

    public DiscoveryModel() {
        super(List.of());
    }

    private void queryDiscoveries(boolean querySecretDiscoveries, boolean queryWorldDiscoveries, boolean queryTerritoryDiscoveries) {
        WynntilsMod.info("Requesting rescan of discoveries in Content Book");
        if (querySecretDiscoveries) {
            Models.Activity.scanContentBook(ActivityType.SECRET_DISCOVERY, this::updateSecretDiscoveriesFromQuery);
        }
        if (queryWorldDiscoveries) {
            Models.Activity.scanContentBook(ActivityType.WORLD_DISCOVERY, this::updateWorldDiscoveriesFromQuery);
        }
        if (queryTerritoryDiscoveries) {
            Models.Activity.scanContentBook(ActivityType.TERRITORIAL_DISCOVERY, this::updateTerritoryDiscoveriesFromQuery);
        }
    }

    private void updateTerritoryDiscoveriesFromQuery(List<ActivityInfo> newActivities, List<StyledText> progress) {
        ArrayList<DiscoveryInfo> newDiscoveries = new ArrayList<DiscoveryInfo>();
        for (ActivityInfo activity : newActivities) {
            if (activity.type() != ActivityType.TERRITORIAL_DISCOVERY) {
                WynntilsMod.warn("Incorrect territory discovery activity type received: " + String.valueOf(activity));
                continue;
            }
            DiscoveryInfo discoveryInfo = this.getDiscoveryInfoFromActivity(activity);
            newDiscoveries.add(discoveryInfo);
        }
        this.discoveryStorage.put(Models.Character.getId(), this.discoveryStorage.getOrDefault(Models.Character.getId(), DiscoveryStorage.EMPTY).with(DiscoveryType.TERRITORY, newDiscoveries, progress));
        WynntilsMod.postEvent(new ActivityUpdatedEvent(ActivityType.TERRITORIAL_DISCOVERY));
    }

    private void updateWorldDiscoveriesFromQuery(List<ActivityInfo> newActivities, List<StyledText> progress) {
        ArrayList<DiscoveryInfo> newDiscoveries = new ArrayList<DiscoveryInfo>();
        for (ActivityInfo activity : newActivities) {
            if (activity.type() != ActivityType.WORLD_DISCOVERY) {
                WynntilsMod.warn("Incorrect discovery activity type received: " + String.valueOf(activity));
                continue;
            }
            DiscoveryInfo discoveryInfo = this.getDiscoveryInfoFromActivity(activity);
            newDiscoveries.add(discoveryInfo);
        }
        this.discoveryStorage.put(Models.Character.getId(), this.discoveryStorage.getOrDefault(Models.Character.getId(), DiscoveryStorage.EMPTY).with(DiscoveryType.WORLD, newDiscoveries, progress));
        WynntilsMod.postEvent(new ActivityUpdatedEvent(ActivityType.WORLD_DISCOVERY));
    }

    private void updateSecretDiscoveriesFromQuery(List<ActivityInfo> newActivities, List<StyledText> progress) {
        ArrayList<DiscoveryInfo> newDiscoveries = new ArrayList<DiscoveryInfo>();
        for (ActivityInfo activity : newActivities) {
            if (activity.type() != ActivityType.SECRET_DISCOVERY) {
                WynntilsMod.warn("Incorrect secret discovery activity type received: " + String.valueOf(activity));
                continue;
            }
            DiscoveryInfo discoveryInfo = this.getDiscoveryInfoFromActivity(activity);
            newDiscoveries.add(discoveryInfo);
        }
        this.discoveryStorage.put(Models.Character.getId(), this.discoveryStorage.getOrDefault(Models.Character.getId(), DiscoveryStorage.EMPTY).with(DiscoveryType.SECRET, newDiscoveries, progress));
        WynntilsMod.postEvent(new ActivityUpdatedEvent(ActivityType.SECRET_DISCOVERY));
    }

    private DiscoveryInfo getDiscoveryInfoFromActivity(ActivityInfo activity) {
        return DiscoveryInfo.fromActivityInfo(activity);
    }

    public List<class_2561> getDiscoveriesTooltip() {
        return Stream.concat(this.getTooltipForType(DiscoveryType.TERRITORY).stream().map(StyledText::getComponent), this.getTooltipForType(DiscoveryType.WORLD).stream().map(StyledText::getComponent)).collect(Collectors.toList());
    }

    public List<class_2561> getSecretDiscoveriesTooltip() {
        return this.getTooltipForType(DiscoveryType.SECRET).stream().map(StyledText::getComponent).collect(Collectors.toList());
    }

    public Stream<DiscoveryInfo> getAllDiscoveries(ActivitySortOrder sortOrder) {
        if (sortOrder == ActivitySortOrder.DISTANCE) {
            throw new IllegalArgumentException("Cannot sort discoveries by distance");
        }
        Stream<DiscoveryInfo> baseStream = Stream.of(new DiscoveryInfo[0]);
        for (DiscoveryType type : DiscoveryType.values()) {
            baseStream = Stream.concat(baseStream, this.discoveryStorage.getOrDefault(Models.Character.getId(), DiscoveryStorage.EMPTY).getDiscoveries(type).stream());
        }
        return switch (sortOrder) {
            default -> throw new MatchException(null, null);
            case ActivitySortOrder.LEVEL -> baseStream.sorted(Comparator.comparing(DiscoveryInfo::discovered).thenComparing(DiscoveryInfo::minLevel).thenComparing(DiscoveryInfo::name));
            case ActivitySortOrder.ALPHABETIC -> baseStream.sorted(Comparator.comparing(DiscoveryInfo::discovered).thenComparing(DiscoveryInfo::name).thenComparing(DiscoveryInfo::minLevel));
            case ActivitySortOrder.DISTANCE -> null;
        };
    }

    public Stream<DiscoveryInfo> getAllCompletedDiscoveries(ActivitySortOrder sortOrder) {
        return this.getAllDiscoveries(sortOrder).filter(DiscoveryInfo::discovered);
    }

    public Stream<DiscoveryInfo> getAllDiscoveriesForType(DiscoveryType type) {
        DiscoveryStorage storage = this.discoveryStorage.getOrDefault(Models.Character.getId(), DiscoveryStorage.EMPTY);
        return storage.getDiscoveries(type).stream();
    }

    public List<StyledText> getTooltipForType(DiscoveryType type) {
        DiscoveryStorage storage = this.discoveryStorage.getOrDefault(Models.Character.getId(), DiscoveryStorage.EMPTY);
        return storage.getTooltip(type);
    }

    private void locateDiscovery(String name, DiscoveryOpenAction action) {
        ApiResponse apiResponse = Managers.Net.callApi(UrlId.API_WIKI_DISCOVERY_QUERY, Map.of("name", name));
        apiResponse.handleJsonObject(json -> {
            int z;
            int x;
            if (json.has("error")) {
                McUtils.sendErrorToClient("Unable to find discovery coordinates. (Wiki page not found)");
                return;
            }
            String wikiText = json.get("parse").getAsJsonObject().get("wikitext").getAsJsonObject().get("*").getAsString().replace(" ", "").replace("\n", "");
            String xLocation = wikiText.substring(wikiText.indexOf("xcoordinate="));
            String zLocation = wikiText.substring(wikiText.indexOf("zcoordinate="));
            int xEnd = Math.min(xLocation.indexOf(124), xLocation.indexOf("}}"));
            int zEnd = Math.min(zLocation.indexOf(124), zLocation.indexOf("}}"));
            try {
                x = Integer.parseInt(xLocation.substring(12, xEnd));
                z = Integer.parseInt(zLocation.substring(12, zEnd));
            }
            catch (NumberFormatException e) {
                McUtils.sendErrorToClient("Unable to find discovery coordinates. (Wiki template not located)");
                return;
            }
            if (x == 0 && z == 0) {
                McUtils.sendErrorToClient("Unable to find discovery coordinates. (Wiki coordinates not located)");
                return;
            }
            switch (action.ordinal()) {
                case 0: {
                    Managers.TickScheduler.scheduleNextTick(() -> McUtils.setScreen(MainMapScreen.create(x, z)));
                    break;
                }
                case 1: {
                    MarkerModel.USER_WAYPOINTS_PROVIDER.addLocation(new Location(x, 0, z), name);
                }
            }
        });
    }

    public void reloadDiscoveries(boolean querySecretDiscoveries, boolean queryWorldDiscoveries, boolean queryTerritoryDiscoveries) {
        this.queryDiscoveries(querySecretDiscoveries, queryWorldDiscoveries, queryTerritoryDiscoveries);
    }

    private record DiscoveryStorage(Map<DiscoveryType, Pair<List<DiscoveryInfo>, List<StyledText>>> storedInfoPerType) {
        private static final DiscoveryStorage EMPTY = new DiscoveryStorage(Map.of());

        private DiscoveryStorage with(DiscoveryType type, List<DiscoveryInfo> discoveries, List<StyledText> tooltip) {
            HashMap<DiscoveryType, Pair<List<DiscoveryInfo>, List<StyledText>>> newStoredInfo = new HashMap<DiscoveryType, Pair<List<DiscoveryInfo>, List<StyledText>>>(this.storedInfoPerType);
            newStoredInfo.put(type, Pair.of(Collections.unmodifiableList(discoveries), Collections.unmodifiableList(tooltip)));
            return new DiscoveryStorage(newStoredInfo);
        }

        private List<DiscoveryInfo> getDiscoveries(DiscoveryType type) {
            return this.storedInfoPerType.getOrDefault((Object)type, Pair.of(List.of(), List.of())).key();
        }

        private List<StyledText> getTooltip(DiscoveryType type) {
            return this.storedInfoPerType.getOrDefault((Object)type, Pair.of(List.of(), List.of())).value();
        }
    }

    public static enum DiscoveryOpenAction {
        MAP,
        COMPASS;

    }
}

