/*
 * Decompiled with CFR 0.152.
 */
package com.wynntils.models.character.type;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public record SavableSkillPointSet(int strength, int dexterity, int intelligence, int defence, int agility, String weapon, List<String> armourNames, List<String> accessoryNames) {
    public SavableSkillPointSet(int[] skillPoints) {
        this(skillPoints, null, new ArrayList<String>(), new ArrayList<String>());
    }

    public SavableSkillPointSet(int[] skillPoints, String weapon, List<String> armourNames, List<String> accessoryNames) {
        this(skillPoints[0], skillPoints[1], skillPoints[2], skillPoints[3], skillPoints[4], weapon, Collections.unmodifiableList(armourNames), Collections.unmodifiableList(accessoryNames));
    }

    public int[] getSkillPointsAsArray() {
        return new int[]{this.strength, this.dexterity, this.intelligence, this.defence, this.agility};
    }

    public int getSkillPointsSum() {
        return this.strength + this.dexterity + this.intelligence + this.defence + this.agility;
    }

    public int getMinimumCombatLevel() {
        return (int)Math.ceil((double)this.getSkillPointsSum() / 2.0) + 1;
    }

    public boolean isBuild() {
        return this.weapon != null || !this.armourNames.isEmpty() || !this.accessoryNames.isEmpty();
    }
}

